/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.morevillagers.mixin;

import com.frikinjay.morevillagers.MoreVillagers;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_492;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_492.class})
public abstract class MerchantScreenMixin
extends class_465<class_1728>
implements class_4068 {
    @Unique
    private static final Set<String> PROFESSION_SET = new HashSet<String>();
    @Unique
    private static boolean morevillagers$professionsLoaded = false;

    public MerchantScreenMixin(class_1728 abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)abstractContainerMenu, inventory, component);
    }

    @Unique
    private static void morevillagers$loadProfessions() {
        if (morevillagers$professionsLoaded) {
            return;
        }
        PROFESSION_SET.clear();
        String lang = class_310.method_1551().method_1526().method_4669();
        String langPath = "/assets/morevillagers/lang/" + lang + ".json";
        try (InputStream inputStream = MoreVillagers.class.getResourceAsStream(langPath);){
            if (inputStream != null) {
                class_2477.method_29425((InputStream)inputStream, (key, value) -> {
                    if (key.startsWith("entity.minecraft.villager.morevillagers.")) {
                        PROFESSION_SET.add(key.substring(key.lastIndexOf(46) + 1));
                    }
                });
                morevillagers$professionsLoaded = true;
            } else {
                MoreVillagers.LOGGER.warn("Could not find language file: {}", (Object)langPath);
            }
        }
        catch (IOException e) {
            MoreVillagers.LOGGER.error("Failed to load professions from language file: {}", (Object)langPath, (Object)e);
        }
        catch (JsonParseException e) {
            MoreVillagers.LOGGER.error("Failed to parse language file: {}", (Object)langPath, (Object)e);
        }
    }

    @Unique
    private class_2561 morevillagers$modifyTitle(class_2561 original) {
        MerchantScreenMixin.morevillagers$loadProfessions();
        String titleText = this.field_22785.getString();
        for (String profession : PROFESSION_SET) {
            if (!titleText.toLowerCase().contains(profession)) continue;
            String translationKey = "entity.minecraft.villager.morevillagers." + profession;
            int level = ((class_1728)this.field_2797).method_19258();
            if (level <= 0 || level > 5 || !((class_1728)this.field_2797).method_19259()) continue;
            return class_2561.method_43471((String)translationKey);
        }
        return original;
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")})
    private void modifyTitleBeforeRendering(class_332 guiGraphics, int mouseX, int mouseY, CallbackInfo ci) {
        class_2561 modifiedTitle = this.morevillagers$modifyTitle(this.field_22785);
        if (modifiedTitle != this.field_22785) {
            this.field_22785 = modifiedTitle;
        }
    }
}

