package io.github.kawaiicakes.vs_hitnrun;

import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrushingDamageSource extends DamageSource {
    private final float mass;

    public CrushingDamageSource(Holder<DamageType> holder, float mass) {
        super(holder);
        this.mass = mass;
    }

    @Override
    public Component m_6157_(LivingEntity livingEntity) {
        final String crushed = this.mass >= VSHitNRunConfig.SERVER.getHeavyMass() ? "heavy" : "light";

        return Component.m_237110_("death.attack.vs_hitnrun.crushed." + crushed, livingEntity.m_5446_());
    }
}
