package io.github.kawaiicakes.vs_hitnrun;


import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.phys.Vec3;
import org.valkyrienskies.core.impl.config.VSConfigClass;

import static net.minecraft.world.damagesource.DamageTypes.f_268576_;

public class VSHitNRun {
    public static final String MOD_ID = "vs_hitnrun";

    public static DamageSource crushed(DamageSources instance, float mass) {
        return new CrushingDamageSource(instance.f_268645_.m_246971_(f_268576_), mass);
    }

    public static DamageSource rammed(DamageSources instance, Vec3 deltaV, float mass) {
        return new RammingDamageSource(instance.f_268645_.m_246971_(f_268576_), deltaV, mass);
    }

    public static void init() {
        VSConfigClass.Companion.registerConfig("vs_hitnrun", VSHitNRunConfig.class);
    }

    public static void initClient() {}
}
