package io.github.kawaiicakes.vs_hitnrun.mixin;

import io.github.kawaiicakes.vs_hitnrun.VSHitNRun;
import io.github.kawaiicakes.vs_hitnrun.VSHitNRunConfig;
import io.github.kawaiicakes.vs_hitnrun.mixinterface.Roadkillable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

import javax.annotation.ParametersAreNonnullByDefault;
import java.util.function.Supplier;

@Mixin(Entity.class)
public abstract class EntityMixin implements Roadkillable {
    @Shadow public abstract void push(double x, double y, double z);
    @Shadow public abstract double getY();
    @Shadow public abstract double getX();
    @Shadow public abstract double getZ();
    @Shadow public abstract SoundSource getSoundSource();
    @Shadow public abstract boolean hurt(DamageSource source, float amount);
    @Shadow public abstract DamageSources damageSources();

    @Override
    @ParametersAreNonnullByDefault
    public void vs_hitnrun$onRoadkill(
            ServerLevel serverLevel, Vec3 deltaV, double shipMass, EntityDraggingInformation info
    ) {
        final double damageCoefficient = VSHitNRunConfig.SERVER.getDamageCoefficient();
        final double minDamage = VSHitNRunConfig.SERVER.getMinDamage();
        final double maxDamage = VSHitNRunConfig.SERVER.getMaxDamage();
        final double knockbackCoefficient = VSHitNRunConfig.SERVER.getKnockbackCoefficient();
        final double minKnockback = VSHitNRunConfig.SERVER.getMinKnockback();
        final double maxKnockback = VSHitNRunConfig.SERVER.getMaxKnockback();
        final double crushingMultiplier = VSHitNRunConfig.SERVER.getCrushingMultiplier();

        final Vec3 added = VectorConversionsMCKt.toMinecraft(info.getAddedMovementLastTick());
        final Vec2 normalizedDeltaV = new Vec2((float) added.f_82479_, (float) added.f_82481_).m_165902_();
        final float yRotFromDeltaV = (float) Mth.m_14136_(normalizedDeltaV.f_82471_, normalizedDeltaV.f_82470_);
        final double equivalentKnockbackLevel = Mth.m_14008_(
                knockbackCoefficient * 0.5 * shipMass * (deltaV.m_82556_() * 400),
                minKnockback,
                maxKnockback
        );
        this.push(
                -Mth.m_14031_(yRotFromDeltaV * ((float)Math.PI / 180)) * equivalentKnockbackLevel,
                0.1,
                Mth.m_14089_(yRotFromDeltaV * ((float)Math.PI / 180)) * equivalentKnockbackLevel
        );

        final boolean isCrushing = deltaV.m_165925_() < deltaV.f_82480_ * deltaV.f_82480_;

        final Supplier<DamageSource> function = isCrushing
                ? () -> VSHitNRun.crushed(this.damageSources(), (float) shipMass)
                : () -> VSHitNRun.rammed(this.damageSources(), deltaV, (float) shipMass);

        double rawDamage = damageCoefficient * 0.5 * shipMass * (deltaV.m_82556_() * 400);
        if (isCrushing) rawDamage *= crushingMultiplier;
        this.hurt(function.get(), (float) Mth.m_14008_(
                rawDamage,
                minDamage,
                maxDamage
                )
        );

        serverLevel.m_6263_(
                null,
                this.getX(), this.getY(), this.getZ(),
                SoundEvents.f_12314_, this.getSoundSource(),
                (float) Mth.m_14008_(rawDamage / 10, 0.5, 3.0), 1.0f
        );
    }
}
