package io.github.kawaiicakes.vs_hitnrun.mixin;

import io.github.kawaiicakes.vs_hitnrun.VSHitNRun;
import io.github.kawaiicakes.vs_hitnrun.VSHitNRunConfig;
import io.github.kawaiicakes.vs_hitnrun.mixinterface.Roadkillable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

import javax.annotation.ParametersAreNonnullByDefault;
import java.util.function.Supplier;

@Mixin(LivingEntity.class)
public abstract class LivingEntityMixin extends Entity implements Roadkillable {
    @Shadow public abstract void knockback(double strength, double x, double z);

    @Shadow public abstract float getHealth();

    @Override
    @ParametersAreNonnullByDefault
    public void vs_hitnrun$onRoadkill(
            ServerLevel serverLevel, Vec3 deltaV, double mass, EntityDraggingInformation info
    ) {
        final double damageCoefficient = VSHitNRunConfig.SERVER.getDamageCoefficient();
        final double minDamage = VSHitNRunConfig.SERVER.getMinDamage();
        final double maxDamage = VSHitNRunConfig.SERVER.getMaxDamage();
        final double knockbackCoefficient = VSHitNRunConfig.SERVER.getKnockbackCoefficient();
        final double minKnockback = VSHitNRunConfig.SERVER.getMinKnockback();
        final double maxKnockback = VSHitNRunConfig.SERVER.getMaxKnockback();
        final double crushingMultiplier = VSHitNRunConfig.SERVER.getCrushingMultiplier();

        final Vec3 added = VectorConversionsMCKt.toMinecraft(info.getAddedMovementLastTick());
        final Vec2 normalizedDeltaV = new Vec2((float) added.f_82479_, (float) added.f_82481_).m_165902_();
        final float yRotFromDeltaV = (float) Mth.m_14136_(normalizedDeltaV.f_82471_, normalizedDeltaV.f_82470_);
        final double equivalentKnockbackLevel = Mth.m_14008_(
                knockbackCoefficient * 0.5 * mass * (deltaV.m_82556_() * 400),
                minKnockback,
                maxKnockback
        );
        this.knockback(
                equivalentKnockbackLevel * 1.2f,
                Mth.m_14031_(yRotFromDeltaV * ((float)Math.PI / 180)),
                -Mth.m_14089_(yRotFromDeltaV * ((float)Math.PI / 180))
        );

        final float oldHealth = this.getHealth();
        final boolean isCrushing = deltaV.m_165925_() < deltaV.f_82480_ * deltaV.f_82480_;

        final Supplier<DamageSource> function = isCrushing
                ? () -> VSHitNRun.crushed(this.m_269291_(), (float) mass)
                : () -> VSHitNRun.rammed(this.m_269291_(), deltaV, (float) mass);

        double rawDamage = damageCoefficient * 0.5 * mass * (deltaV.m_82556_() * 400);
        if (isCrushing) rawDamage *= crushingMultiplier;
        this.m_6469_(function.get(), (float) Mth.m_14008_(
                        rawDamage,
                        minDamage,
                        maxDamage
                )
        );
        final float newHealth = this.getHealth();
        final float healthDiff = oldHealth - newHealth;

        if (healthDiff <= 0) return;

        serverLevel.m_6263_(
                null,
                this.m_20185_(), this.m_20186_(), this.m_20189_(),
                SoundEvents.f_12314_, this.m_5720_(),
                (float) Mth.m_14008_(rawDamage / 10, 0.5, 3.0), 1.0f
        );

        serverLevel.m_8767_(
                ParticleTypes.f_123798_,
                this.m_20185_(), this.m_20227_(0.5), this.m_20189_(),
                (int) healthDiff / 2,
                0.1, 0.0, 0.1, Mth.m_14008_(rawDamage / 20, 0.2, 1.0)
        );
    }

    private LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }
}
