/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.pixeldreamstudios.attributepanel.client.AttributeDescriptionProvider;
import net.pixeldreamstudios.attributepanel.client.BookAttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.client.CompactAttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.client.StatEntry;
import net.pixeldreamstudios.attributepanel.client.VanillaAttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.compat.TrinketCompat;
import net.pixeldreamstudios.attributepanel.config.AttributesPanelConfig;

@Environment(value=EnvType.CLIENT)
public class AttributePanelDrawable
implements class_4068,
class_364,
class_6379 {
    protected final class_310 client = class_310.method_1551();
    protected final int x;
    protected final int y;
    protected final int width;
    protected int height;
    protected boolean expanded = false;
    protected int currentPage = 0;
    protected boolean showOnlyChanged = true;
    public static final int MAX_ROWS = 6;
    protected final List<StatEntry> cachedStats = new ArrayList<StatEntry>();
    protected List<class_2561> queuedTooltip = null;
    protected List<class_1799> queuedTooltipIcons = null;
    protected List<class_2960> queuedTooltipTextures = null;
    protected int tooltipX;
    protected int tooltipY;
    private final BookAttributePanelDrawable bookGui;
    private final VanillaAttributePanelDrawable vanillaGui;
    private final CompactAttributePanelDrawable compactGui;

    public AttributePanelDrawable(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.bookGui = new BookAttributePanelDrawable(this);
        this.vanillaGui = new VanillaAttributePanelDrawable(this);
        this.compactGui = new CompactAttributePanelDrawable(this);
    }

    public void setHeightFromInventory(int inventoryHeight) {
        this.height = inventoryHeight;
    }

    public void toggle() {
        this.expanded = !this.expanded;
        this.currentPage = 0;
        if (this.expanded) {
            this.cacheStats();
        }
    }

    public void tick() {
        if (this.expanded) {
            this.cacheStats();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.expanded) {
            return;
        }
        switch (AttributesPanelConfig.INSTANCE.guiStyle) {
            case BOOK: {
                this.bookGui.render(context, mouseX, mouseY, delta);
                break;
            }
            case VANILLA: {
                this.vanillaGui.render(context, mouseX, mouseY, delta);
                break;
            }
            case COMPACT: {
                this.compactGui.method_25394(context, mouseX, mouseY, delta);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.expanded) {
            return false;
        }
        return switch (AttributesPanelConfig.INSTANCE.guiStyle) {
            default -> throw new MatchException(null, null);
            case AttributesPanelConfig.GuiStyle.BOOK -> this.bookGui.mouseClicked(mouseX, mouseY, button);
            case AttributesPanelConfig.GuiStyle.VANILLA -> this.vanillaGui.mouseClicked(mouseX, mouseY, button);
            case AttributesPanelConfig.GuiStyle.COMPACT -> this.compactGui.method_25402(mouseX, mouseY, button);
        };
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.expanded) {
            return false;
        }
        boolean handled = switch (AttributesPanelConfig.INSTANCE.guiStyle) {
            default -> throw new MatchException(null, null);
            case AttributesPanelConfig.GuiStyle.BOOK -> false;
            case AttributesPanelConfig.GuiStyle.VANILLA -> false;
            case AttributesPanelConfig.GuiStyle.COMPACT -> this.compactGui.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        };
        return handled;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.expanded) {
            return false;
        }
        return switch (AttributesPanelConfig.INSTANCE.guiStyle) {
            default -> throw new MatchException(null, null);
            case AttributesPanelConfig.GuiStyle.BOOK -> false;
            case AttributesPanelConfig.GuiStyle.VANILLA -> false;
            case AttributesPanelConfig.GuiStyle.COMPACT -> this.compactGui.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        };
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.expanded) {
            return false;
        }
        return switch (AttributesPanelConfig.INSTANCE.guiStyle) {
            default -> throw new MatchException(null, null);
            case AttributesPanelConfig.GuiStyle.BOOK -> false;
            case AttributesPanelConfig.GuiStyle.VANILLA -> false;
            case AttributesPanelConfig.GuiStyle.COMPACT -> this.compactGui.method_25406(mouseX, mouseY, button);
        };
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.expanded) {
            return false;
        }
        int bgX = this.left() - 16;
        int bgY = this.top();
        int bgWidth = this.panelWidth() + 16;
        int bgHeight = this.panelHeight();
        return mouseX >= (double)bgX && mouseX <= (double)(bgX + bgWidth) && mouseY >= (double)bgY && mouseY <= (double)(bgY + bgHeight);
    }

    public void renderTooltip(class_332 context) {
        if (this.queuedTooltip == null || this.queuedTooltip.isEmpty()) {
            return;
        }
        class_327 tr = this.client.field_1772;
        int zOffset = 400;
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, (float)zOffset);
        List<class_2561> lines = this.queuedTooltip;
        List<class_1799> icons = this.queuedTooltipIcons;
        int maxWidth = 0;
        for (class_2561 line : lines) {
            maxWidth = Math.max(maxWidth, tr.method_27525((class_5348)line));
        }
        int tooltipWidth = maxWidth + 28;
        int n = lines.size();
        Objects.requireNonNull(tr);
        int tooltipHeight = n * (9 + 4) + 12;
        int screenWidth = this.client.method_22683().method_4486();
        int screenHeight = this.client.method_22683().method_4502();
        int drawX = this.tooltipX + 12;
        int drawY = this.tooltipY + 12;
        if (drawX + tooltipWidth > screenWidth) {
            drawX = screenWidth - tooltipWidth - 8;
        }
        if (drawY + tooltipHeight > screenHeight) {
            drawY = screenHeight - tooltipHeight - 8;
        }
        drawX = Math.max(drawX, 4);
        drawY = Math.max(drawY, 4);
        int backgroundColor = -267185389;
        int borderColor = -10855846;
        context.method_25296(drawX - 4, drawY - 4, drawX + tooltipWidth + 4, drawY + tooltipHeight, backgroundColor, backgroundColor);
        context.method_49601(drawX - 4, drawY - 4, tooltipWidth + 8, tooltipHeight + 1, borderColor);
        for (int i = 0; i < lines.size(); ++i) {
            Objects.requireNonNull(tr);
            int lineY = drawY + i * (9 + 4);
            class_1799 icon = this.queuedTooltipIcons != null && i < this.queuedTooltipIcons.size() ? this.queuedTooltipIcons.get(i) : class_1799.field_8037;
            class_2960 tex = this.queuedTooltipTextures != null && i < this.queuedTooltipTextures.size() ? this.queuedTooltipTextures.get(i) : null;
            int iconOffset = 0;
            if (tex != null) {
                int texSize = 12;
                context.method_25290(tex, drawX, lineY, 0.0f, 0.0f, 12, 12, 12, 12);
                iconOffset = 18;
            } else if (!icon.method_7960()) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)drawX, (float)lineY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51427(icon, 0, 0);
                context.method_51448().method_22909();
                iconOffset = 18;
            }
            int textX = drawX + iconOffset;
            context.method_51439(tr, lines.get(i), textX, lineY + 2, 0xFFFFFF, false);
        }
        context.method_51448().method_22909();
        this.queuedTooltip = null;
        this.queuedTooltipIcons = null;
    }

    protected void cacheStats() {
        this.cachedStats.clear();
        class_746 player = this.client.field_1724;
        if (player == null) {
            return;
        }
        for (class_6880 entry : class_7923.field_41190.method_40270().toList()) {
            boolean isPercent;
            class_1320 attr = (class_1320)entry.comp_349();
            class_1324 instance = player.method_5996(entry);
            if (instance == null) continue;
            class_2960 attrId = class_7923.field_41190.method_10221((Object)attr);
            String idStr = attrId == null ? "" : attrId.toString();
            String tkey = attr.method_26830().toLowerCase(Locale.ROOT);
            double rawBase = instance.method_6201();
            double rawValue = instance.method_6194();
            static enum Mode {
                NONE,
                FRACTION_0_TO_1,
                BASE_100;

            }
            Mode mode = Mode.NONE;
            if (AttributesPanelConfig.INSTANCE.percentAttributesBase100.contains(idStr)) {
                mode = Mode.BASE_100;
            } else if (AttributesPanelConfig.INSTANCE.percentAttributes.contains(idStr)) {
                mode = Mode.FRACTION_0_TO_1;
            } else if (AttributePanelDrawable.containsAny(tkey, AttributesPanelConfig.INSTANCE.percentBase100Keywords)) {
                mode = Mode.BASE_100;
            } else if (AttributePanelDrawable.containsAny(tkey, AttributesPanelConfig.INSTANCE.percentKeywords)) {
                mode = Mode.FRACTION_0_TO_1;
            }
            double baseForDisplay = rawBase;
            double valueForDisplay = rawValue;
            boolean bl = isPercent = mode != Mode.NONE;
            if (mode == Mode.BASE_100) {
                baseForDisplay = 0.0;
                valueForDisplay = (rawValue - rawBase) / rawBase;
            }
            if (this.showOnlyChanged && AttributesPanelConfig.INSTANCE.guiStyle != AttributesPanelConfig.GuiStyle.COMPACT && (Double.isNaN(valueForDisplay) || Math.abs(baseForDisplay - valueForDisplay) < 0.001)) continue;
            this.cachedStats.add(new StatEntry((class_2561)class_2561.method_43471((String)attr.method_26830()), baseForDisplay, valueForDisplay, isPercent, (class_6880<class_1320>)entry));
        }
        this.cachedStats.sort((a, b) -> a.name().getString().compareToIgnoreCase(b.name().getString()));
    }

    private static boolean containsAny(String haystack, List<String> needles) {
        if (needles == null || needles.isEmpty()) {
            return false;
        }
        for (String n : needles) {
            if (n == null || n.isBlank() || !haystack.contains(n.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    protected void enqueueTooltip(List<class_2561> lines, List<class_1799> icons, int mouseX, int mouseY) {
        this.enqueueTooltipRich(lines, icons, null, mouseX, mouseY);
    }

    protected void enqueueTooltipRich(List<class_2561> lines, List<class_1799> icons, List<class_2960> textures, int mouseX, int mouseY) {
        this.queuedTooltip = lines;
        this.queuedTooltipIcons = icons;
        this.queuedTooltipTextures = textures;
        this.tooltipX = mouseX;
        this.tooltipY = mouseY;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.compactGui.wantsKeys()) {
            if (this.compactGui.handleCharTyped(chr, modifiers)) {
                return true;
            }
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.compactGui.wantsKeys()) {
            if (this.compactGui.handleKeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void drawTooltipContent(class_332 context, class_327 tr, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        boolean onValue;
        if (hoverIndex == -1 || hoverIndex >= this.cachedStats.size()) {
            return;
        }
        StatEntry stat = this.cachedStats.get(hoverIndex);
        int rowIndex = hoverIndex % 6;
        int yOffset = this.y + padding + rowIndex * rowHeight;
        int midX = this.x + this.width / 2;
        boolean onName = mouseX >= this.x && mouseX <= midX;
        boolean bl = onValue = mouseX > midX && mouseX <= this.x + this.width;
        if (onName) {
            AttributeDescriptionProvider.TooltipContents tooltip = AttributeDescriptionProvider.getTooltip((class_1320)stat.attribute().comp_349());
            this.queuedTooltip = tooltip.lines();
            this.queuedTooltipIcons = tooltip.icons();
            this.tooltipX = mouseX;
            this.tooltipY = mouseY;
            return;
        }
        if (!onValue) {
            return;
        }
        boolean shiftDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)this.client.field_1690.field_1832.method_1429().method_1444());
        ArrayList<Double> flatComponents = new ArrayList<Double>();
        ArrayList<Double> baseMultComponents = new ArrayList<Double>();
        ArrayList<Double> totalMultComponents = new ArrayList<Double>();
        class_1324 instance = this.client.field_1724.method_5996(stat.attribute());
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        ArrayList<class_1799> iconStacks = new ArrayList<class_1799>();
        tooltipLines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.base", (Object[])new Object[]{String.format("%.2f", stat.base())}));
        iconStacks.add(class_1799.field_8037);
        if (instance != null) {
            tooltipLines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.final", (Object[])new Object[]{String.format("%.2f", instance.method_6194())}));
            iconStacks.add(class_1799.field_8037);
        }
        double flat = 0.0;
        double multBase = 0.0;
        double multTotal = 0.0;
        double puffFlat = 0.0;
        double puffBase = 0.0;
        double puffTotal = 0.0;
        boolean hasPuffish = false;
        ArrayList<TrinketCompat.TrinketModifierSource> unmatchedTrinketSources = new ArrayList<TrinketCompat.TrinketModifierSource>();
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            unmatchedTrinketSources.addAll(TrinketCompat.getTrinketModifierSources((class_1657)this.client.field_1724));
        }
        if (instance != null && !instance.method_6195().isEmpty()) {
            tooltipLines.add((class_2561)class_2561.method_43473());
            iconStacks.add(class_1799.field_8037);
            tooltipLines.add((class_2561)class_2561.method_43471((String)"attributepanel.message.modifiers").method_27692(class_124.field_1054));
            iconStacks.add(class_1799.field_8037);
            for (class_1322 mod : instance.method_6195()) {
                Set<String> ignoredArmorNames;
                String[] pathParts;
                Object opText;
                class_124 color;
                String fullPath;
                String[] tieredParts;
                class_2960 rawId = mod.comp_2447();
                if (rawId.method_12836().equals("tiered") && (tieredParts = (fullPath = rawId.method_12832()).split("/")).length >= 3 && tieredParts[tieredParts.length - 1].contains("_")) {
                    fullPath = tieredParts[tieredParts.length - 1];
                    rawId = class_2960.method_60655((String)"tiered", (String)fullPath);
                }
                if (rawId.method_12836().equals("puffish_skills")) {
                    hasPuffish = true;
                    switch (mod.comp_2450()) {
                        case field_6328: {
                            puffFlat += mod.comp_2449();
                            break;
                        }
                        case field_6330: {
                            puffBase += mod.comp_2449();
                            break;
                        }
                        case field_6331: {
                            puffTotal += mod.comp_2449();
                        }
                    }
                    continue;
                }
                switch (mod.comp_2450()) {
                    case field_6328: {
                        double value = mod.comp_2449();
                        flat += value;
                        flatComponents.add(value);
                        color = value >= 0.0 ? class_124.field_1060 : class_124.field_1061;
                        String sign = value >= 0.0 ? "+" : "";
                        opText = sign + String.format("%.2f", value);
                        break;
                    }
                    case field_6330: {
                        double value = mod.comp_2449();
                        multBase += value;
                        baseMultComponents.add(value);
                        int percent = (int)Math.round(value * 100.0);
                        color = percent >= 0 ? class_124.field_1060 : class_124.field_1061;
                        String sign = percent >= 0 ? "+" : "";
                        opText = sign + percent + "% Base";
                        break;
                    }
                    case field_6331: {
                        double value = mod.comp_2449();
                        multTotal += value;
                        totalMultComponents.add(value);
                        int percent = (int)Math.round(value * 100.0);
                        color = percent >= 0 ? class_124.field_1060 : class_124.field_1061;
                        String sign = percent >= 0 ? "+" : "";
                        opText = sign + percent + "% Total";
                        break;
                    }
                    default: {
                        opText = "?";
                        color = class_124.field_1080;
                    }
                }
                String fullPath2 = rawId.method_12832();
                String[] parts = fullPath2.split("\\.", 2);
                class_2960 modId = class_2960.method_60655((String)rawId.method_12836(), (String)parts[0]);
                Iterator customName = parts.length > 1 ? parts[1] : null;
                boolean usedCustomName = false;
                class_1799 matchingStack = new class_1799((class_1935)class_7923.field_41178.method_10223(modId));
                class_5250 displayName = class_2561.method_43470((String)AttributePanelDrawable.formatModifierId(modId));
                boolean foundSource = false;
                for (class_1304 slot : class_1304.values()) {
                    class_1799 stack = this.client.field_1724.method_6118(slot);
                    if (stack.method_7960()) continue;
                    boolean[] matched = new boolean[]{false};
                    class_9285 component = (class_9285)stack.method_57824(class_9334.field_49636);
                    if (component != null) {
                        component.method_57482(slot, (attr, entryMod) -> {
                            if (entryMod.comp_2447().equals((Object)mod.comp_2447()) && attr.equals(stat.attribute())) {
                                matched[0] = true;
                            }
                        });
                    }
                    if (!matched[0]) {
                        stack.method_7909().method_7844().method_57482(slot, (attr, entryMod) -> {
                            if (entryMod.comp_2447().equals((Object)mod.comp_2447()) && attr.equals(stat.attribute())) {
                                matched[0] = true;
                            }
                        });
                    }
                    if (!matched[0]) continue;
                    matchingStack = stack;
                    if (!stack.method_7960() && stack.method_7909() != class_1802.field_8162 && !usedCustomName) {
                        try {
                            displayName = stack.method_7964().method_27661();
                        }
                        catch (Exception e) {
                            displayName = class_2561.method_43470((String)stack.method_7909().toString()).method_27692(class_124.field_1080);
                        }
                    }
                    foundSource = true;
                    break;
                }
                if (!foundSource && (pathParts = modId.method_12832().split("/")).length > 0) {
                    String itemGuess = pathParts[pathParts.length - 1];
                    class_2960 itemId = class_2960.method_60655((String)modId.method_12836(), (String)itemGuess);
                    if (class_7923.field_41178.method_10250(itemId)) {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                        matchingStack = new class_1799((class_1935)item);
                        displayName = matchingStack.method_7964().method_27661().method_27692(matchingStack.method_7932().method_58413());
                        foundSource = true;
                    }
                }
                if (customName != null && !((String)((Object)customName)).isBlank() && !(ignoredArmorNames = Set.of("helmet", "chestplate", "leggings", "boots")).contains(((String)((Object)customName)).toLowerCase())) {
                    String pretty = Arrays.stream(((String)((Object)customName)).split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase()).collect(Collectors.joining(" "));
                    displayName = class_2561.method_43470((String)pretty).method_27692(class_124.field_1076);
                    usedCustomName = true;
                }
                if (!foundSource && FabricLoader.getInstance().isModLoaded("trinkets")) {
                    Iterator iter = unmatchedTrinketSources.iterator();
                    while (iter.hasNext()) {
                        TrinketCompat.TrinketModifierSource source = (TrinketCompat.TrinketModifierSource)iter.next();
                        if (!((class_1320)source.id().comp_349()).equals(stat.attribute().comp_349()) || source.modifier().comp_2450() != mod.comp_2450() || !(Math.abs(source.modifier().comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        matchingStack = source.stack();
                        if (!matchingStack.method_7960() && matchingStack.method_7909() != class_1802.field_8162) {
                            try {
                                displayName = matchingStack.method_7964().method_27661().method_27692(matchingStack.method_7932().method_58413());
                            }
                            catch (Exception e) {
                                displayName = class_2561.method_43470((String)"Unknown Trinket").method_27692(class_124.field_1080);
                            }
                        } else {
                            displayName = class_2561.method_43470((String)"Unknown Trinket").method_27692(class_124.field_1080);
                        }
                        foundSource = true;
                        iter.remove();
                        break;
                    }
                }
                if (!foundSource) {
                    for (class_1293 entry : this.client.field_1724.method_6026()) {
                        class_1322 potionMod;
                        class_1291 effect = (class_1291)entry.method_5579().comp_349();
                        int amplifier = entry.method_5578();
                        class_1320 attr2 = (class_1320)stat.attribute().comp_349();
                        HashMap effectMods = new HashMap();
                        effect.method_55650(amplifier, (attribute, modifier) -> effectMods.put((class_1320)attribute.comp_349(), modifier));
                        if (!effectMods.containsKey(attr2) || (potionMod = (class_1322)effectMods.get(attr2)).comp_2450() != mod.comp_2450() || !(Math.abs(potionMod.comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        displayName = class_2561.method_43471((String)effect.method_5567());
                        matchingStack = this.createColoredPotionItem(effect);
                        foundSource = true;
                        break;
                    }
                }
                if (modId.method_12836().equals("tiered")) {
                    String path = modId.method_12832();
                    String[] pathParts2 = path.split("_");
                    String tierRarity = pathParts2.length > 0 ? pathParts2[0] : "Tiered";
                    String tierName = tierRarity.substring(0, 1).toUpperCase() + tierRarity.substring(1).toLowerCase();
                    class_5250 tierLine = class_2561.method_43470((String)(tierName + " Bonus: ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(class_124.field_1060));
                    tooltipLines.add((class_2561)tierLine);
                    iconStacks.add(new class_1799((class_1935)class_1802.field_8782));
                    continue;
                }
                class_5250 displayLine = displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color));
                tooltipLines.add((class_2561)displayLine);
                iconStacks.add(matchingStack);
            }
            if (hasPuffish) {
                tooltipLines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.skill_tree_bonus").method_27692(class_124.field_1075));
                iconStacks.add(class_1799.field_8037);
                if (puffFlat != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("- %+,.2f", puffFlat)).method_27692(class_124.field_1060));
                    iconStacks.add(class_1799.field_8037);
                }
                if (puffBase != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Base", (int)(puffBase * 100.0))).method_27692(class_124.field_1060));
                    iconStacks.add(class_1799.field_8037);
                }
                if (puffTotal != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Total", (int)(puffTotal * 100.0))).method_27692(class_124.field_1060));
                    iconStacks.add(class_1799.field_8037);
                }
                tooltipLines.add((class_2561)class_2561.method_43473());
                iconStacks.add(class_1799.field_8037);
            }
        }
        tooltipLines.add((class_2561)class_2561.method_43473());
        iconStacks.add(class_1799.field_8037);
        if (stat.isChanged()) {
            if (shiftDown) {
                double actualFinal;
                double indirectFlatBonus;
                double base = stat.base();
                double flatTotal = flat;
                double tieredMultTotal = 0.0;
                double nonTieredMultTotal = 0.0;
                instance = this.client.field_1724.method_5996(stat.attribute());
                if (instance != null && !instance.method_6195().isEmpty()) {
                    for (class_1322 mod : instance.method_6195()) {
                        if (mod.comp_2450() != class_1322.class_1323.field_6331) continue;
                        if (mod.comp_2447().method_12836().equals("tiered")) {
                            tieredMultTotal += mod.comp_2449();
                            continue;
                        }
                        nonTieredMultTotal += mod.comp_2449();
                    }
                }
                double basePlusAdditive = base + flatTotal;
                double afterTiered = tieredMultTotal != 0.0 ? basePlusAdditive * (1.0 + tieredMultTotal) : basePlusAdditive;
                double afterBaseMult = multBase != 0.0 ? afterTiered * (1.0 + multBase) : afterTiered;
                double finalValue = nonTieredMultTotal != 0.0 ? afterBaseMult * (1.0 + nonTieredMultTotal) : afterBaseMult;
                tooltipLines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.calculated").method_27692(class_124.field_1063));
                iconStacks.add(class_1799.field_8037);
                if (flatTotal != 0.0) {
                    String flatBreakdown = flatComponents.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f + (%s) = %.2f", base, flatBreakdown, basePlusAdditive)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                } else {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("= %.2f", base)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                }
                if (tieredMultTotal != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 %.2f = %.2f", basePlusAdditive, 1.0 + tieredMultTotal, afterTiered)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                }
                if (multBase != 0.0) {
                    String baseMultBreakdown = baseMultComponents.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", afterTiered, baseMultBreakdown, afterBaseMult)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                }
                if (nonTieredMultTotal != 0.0) {
                    ArrayList<Double> nonTieredTotalComponents = new ArrayList<Double>();
                    for (class_1322 mod : instance.method_6195()) {
                        if (mod.comp_2450() != class_1322.class_1323.field_6331 || mod.comp_2447().method_12836().equals("tiered")) continue;
                        nonTieredTotalComponents.add(mod.comp_2449());
                    }
                    String totalMultBreakdown = nonTieredTotalComponents.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    if (!nonTieredTotalComponents.isEmpty()) {
                        tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", afterBaseMult, totalMultBreakdown, finalValue)).method_27692(class_124.field_1080));
                    }
                }
                tooltipLines.add((class_2561)class_2561.method_43470((String)("= " + String.format("%.2f", finalValue))).method_27692(class_124.field_1060));
                iconStacks.add(class_1799.field_8037);
                if (instance != null && Math.abs(indirectFlatBonus = (actualFinal = instance.method_6194()) - finalValue) > 0.001 && finalValue > 0.001) {
                    double indirectPercent = indirectFlatBonus / finalValue;
                    tooltipLines.add((class_2561)class_2561.method_43473());
                    iconStacks.add(class_1799.field_8037);
                    if (indirectFlatBonus > 0.0) {
                        tooltipLines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.indirect_bonus", (Object[])new Object[]{String.format("%.2f", indirectFlatBonus)}).method_27692(class_124.field_1077));
                        iconStacks.add(class_1799.field_8037);
                        tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %.2f) = %.2f", finalValue, indirectPercent, actualFinal)).method_27692(class_124.field_1080));
                        iconStacks.add(class_1799.field_8037);
                    } else {
                        tooltipLines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.indirect_decrease", (Object[])new Object[]{String.format("%.2f", Math.abs(indirectFlatBonus))}).method_27692(class_124.field_1061));
                        iconStacks.add(class_1799.field_8037);
                        tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 - %.2f) = %.2f", finalValue, Math.abs(indirectPercent), actualFinal)).method_27692(class_124.field_1080));
                        iconStacks.add(class_1799.field_8037);
                    }
                }
            } else {
                tooltipLines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.hold_shift").method_27692(class_124.field_1080));
                iconStacks.add(class_1799.field_8037);
            }
        }
        this.queuedTooltip = tooltipLines;
        this.queuedTooltipIcons = iconStacks;
        this.tooltipX = mouseX;
        this.tooltipY = mouseY;
    }

    protected class_1799 createColoredPotionItem(class_1291 effect) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8574);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)effect.method_5567()));
        class_2487 nbt = new class_2487();
        nbt.method_10569("CustomPotionColor", 0xFF0000);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        return stack;
    }

    protected static String formatModifierId(class_2960 id) {
        String path = id.method_12832();
        if (path.contains("/")) {
            path = path.substring(0, path.indexOf(47));
        }
        String[] parts = path.split("_");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return sb.toString();
    }

    protected static boolean mouseIn(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    public class_310 mc() {
        return this.client;
    }

    public int left() {
        return this.x;
    }

    public int top() {
        return this.y;
    }

    public int panelWidth() {
        return this.width;
    }

    public int panelHeight() {
        return this.height;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int p) {
        this.currentPage = p;
    }

    public boolean getShowOnlyChanged() {
        return this.showOnlyChanged;
    }

    public void setShowOnlyChanged(boolean v) {
        this.showOnlyChanged = v;
    }

    public List<StatEntry> getCachedStats() {
        return this.cachedStats;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }
}

