/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.pixeldreamstudios.attributepanel.client.AttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.client.StatEntry;
import net.pixeldreamstudios.attributepanel.compat.TrinketCompat;

@Environment(value=EnvType.CLIENT)
class BookAttributePanelDrawable {
    private final AttributePanelDrawable root;
    private static final class_2960 BOOK_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/book.png");
    private static final class_2960 INFO_ICON = class_2960.method_60655((String)"kevs-attributes-panel", (String)"textures/gui/attribute_book.png");
    private static final int INFO_ICON_SIZE = 8;
    private static final class_2960 PERMA = class_2960.method_60655((String)"kevs-attributes-panel", (String)"textures/gui/perma.png");
    private static final class_2960 EQUIPPED = class_2960.method_60655((String)"kevs-attributes-panel", (String)"textures/gui/equipped.png");

    BookAttributePanelDrawable(AttributePanelDrawable root) {
        this.root = root;
    }

    void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 tr = this.root.mc().field_1772;
        int rowHeight = 20;
        int padding = 20;
        context.method_25290(BOOK_TEXTURE, this.root.left() - 25, this.root.top(), 0.0f, 0.0f, 240, 230, 240, 230);
        int visibleRows = 6;
        int totalPages = (int)Math.ceil((float)this.root.getCachedStats().size() / (float)visibleRows);
        this.root.setCurrentPage(Math.min(this.root.getCurrentPage(), Math.max(totalPages - 1, 0)));
        if (this.root.getShowOnlyChanged() && this.root.getCachedStats().isEmpty()) {
            String noStatsText = "No changed attributes";
            int textWidth = tr.method_1727(noStatsText);
            this.drawBookButtons(context, tr, mouseX, mouseY, this.root.top() + this.root.panelHeight() - 20);
            context.method_51433(tr, noStatsText, this.root.left() + (this.root.panelWidth() - textWidth) / 2 + 5, this.root.top() + 20, class_124.field_1063.method_532().intValue(), false);
            return;
        }
        int startIndex = this.root.getCurrentPage() * visibleRows;
        int endIndex = Math.min(startIndex + visibleRows, this.root.getCachedStats().size());
        int rowY = this.root.top() + padding;
        int hoverIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            Object valueStr;
            String topLine;
            StatEntry stat = this.root.getCachedStats().get(i);
            int rowIndex = i - startIndex;
            int yOffset = rowY + rowIndex * rowHeight;
            String statName = stat.name().getString();
            int maxNameWidth = this.root.panelWidth() / 2 - 7;
            context.method_25294(this.root.left() + 12, yOffset + rowHeight + 2, this.root.left() + this.root.panelWidth() - 12, yOffset + rowHeight + 1, -2702173);
            Object bottomLine = null;
            if (tr.method_1727(statName) <= maxNameWidth) {
                topLine = statName;
            } else {
                topLine = tr.method_27523(statName, maxNameWidth);
                String remainder = statName.substring(topLine.length()).trim();
                if (!remainder.isEmpty()) {
                    bottomLine = tr.method_27523(remainder, maxNameWidth);
                    if (tr.method_1727(remainder) > maxNameWidth) {
                        while (tr.method_1727((String)bottomLine + "...") > maxNameWidth && ((String)bottomLine).length() > 0) {
                            bottomLine = ((String)bottomLine).substring(0, ((String)bottomLine).length() - 1);
                        }
                        bottomLine = (String)bottomLine + "...";
                    }
                }
            }
            int nameX = this.root.left() + 15;
            int valueX = this.root.left() + this.root.panelWidth() - 12;
            int nameY = yOffset + (rowHeight - 8) / 2;
            if (bottomLine == null) {
                context.method_51433(tr, topLine, nameX, nameY, 3813155, false);
            } else {
                context.method_51433(tr, topLine, nameX, yOffset + 4, 3813155, false);
                context.method_51433(tr, (String)bottomLine, nameX, yOffset + 12, 7167048, false);
            }
            Object object = valueStr = stat.percent() ? String.format("%d%%", (int)(stat.current() * 100.0)) : String.format("%.2f", stat.current());
            int color = stat.isChanged() ? (stat.current() > stat.base() ? class_124.field_1060.method_532() : class_124.field_1061.method_532()) : class_124.field_1080.method_532();
            valueStr = (String)valueStr + (stat.isChanged() ? (stat.current() > stat.base() ? " \u2191" : " \u2193") : "");
            context.method_51433(tr, (String)valueStr, valueX - tr.method_1727((String)valueStr), nameY, color, false);
            if (mouseX < this.root.left() || mouseX > this.root.left() + this.root.panelWidth() || mouseY < yOffset || mouseY > yOffset + rowHeight) continue;
            hoverIndex = i;
        }
        int infoX = this.root.left() + this.root.panelWidth() - 8 - 95;
        int infoY = this.root.top() + 10;
        context.method_25290(INFO_ICON, infoX, infoY, 0.0f, 0.0f, 8, 8, 8, 8);
        if (mouseX >= infoX && mouseX <= infoX + 8 && mouseY >= infoY && mouseY <= infoY + 8) {
            this.drawGlobalBonusTooltip(mouseX, mouseY);
        }
        this.drawBookTooltipButton(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
    }

    boolean mouseClicked(double mouseX, double mouseY, int button) {
        int infoX = this.root.left() + this.root.panelWidth() - 8 - 95;
        int infoY = this.root.top() + 10;
        int btnY = this.root.top() + this.root.panelHeight() - 20;
        ButtonCoords coords = this.getBookButtonCoords(this.root.mc().field_1772);
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, coords.prevX(), btnY, coords.prevW(), 10)) {
            if (this.root.getCurrentPage() > 0) {
                this.root.setCurrentPage(this.root.getCurrentPage() - 1);
            }
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            }
            return true;
        }
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, coords.nextX(), btnY, coords.nextW(), 10)) {
            int totalPages = (int)Math.ceil((float)this.root.getCachedStats().size() / 6.0f);
            if (this.root.getCurrentPage() < totalPages - 1) {
                this.root.setCurrentPage(this.root.getCurrentPage() + 1);
            }
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            }
            return true;
        }
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, coords.checkX(), btnY, coords.checkW(), 10)) {
            this.root.setShowOnlyChanged(!this.root.getShowOnlyChanged());
            this.root.setCurrentPage(0);
            this.root.cacheStats();
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private ButtonCoords getBookButtonCoords(class_327 tr) {
        int startX;
        String prevText = "\u00ab\u00ab";
        String nextText = "\u00bb\u00bb";
        String checkLabel = "[ " + (this.root.getShowOnlyChanged() ? "\u2713" : " ") + " ]";
        int spacing = 24;
        int prevW = tr.method_1727(prevText);
        int checkW = tr.method_1727(checkLabel);
        int nextW = tr.method_1727(nextText);
        int totalWidth = prevW + spacing + checkW + spacing + nextW;
        int prevX = startX = this.root.left() + (this.root.panelWidth() - totalWidth) / 2;
        int checkX = prevX + prevW + spacing;
        int nextX = checkX + checkW + spacing;
        return new ButtonCoords(prevX, checkX, nextX, prevW, checkW, nextW);
    }

    private void drawBookButtons(class_332 context, class_327 tr, int mouseX, int mouseY, int btnY) {
        int startX;
        String prevText = "\u00ab\u00ab";
        String nextText = "\u00bb\u00bb";
        String checkLabel = "[ " + (this.root.getShowOnlyChanged() ? "\u2713" : " ") + " ]";
        int spacing = 24;
        int buttonHeight = 10;
        int prevWidth = tr.method_1727(prevText);
        int checkWidth = tr.method_1727(checkLabel);
        int nextWidth = tr.method_1727(nextText);
        int totalWidth = prevWidth + spacing + checkWidth + spacing + nextWidth;
        int prevX = startX = this.root.left() + (this.root.panelWidth() - totalWidth) / 2;
        int checkX = prevX + prevWidth + spacing;
        int nextX = checkX + checkWidth + spacing;
        context.method_51433(tr, prevText, prevX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, prevX, btnY, prevWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
        context.method_51433(tr, checkLabel, checkX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, checkX, btnY, checkWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
        context.method_51433(tr, nextText, nextX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, nextX, btnY, nextWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
    }

    private void drawBookTooltipButton(class_332 context, class_327 tr, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        if (hoverIndex >= 0 && hoverIndex < this.root.getCachedStats().size()) {
            StatEntry stat = this.root.getCachedStats().get(hoverIndex);
            this.showCalculationTooltip(stat, mouseX, mouseY);
        }
        int btnY = this.root.top() + this.root.panelHeight() - 20;
        this.drawBookButtons(context, tr, mouseX, mouseY, btnY);
    }

    private void showCalculationTooltip(StatEntry stat, int mouseX, int mouseY) {
        class_310 client = this.root.mc();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        boolean shiftDown = class_3675.method_15987((long)client.method_22683().method_4490(), (int)client.field_1690.field_1832.method_1429().method_1444());
        class_1324 instance = player.method_5996(stat.attribute());
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ArrayList<class_1799> icons = new ArrayList<class_1799>();
        ArrayList<class_2960> texIcons = new ArrayList<class_2960>();
        lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.base", (Object[])new Object[]{String.format("%.2f", stat.base())}));
        icons.add(class_1799.field_8037);
        texIcons.add(null);
        if (instance != null) {
            lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.final", (Object[])new Object[]{String.format("%.2f", instance.method_6194())}));
            icons.add(class_1799.field_8037);
            texIcons.add(null);
        }
        double flat = 0.0;
        double multBase = 0.0;
        double multTotal = 0.0;
        ArrayList<Double> flatParts = new ArrayList<Double>();
        ArrayList<Double> baseMultParts = new ArrayList<Double>();
        ArrayList<Double> totalMultParts = new ArrayList<Double>();
        double puffFlat = 0.0;
        double puffBase = 0.0;
        double puffTotal = 0.0;
        boolean hasPuffish = false;
        ArrayList<TrinketCompat.TrinketModifierSource> unmatchedTrinketSources = new ArrayList<TrinketCompat.TrinketModifierSource>();
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            unmatchedTrinketSources.addAll(TrinketCompat.getTrinketModifierSources((class_1657)player));
        }
        if (instance != null && !instance.method_6195().isEmpty()) {
            lines.add((class_2561)class_2561.method_43473());
            icons.add(class_1799.field_8037);
            texIcons.add(null);
            lines.add((class_2561)class_2561.method_43471((String)"attributepanel.message.modifiers").method_27692(class_124.field_1054));
            icons.add(class_1799.field_8037);
            texIcons.add(null);
            for (class_1322 mod : instance.method_6195()) {
                String p;
                Set<String> ignoredArmorNames;
                class_2960 guess;
                String[] pathParts;
                class_124 color;
                String fullPath;
                String[] parts;
                class_2960 rawId = mod.comp_2447();
                if (rawId.method_12836().equals("tiered") && (parts = (fullPath = rawId.method_12832()).split("/")).length >= 3 && parts[parts.length - 1].contains("_")) {
                    rawId = class_2960.method_60655((String)"tiered", (String)parts[parts.length - 1]);
                }
                if (rawId.method_12836().equals("puffish_skills")) {
                    hasPuffish = true;
                    switch (mod.comp_2450()) {
                        case field_6328: {
                            puffFlat += mod.comp_2449();
                            break;
                        }
                        case field_6330: {
                            puffBase += mod.comp_2449();
                            break;
                        }
                        case field_6331: {
                            puffTotal += mod.comp_2449();
                        }
                    }
                    continue;
                }
                Object opText = switch (mod.comp_2450()) {
                    case class_1322.class_1323.field_6328 -> {
                        double v = mod.comp_2449();
                        flat += v;
                        flatParts.add(v);
                        color = v >= 0.0 ? class_124.field_1060 : class_124.field_1061;
                        yield (v >= 0.0 ? "+" : "") + String.format("%.2f", v);
                    }
                    case class_1322.class_1323.field_6330 -> {
                        double v = mod.comp_2449();
                        multBase += v;
                        baseMultParts.add(v);
                        int p = (int)Math.round(v * 100.0);
                        color = p >= 0 ? class_124.field_1060 : class_124.field_1061;
                        yield (p >= 0 ? "+" : "") + p + "% Base";
                    }
                    case class_1322.class_1323.field_6331 -> {
                        double v = mod.comp_2449();
                        multTotal += v;
                        totalMultParts.add(v);
                        int p = (int)Math.round(v * 100.0);
                        color = p >= 0 ? class_124.field_1060 : class_124.field_1061;
                        yield (p >= 0 ? "+" : "") + p + "% Total";
                    }
                    default -> {
                        color = class_124.field_1080;
                        yield "?";
                    }
                };
                String fullPath2 = rawId.method_12832();
                String[] idParts = fullPath2.split("\\.", 2);
                class_2960 modId = class_2960.method_60655((String)rawId.method_12836(), (String)idParts[0]);
                String customName = idParts.length > 1 ? idParts[1] : null;
                boolean usedCustomName = false;
                class_5250 displayName = class_2561.method_43470((String)AttributePanelDrawable.formatModifierId(modId));
                class_1799 iconStack = class_1799.field_8037;
                boolean foundSource = false;
                for (class_1304 slot : class_1304.values()) {
                    class_1799 stack = player.method_6118(slot);
                    if (stack.method_7960()) continue;
                    boolean[] matched = new boolean[]{false};
                    class_9285 comp = (class_9285)stack.method_57824(class_9334.field_49636);
                    if (comp != null) {
                        comp.method_57482(slot, (attr, entryMod) -> {
                            if (entryMod.comp_2447().equals((Object)mod.comp_2447()) && attr.equals(stat.attribute())) {
                                matched[0] = true;
                            }
                        });
                    }
                    if (!matched[0]) {
                        stack.method_7909().method_7844().method_57482(slot, (attr, entryMod) -> {
                            if (entryMod.comp_2447().equals((Object)mod.comp_2447()) && attr.equals(stat.attribute())) {
                                matched[0] = true;
                            }
                        });
                    }
                    if (!matched[0]) continue;
                    iconStack = stack;
                    try {
                        if (!usedCustomName) {
                            displayName = stack.method_7964().method_27661();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    foundSource = true;
                    break;
                }
                if (!foundSource && (pathParts = rawId.method_12832().split("\\.", 2)[0].split("/")).length > 0 && class_7923.field_41178.method_10250(guess = class_2960.method_60655((String)rawId.method_12836(), (String)pathParts[pathParts.length - 1]))) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(guess);
                    iconStack = new class_1799((class_1935)item);
                    displayName = iconStack.method_7964().method_27661().method_27692(iconStack.method_7932().method_58413());
                    foundSource = true;
                }
                if (customName != null && !customName.isBlank() && !(ignoredArmorNames = Set.of("helmet", "chestplate", "leggings", "boots")).contains(customName.toLowerCase(Locale.ROOT))) {
                    String pretty = Arrays.stream(customName.split("_")).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    displayName = class_2561.method_43470((String)pretty).method_27692(class_124.field_1076);
                    usedCustomName = true;
                }
                if (!foundSource && FabricLoader.getInstance().isModLoaded("trinkets")) {
                    Iterator it = unmatchedTrinketSources.iterator();
                    while (it.hasNext()) {
                        TrinketCompat.TrinketModifierSource src = (TrinketCompat.TrinketModifierSource)it.next();
                        if (!((class_1320)src.id().comp_349()).equals(stat.attribute().comp_349()) || src.modifier().comp_2450() != mod.comp_2450() || !(Math.abs(src.modifier().comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        iconStack = src.stack();
                        try {
                            displayName = iconStack.method_7964().method_27661().method_27692(iconStack.method_7932().method_58413());
                        }
                        catch (Exception e) {
                            displayName = class_2561.method_43470((String)"Unknown Trinket").method_27692(class_124.field_1080);
                        }
                        foundSource = true;
                        it.remove();
                        break;
                    }
                }
                if (!foundSource) {
                    for (class_1293 se : player.method_6026()) {
                        class_1322 pm;
                        class_1291 effect = (class_1291)se.method_5579().comp_349();
                        int amp = se.method_5578();
                        HashMap map = new HashMap();
                        effect.method_55650(amp, (attribute, modifier) -> map.put((class_1320)attribute.comp_349(), modifier));
                        if (!map.containsKey(stat.attribute().comp_349()) || (pm = (class_1322)map.get(stat.attribute().comp_349())).comp_2450() != mod.comp_2450() || !(Math.abs(pm.comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        displayName = class_2561.method_43471((String)effect.method_5567());
                        iconStack = this.root.createColoredPotionItem(effect);
                        foundSource = true;
                        break;
                    }
                }
                boolean printedCustom = false;
                if (rawId.method_12836().equals("rpg-systems") && (p = rawId.method_12832()).startsWith("title/")) {
                    boolean perma;
                    String[] seg = p.split("/");
                    boolean bl = perma = seg.length > 1 && "perma".equals(seg[1]);
                    String titlePathSlug = perma ? (seg.length >= 4 ? seg[3] : "unknown") : (seg.length >= 3 ? seg[2] : "unknown");
                    String prettyTitle = Arrays.stream(titlePathSlug.split("_")).filter(s -> !s.isBlank()).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    class_5250 line = class_2561.method_43470((String)prettyTitle).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                    lines.add((class_2561)line);
                    icons.add(class_1799.field_8037);
                    texIcons.add(perma ? PERMA : EQUIPPED);
                    printedCustom = true;
                }
                if (printedCustom) continue;
                if (rawId.method_12836().equals("tiered")) {
                    String[] pp = rawId.method_12832().split("_");
                    String tier = pp.length > 0 ? pp[0].substring(0, 1).toUpperCase() + pp[0].substring(1).toLowerCase() : "Tiered";
                    lines.add((class_2561)class_2561.method_43470((String)(tier + " Bonus: ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(class_124.field_1060)));
                    icons.add(new class_1799((class_1935)class_1802.field_8782));
                    texIcons.add(null);
                    continue;
                }
                lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                icons.add(iconStack);
                texIcons.add(null);
            }
            if (hasPuffish) {
                lines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.skill_tree_bonus").method_27692(class_124.field_1075));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
                if (puffFlat != 0.0) {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("- %+,.2f", puffFlat)).method_27692(class_124.field_1060));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                if (puffBase != 0.0) {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Base", (int)(puffBase * 100.0))).method_27692(class_124.field_1060));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                if (puffTotal != 0.0) {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Total", (int)(puffTotal * 100.0))).method_27692(class_124.field_1060));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                lines.add((class_2561)class_2561.method_43473());
                icons.add(class_1799.field_8037);
                texIcons.add(null);
            }
        }
        if (stat.isChanged()) {
            lines.add((class_2561)class_2561.method_43473());
            icons.add(class_1799.field_8037);
            texIcons.add(null);
            if (shiftDown) {
                double actual;
                double delta;
                String sum;
                double base = stat.base();
                double basePlusAdd = base + flat;
                double afterBaseMult = multBase != 0.0 ? basePlusAdd * (1.0 + multBase) : basePlusAdd;
                double finalValue = multTotal != 0.0 ? afterBaseMult * (1.0 + multTotal) : afterBaseMult;
                lines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.calculated").method_27692(class_124.field_1063));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
                if (!flatParts.isEmpty()) {
                    sum = flatParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f + (%s) = %.2f", base, sum, basePlusAdd)).method_27692(class_124.field_1080));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                } else {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("= %.2f", base)).method_27692(class_124.field_1080));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                if (!baseMultParts.isEmpty()) {
                    sum = baseMultParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", basePlusAdd, sum, afterBaseMult)).method_27692(class_124.field_1080));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                if (!totalMultParts.isEmpty()) {
                    sum = totalMultParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", afterBaseMult, sum, finalValue)).method_27692(class_124.field_1080));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                lines.add((class_2561)class_2561.method_43470((String)("= " + String.format("%.2f", finalValue))).method_27692(class_124.field_1060));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
                if (instance != null && Math.abs(delta = (actual = instance.method_6194()) - finalValue) > 0.001 && finalValue > 0.001) {
                    double pct = Math.abs(delta) / finalValue;
                    lines.add((class_2561)class_2561.method_43473());
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                    if (delta > 0.0) {
                        lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.indirect_bonus", (Object[])new Object[]{String.format("%.2f", delta)}).method_27692(class_124.field_1077));
                        icons.add(class_1799.field_8037);
                        texIcons.add(null);
                        lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %.2f) = %.2f", finalValue, pct, actual)).method_27692(class_124.field_1080));
                        icons.add(class_1799.field_8037);
                        texIcons.add(null);
                    } else {
                        lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.indirect_decrease", (Object[])new Object[]{String.format("%.2f", -delta)}).method_27692(class_124.field_1061));
                        icons.add(class_1799.field_8037);
                        texIcons.add(null);
                        lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 - %.2f) = %.2f", finalValue, pct, actual)).method_27692(class_124.field_1080));
                        icons.add(class_1799.field_8037);
                        texIcons.add(null);
                    }
                }
            } else {
                lines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.hold_shift").method_27692(class_124.field_1080));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
            }
        }
        this.root.enqueueTooltipRich(lines, icons, texIcons, mouseX, mouseY);
    }

    private void drawGlobalBonusTooltip(int mouseX, int mouseY) {
        class_746 player = this.root.mc().field_1724;
        if (player == null) {
            return;
        }
        TreeMap<String, Double> flatMap = new TreeMap<String, Double>();
        TreeMap<String, Double> baseMultMap = new TreeMap<String, Double>();
        TreeMap<String, Double> totalMultMap = new TreeMap<String, Double>();
        for (class_6880 entry : class_7923.field_41190.method_40270().toList()) {
            class_1320 attr = (class_1320)entry.comp_349();
            class_1324 instance = player.method_5996(entry);
            if (instance == null || instance.method_6195().isEmpty()) continue;
            String attrName = class_2561.method_43471((String)attr.method_26830()).getString();
            for (class_1322 mod : instance.method_6195()) {
                double value = mod.comp_2449();
                if (Math.abs(value) < 1.0E-4) continue;
                switch (mod.comp_2450()) {
                    case field_6328: {
                        flatMap.merge(attrName, value, Double::sum);
                        break;
                    }
                    case field_6330: {
                        baseMultMap.merge(attrName, value, Double::sum);
                        break;
                    }
                    case field_6331: {
                        totalMultMap.merge(attrName, value, Double::sum);
                    }
                }
            }
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ArrayList<class_1799> icons = new ArrayList<class_1799>();
        lines.add((class_2561)class_2561.method_43471((String)"attributepanel.message.bonuses").method_27692(class_124.field_1065));
        icons.add(class_1799.field_8037);
        boolean addedAny = false;
        for (String attr : flatMap.keySet()) {
            double value = (Double)flatMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+,.2f", attr, value)).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        for (String attr : baseMultMap.keySet()) {
            double value = (Double)baseMultMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Base", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        for (String attr : totalMultMap.keySet()) {
            double value = (Double)totalMultMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Total", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        if (!addedAny) {
            lines.add((class_2561)class_2561.method_43470((String)"No active modifiers").method_27692(class_124.field_1080));
            icons.add(class_1799.field_8037);
        }
        this.root.enqueueTooltip(lines, icons, mouseX, mouseY);
    }

    private record ButtonCoords(int prevX, int checkX, int nextX, int prevW, int checkW, int nextW) {
    }
}

