/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.pixeldreamstudios.attributepanel.client.AttributeDescriptionProvider;
import net.pixeldreamstudios.attributepanel.client.StatEntry;
import net.pixeldreamstudios.attributepanel.compat.TrinketCompat;
import net.pixeldreamstudios.attributepanel.config.AttributesPanelConfig;
import org.spongepowered.asm.mixin.Unique;

public class AttributePanelDrawable
implements class_4068,
class_364,
class_6379 {
    private static final class_2960 BOOK_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/book.png");
    private static final class_2960 NAME_BG = class_2960.method_60655((String)"minecraft", (String)"textures/block/light_gray_concrete.png");
    private static final class_2960 VALUE_BG = class_2960.method_60655((String)"minecraft", (String)"textures/block/gray_concrete.png");
    private final class_310 client = class_310.method_1551();
    private final int x;
    private final int y;
    private final int width;
    private int height;
    @Unique
    private List<class_2561> queuedTooltip = null;
    private static final class_2960 INFO_ICON = class_2960.method_60655((String)"kevs-attributes-panel", (String)"textures/gui/attribute_book.png");
    private static final int INFO_ICON_SIZE = 16;
    @Unique
    private int tooltipX;
    @Unique
    private int tooltipY;
    private boolean expanded = false;
    private final List<StatEntry> cachedStats = new ArrayList<StatEntry>();
    private int currentPage = 0;
    private static final int MAX_ROWS = 6;
    private boolean showOnlyChanged = true;
    private List<class_1799> queuedTooltipIcons = new ArrayList<class_1799>();
    private static final String DESCRIPTION_PREFIX = "description.";

    public AttributePanelDrawable(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
    }

    public void setHeightFromInventory(int inventoryHeight) {
        this.height = inventoryHeight;
    }

    public void toggle() {
        this.expanded = !this.expanded;
        this.currentPage = 0;
        if (this.expanded) {
            this.cacheStats();
        }
    }

    public void renderTooltip(class_332 context) {
        if (this.queuedTooltip == null || this.queuedTooltip.isEmpty()) {
            return;
        }
        class_327 tr = this.client.field_1772;
        int zOffset = 400;
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, (float)zOffset);
        int maxWidth = 0;
        for (class_2561 line : this.queuedTooltip) {
            maxWidth = Math.max(maxWidth, tr.method_1727(line.getString()));
        }
        int tooltipWidth = maxWidth + 28;
        int n = this.queuedTooltip.size();
        Objects.requireNonNull(tr);
        int tooltipHeight = n * (9 + 4) + 12;
        int screenWidth = this.client.method_22683().method_4486();
        int screenHeight = this.client.method_22683().method_4502();
        int tooltipX = this.tooltipX + 12;
        int tooltipY = this.tooltipY + 12;
        if (tooltipX + tooltipWidth > screenWidth) {
            tooltipX = screenWidth - tooltipWidth - 8;
        }
        if (tooltipY + tooltipHeight > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 8;
        }
        tooltipX = Math.max(tooltipX, 4);
        tooltipY = Math.max(tooltipY, 4);
        int backgroundColor = -267185389;
        int borderColorStart = -10855846;
        int borderColorEnd = -5592406;
        context.method_25296(tooltipX - 4, tooltipY - 4, tooltipX + tooltipWidth + 4, tooltipY + tooltipHeight, backgroundColor, backgroundColor);
        context.method_49601(tooltipX - 4, tooltipY - 4, tooltipWidth + 8, tooltipHeight + 1, borderColorStart);
        for (int i = 0; i < this.queuedTooltip.size(); ++i) {
            Objects.requireNonNull(tr);
            int lineY = tooltipY + i * (9 + 4);
            class_1799 icon = this.queuedTooltipIcons != null && i < this.queuedTooltipIcons.size() ? this.queuedTooltipIcons.get(i) : class_1799.field_8037;
            int iconOffset = 0;
            if (!icon.method_7960()) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)tooltipX, (float)lineY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51427(icon, 0, 0);
                context.method_51448().method_22909();
                iconOffset = 18;
            }
            int textX = tooltipX + iconOffset;
            context.method_51439(tr, this.queuedTooltip.get(i), textX, lineY + 2, 0xFFFFFF, false);
        }
        context.method_51448().method_22909();
        this.queuedTooltip = null;
        if (this.queuedTooltipIcons != null) {
            this.queuedTooltipIcons.clear();
        }
    }

    public void tick() {
        if (this.expanded) {
            this.cacheStats();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void cacheStats() {
        this.cachedStats.clear();
        class_746 player = this.client.field_1724;
        if (player == null) {
            return;
        }
        for (class_6880 entry : class_7923.field_41190.method_40270().toList()) {
            class_1320 attr = (class_1320)entry.comp_349();
            class_1324 instance = player.method_5996(entry);
            if (instance == null) continue;
            boolean isPercent = attr.method_26830().contains("resistance") || attr.method_26830().contains("movement_speed") || attr.method_26830().contains("fire_tornado_chance") || attr.method_26830().contains("fire_tornado_overload_chance") || attr.method_26830().contains("chain_lightning_chance") || attr.method_26830().contains("chain_lightning_overload_chance") || attr.method_26830().contains("frost_nova_chance") || attr.method_26830().contains("frost_nova_overload_chance") || attr.method_26830().contains("arcane_rupture_chance") || attr.method_26830().contains("arcane_rupture_damage") || attr.method_26830().contains("arcane_rupture_overload_chance") || attr.method_26830().contains("ratio") || attr.method_26830().contains("crit_chance") || attr.method_26830().contains("crit_damage") || attr.method_26830().contains("soul_link_damage") || attr.method_26830().contains("soul_link_chance") || attr.method_26830().contains("multistrike_chance") || attr.method_26830().contains("multistrike_damage") || attr.method_26830().contains("damage_multiplier");
            double base = instance.method_6201();
            double value = instance.method_6194();
            if (this.showOnlyChanged && (Double.isNaN(value) || Math.abs(base - value) < 0.001)) continue;
            this.cachedStats.add(new StatEntry((class_2561)class_2561.method_43471((String)attr.method_26830()), base, value, isPercent, (class_6880<class_1320>)entry));
            this.cachedStats.sort((a, b) -> a.name().getString().compareToIgnoreCase(b.name().getString()));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.expanded) {
            return;
        }
        if (AttributesPanelConfig.INSTANCE.useBookBackground) {
            this.renderBookLayout(context, mouseX, mouseY);
        } else {
            this.renderVanillaLayout(context, mouseX, mouseY);
        }
    }

    private void renderVanillaLayout(class_332 context, int mouseX, int mouseY) {
        class_327 tr = this.client.field_1772;
        int rowHeight = 24;
        int padding = 2;
        int visibleRows = 6;
        int totalPages = (int)Math.ceil((float)this.cachedStats.size() / (float)visibleRows);
        this.currentPage = Math.min(this.currentPage, Math.max(totalPages - 1, 0));
        if (this.showOnlyChanged && this.cachedStats.isEmpty()) {
            String noStatsText = "No changed attributes";
            int textWidth = tr.method_1727(noStatsText);
            context.method_51433(tr, noStatsText, this.x + (this.width - textWidth) / 2, this.y + 8, class_124.field_1080.method_532().intValue(), false);
            this.drawVanillaButtons(context, tr, mouseX, mouseY, this.y + this.height - 12);
            return;
        }
        int startIndex = this.currentPage * visibleRows;
        int endIndex = Math.min(startIndex + visibleRows, this.cachedStats.size());
        int rowY = this.y + padding;
        int hoverIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            Object valueStr;
            String topLine;
            StatEntry stat = this.cachedStats.get(i);
            int rowIndex = i - startIndex;
            int yOffset = rowY + rowIndex * rowHeight;
            String statName = stat.name().getString();
            int maxNameWidth = this.width / 2 - 8;
            Object bottomLine = null;
            if (tr.method_1727(statName) <= maxNameWidth) {
                topLine = statName;
            } else {
                topLine = tr.method_27523(statName, maxNameWidth);
                String remainder = statName.substring(topLine.length()).trim();
                if (!remainder.isEmpty()) {
                    bottomLine = tr.method_27523(remainder, maxNameWidth);
                    if (tr.method_1727(remainder) > maxNameWidth) {
                        while (tr.method_1727((String)bottomLine + "...") > maxNameWidth && ((String)bottomLine).length() > 0) {
                            bottomLine = ((String)bottomLine).substring(0, ((String)bottomLine).length() - 1);
                        }
                        bottomLine = (String)bottomLine + "...";
                    }
                }
            }
            context.method_25290(NAME_BG, this.x, yOffset, 0.0f, 0.0f, this.width / 2, rowHeight, 16, 16);
            context.method_25290(VALUE_BG, this.x + this.width / 2, yOffset, 0.0f, 0.0f, this.width / 2, rowHeight, 16, 16);
            int nameY = yOffset + (rowHeight - 8) / 2;
            if (bottomLine == null) {
                context.method_51433(tr, topLine, this.x + 4, nameY, 0xFFFFFF, false);
            } else {
                context.method_51433(tr, topLine, this.x + 4, yOffset + 4, 0xFFFFFF, false);
                context.method_51433(tr, (String)bottomLine, this.x + 4, yOffset + 14, 0xCCCCCC, false);
            }
            Object object = valueStr = stat.percent() ? String.format("%d%%", (int)(stat.current() * 100.0)) : String.format("%.2f", stat.current());
            int color = stat.isChanged() ? (stat.current() > stat.base() ? class_124.field_1060.method_532() : class_124.field_1061.method_532()) : class_124.field_1080.method_532();
            valueStr = (String)valueStr + (stat.isChanged() ? (stat.current() > stat.base() ? " \u2191" : " \u2193") : "");
            int valueY = yOffset + (rowHeight - 8) / 2;
            context.method_51433(tr, (String)valueStr, this.x + this.width - 4 - tr.method_1727((String)valueStr), valueY, color, false);
            context.method_25294(this.x, yOffset + rowHeight - 1, this.x + this.width, yOffset + rowHeight, -12303292);
            if (mouseX < this.x || mouseX > this.x + this.width || mouseY < yOffset || mouseY > yOffset + rowHeight) continue;
            hoverIndex = i;
        }
        this.drawVanillaTooltipButton(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
    }

    private void renderBookLayout(class_332 context, int mouseX, int mouseY) {
        class_327 tr = this.client.field_1772;
        int rowHeight = 20;
        int padding = 20;
        context.method_25290(BOOK_TEXTURE, this.x - 25, this.y, 0.0f, 0.0f, 240, 230, 240, 230);
        int visibleRows = 6;
        int totalPages = (int)Math.ceil((float)this.cachedStats.size() / (float)visibleRows);
        this.currentPage = Math.min(this.currentPage, Math.max(totalPages - 1, 0));
        if (this.showOnlyChanged && this.cachedStats.isEmpty()) {
            String noStatsText = "No changed attributes";
            int textWidth = tr.method_1727(noStatsText);
            this.drawBookButtons(context, tr, mouseX, mouseY, this.y + this.height - 20);
            context.method_51433(tr, noStatsText, this.x + (this.width - textWidth) / 2 + 5, this.y + 20, class_124.field_1063.method_532().intValue(), false);
            return;
        }
        int startIndex = this.currentPage * visibleRows;
        int endIndex = Math.min(startIndex + visibleRows, this.cachedStats.size());
        int rowY = this.y + padding;
        int hoverIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            Object valueStr;
            String topLine;
            StatEntry stat = this.cachedStats.get(i);
            int rowIndex = i - startIndex;
            int yOffset = rowY + rowIndex * rowHeight;
            String statName = stat.name().getString();
            int maxNameWidth = this.width / 2 - 7;
            context.method_25294(this.x + 12, yOffset + rowHeight + 2, this.x + this.width - 12, yOffset + rowHeight + 1, -2702173);
            Object bottomLine = null;
            if (tr.method_1727(statName) <= maxNameWidth) {
                topLine = statName;
            } else {
                topLine = tr.method_27523(statName, maxNameWidth);
                String remainder = statName.substring(topLine.length()).trim();
                if (!remainder.isEmpty()) {
                    bottomLine = tr.method_27523(remainder, maxNameWidth);
                    if (tr.method_1727(remainder) > maxNameWidth) {
                        while (tr.method_1727((String)bottomLine + "...") > maxNameWidth && ((String)bottomLine).length() > 0) {
                            bottomLine = ((String)bottomLine).substring(0, ((String)bottomLine).length() - 1);
                        }
                        bottomLine = (String)bottomLine + "...";
                    }
                }
            }
            int nameX = this.x + 15;
            int valueX = this.x + this.width - 12;
            int nameY = yOffset + (rowHeight - 8) / 2;
            if (bottomLine == null) {
                context.method_51433(tr, topLine, nameX, nameY, 3813155, false);
            } else {
                context.method_51433(tr, topLine, nameX, yOffset + 4, 3813155, false);
                context.method_51433(tr, (String)bottomLine, nameX, yOffset + 12, 7167048, false);
            }
            Object object = valueStr = stat.percent() ? String.format("%d%%", (int)(stat.current() * 100.0)) : String.format("%.2f", stat.current());
            int color = stat.isChanged() ? (stat.current() > stat.base() ? class_124.field_1060.method_532() : class_124.field_1061.method_532()) : class_124.field_1080.method_532();
            valueStr = (String)valueStr + (stat.isChanged() ? (stat.current() > stat.base() ? " \u2191" : " \u2193") : "");
            context.method_51433(tr, (String)valueStr, valueX - tr.method_1727((String)valueStr), nameY, color, false);
            if (mouseX < this.x || mouseX > this.x + this.width || mouseY < yOffset || mouseY > yOffset + rowHeight) continue;
            hoverIndex = i;
        }
        int infoX = this.x + this.width - 16 - 95;
        int infoY = this.y + 10;
        int textureWidth = 8;
        int textureHeight = 8;
        context.method_25290(INFO_ICON, infoX, infoY, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        if (mouseX >= infoX && mouseX <= infoX + 16 && mouseY >= infoY && mouseY <= infoY + 16) {
            this.drawGlobalBonusTooltip(mouseX, mouseY);
        }
        this.drawBookTooltipButton(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
    }

    private void drawGlobalBonusTooltip(int mouseX, int mouseY) {
        class_746 player = this.client.field_1724;
        if (player == null) {
            return;
        }
        TreeMap<String, Double> flatMap = new TreeMap<String, Double>();
        TreeMap<String, Double> baseMultMap = new TreeMap<String, Double>();
        TreeMap<String, Double> totalMultMap = new TreeMap<String, Double>();
        for (class_6880 entry : class_7923.field_41190.method_40270().toList()) {
            class_1320 attr = (class_1320)entry.comp_349();
            class_1324 instance = player.method_5996(entry);
            if (instance == null || instance.method_6195().isEmpty()) continue;
            String attrName = class_2561.method_43471((String)attr.method_26830()).getString();
            for (class_1322 mod : instance.method_6195()) {
                double value = mod.comp_2449();
                if (Math.abs(value) < 1.0E-4) continue;
                switch (mod.comp_2450()) {
                    case field_6328: {
                        flatMap.merge(attrName, value, Double::sum);
                        break;
                    }
                    case field_6330: {
                        baseMultMap.merge(attrName, value, Double::sum);
                        break;
                    }
                    case field_6331: {
                        totalMultMap.merge(attrName, value, Double::sum);
                    }
                }
            }
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ArrayList<class_1799> icons = new ArrayList<class_1799>();
        lines.add((class_2561)class_2561.method_43470((String)"Bonuses:").method_27692(class_124.field_1065));
        icons.add(class_1799.field_8037);
        boolean addedAny = false;
        for (String attr : flatMap.keySet()) {
            double value = (Double)flatMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+,.2f", attr, value)).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        for (String attr : baseMultMap.keySet()) {
            double value = (Double)baseMultMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Base", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        for (String attr : totalMultMap.keySet()) {
            double value = (Double)totalMultMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Total", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        if (!addedAny) {
            lines.add((class_2561)class_2561.method_43470((String)"No active modifiers").method_27692(class_124.field_1080));
            icons.add(class_1799.field_8037);
        }
        this.queuedTooltip = lines;
        this.queuedTooltipIcons = icons;
        this.tooltipX = mouseX;
        this.tooltipY = mouseY;
    }

    private void drawVanillaTooltipButton(class_332 context, class_327 tr, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        this.drawTooltipContent(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
        int btnY = this.y + this.height - 12;
        this.drawVanillaButtons(context, tr, mouseX, mouseY, btnY);
    }

    private void drawBookTooltipButton(class_332 context, class_327 tr, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        this.drawTooltipContent(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
        int btnY = this.y + this.height - 20;
        this.drawBookButtons(context, tr, mouseX, mouseY, btnY);
    }

    private void drawTooltipContent(class_332 context, class_327 tr, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        boolean onValue;
        if (hoverIndex == -1 || hoverIndex >= this.cachedStats.size()) {
            return;
        }
        StatEntry stat = this.cachedStats.get(hoverIndex);
        int rowIndex = hoverIndex % 6;
        int yOffset = this.y + padding + rowIndex * rowHeight;
        int midX = this.x + this.width / 2;
        boolean onName = mouseX >= this.x && mouseX <= midX;
        boolean bl = onValue = mouseX > midX && mouseX <= this.x + this.width;
        if (onName) {
            AttributeDescriptionProvider.TooltipContents tooltip = AttributeDescriptionProvider.getTooltip((class_1320)stat.attribute().comp_349());
            this.queuedTooltip = tooltip.lines();
            this.queuedTooltipIcons = tooltip.icons();
            this.tooltipX = mouseX;
            this.tooltipY = mouseY;
            return;
        }
        if (!onValue) {
            return;
        }
        boolean shiftDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)this.client.field_1690.field_1832.method_1429().method_1444());
        ArrayList<Double> flatComponents = new ArrayList<Double>();
        ArrayList<Double> baseMultComponents = new ArrayList<Double>();
        ArrayList<Double> totalMultComponents = new ArrayList<Double>();
        class_1324 instance = this.client.field_1724.method_5996(stat.attribute());
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        ArrayList<class_1799> iconStacks = new ArrayList<class_1799>();
        tooltipLines.add((class_2561)class_2561.method_43470((String)("Base: " + String.format("%.2f", stat.base()))));
        iconStacks.add(class_1799.field_8037);
        if (instance != null) {
            tooltipLines.add((class_2561)class_2561.method_43470((String)("Final: " + String.format("%.2f", instance.method_6194()))));
            iconStacks.add(class_1799.field_8037);
        }
        double flat = 0.0;
        double multBase = 0.0;
        double multTotal = 0.0;
        double puffFlat = 0.0;
        double puffBase = 0.0;
        double puffTotal = 0.0;
        boolean hasPuffish = false;
        ArrayList<TrinketCompat.TrinketModifierSource> unmatchedTrinketSources = new ArrayList<TrinketCompat.TrinketModifierSource>();
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            unmatchedTrinketSources.addAll(TrinketCompat.getTrinketModifierSources((class_1657)this.client.field_1724));
        }
        if (instance != null && !instance.method_6195().isEmpty()) {
            tooltipLines.add((class_2561)class_2561.method_43473());
            iconStacks.add(class_1799.field_8037);
            tooltipLines.add((class_2561)class_2561.method_43470((String)"Modifiers:").method_27692(class_124.field_1054));
            iconStacks.add(class_1799.field_8037);
            for (class_1322 mod : instance.method_6195()) {
                Set<String> ignoredArmorNames;
                String[] pathParts;
                Object opText;
                class_124 color;
                class_2960 rawId = mod.comp_2447();
                if (rawId.method_12836().equals("puffish_skills")) {
                    hasPuffish = true;
                    switch (mod.comp_2450()) {
                        case field_6328: {
                            puffFlat += mod.comp_2449();
                            break;
                        }
                        case field_6330: {
                            puffBase += mod.comp_2449();
                            break;
                        }
                        case field_6331: {
                            puffTotal += mod.comp_2449();
                        }
                    }
                    continue;
                }
                switch (mod.comp_2450()) {
                    case field_6328: {
                        double value = mod.comp_2449();
                        flat += value;
                        flatComponents.add(value);
                        color = value >= 0.0 ? class_124.field_1060 : class_124.field_1061;
                        String sign = value >= 0.0 ? "+" : "";
                        opText = sign + String.format("%.2f", value);
                        break;
                    }
                    case field_6330: {
                        double value = mod.comp_2449();
                        multBase += value;
                        baseMultComponents.add(value);
                        int percent = (int)Math.round(value * 100.0);
                        color = percent >= 0 ? class_124.field_1060 : class_124.field_1061;
                        String sign = percent >= 0 ? "+" : "";
                        opText = sign + percent + "% Base";
                        break;
                    }
                    case field_6331: {
                        double value = mod.comp_2449();
                        multTotal += value;
                        totalMultComponents.add(value);
                        int percent = (int)Math.round(value * 100.0);
                        color = percent >= 0 ? class_124.field_1060 : class_124.field_1061;
                        String sign = percent >= 0 ? "+" : "";
                        opText = sign + percent + "% Total";
                        break;
                    }
                    default: {
                        opText = "?";
                        color = class_124.field_1080;
                    }
                }
                String fullPath = rawId.method_12832();
                String[] parts = fullPath.split("\\.", 2);
                class_2960 modId = class_2960.method_60655((String)rawId.method_12836(), (String)parts[0]);
                Iterator customName = parts.length > 1 ? parts[1] : null;
                boolean usedCustomName = false;
                class_1799 matchingStack = new class_1799((class_1935)class_7923.field_41178.method_10223(modId));
                class_5250 displayName = class_2561.method_43470((String)AttributePanelDrawable.formatModifierId(modId));
                boolean foundSource = false;
                for (class_1304 slot : class_1304.values()) {
                    class_1799 stack = this.client.field_1724.method_6118(slot);
                    if (stack.method_7960()) continue;
                    boolean[] matched = new boolean[]{false};
                    class_9285 component = (class_9285)stack.method_57824(class_9334.field_49636);
                    if (component != null) {
                        component.method_57482(slot, (attr, entryMod) -> {
                            if (entryMod.comp_2447().equals((Object)mod.comp_2447()) && attr.equals(stat.attribute())) {
                                matched[0] = true;
                            }
                        });
                    }
                    if (!matched[0]) {
                        stack.method_7909().method_7844().method_57482(slot, (attr, entryMod) -> {
                            if (entryMod.comp_2447().equals((Object)mod.comp_2447()) && attr.equals(stat.attribute())) {
                                matched[0] = true;
                            }
                        });
                    }
                    if (!matched[0]) continue;
                    matchingStack = stack;
                    if (!stack.method_7960() && stack.method_7909() != class_1802.field_8162 && !usedCustomName) {
                        try {
                            displayName = stack.method_7964().method_27661();
                        }
                        catch (Exception e) {
                            displayName = class_2561.method_43470((String)stack.method_7909().toString()).method_27692(class_124.field_1080);
                        }
                    }
                    foundSource = true;
                    break;
                }
                if (!foundSource && (pathParts = modId.method_12832().split("/")).length > 0) {
                    String itemGuess = pathParts[pathParts.length - 1];
                    class_2960 itemId = class_2960.method_60655((String)modId.method_12836(), (String)itemGuess);
                    if (class_7923.field_41178.method_10250(itemId)) {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                        matchingStack = new class_1799((class_1935)item);
                        displayName = matchingStack.method_7964().method_27661().method_27692(matchingStack.method_7932().method_58413());
                        foundSource = true;
                    }
                }
                if (customName != null && !((String)((Object)customName)).isBlank() && !(ignoredArmorNames = Set.of("helmet", "chestplate", "leggings", "boots")).contains(((String)((Object)customName)).toLowerCase())) {
                    String pretty = Arrays.stream(((String)((Object)customName)).split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase()).collect(Collectors.joining(" "));
                    displayName = class_2561.method_43470((String)pretty).method_27692(class_124.field_1076);
                    usedCustomName = true;
                }
                if (!foundSource && FabricLoader.getInstance().isModLoaded("trinkets")) {
                    Iterator iter = unmatchedTrinketSources.iterator();
                    while (iter.hasNext()) {
                        TrinketCompat.TrinketModifierSource source = (TrinketCompat.TrinketModifierSource)iter.next();
                        if (!((class_1320)source.id().comp_349()).equals(stat.attribute().comp_349()) || source.modifier().comp_2450() != mod.comp_2450() || !(Math.abs(source.modifier().comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        matchingStack = source.stack();
                        if (!matchingStack.method_7960() && matchingStack.method_7909() != class_1802.field_8162) {
                            try {
                                displayName = matchingStack.method_7964().method_27661().method_27692(matchingStack.method_7932().method_58413());
                            }
                            catch (Exception e) {
                                displayName = class_2561.method_43470((String)"Unknown Trinket").method_27692(class_124.field_1080);
                            }
                        } else {
                            displayName = class_2561.method_43470((String)"Unknown Trinket").method_27692(class_124.field_1080);
                        }
                        foundSource = true;
                        iter.remove();
                        break;
                    }
                }
                if (!foundSource) {
                    for (class_1293 entry : this.client.field_1724.method_6026()) {
                        class_1322 potionMod;
                        class_1291 effect = (class_1291)entry.method_5579().comp_349();
                        int amplifier = entry.method_5578();
                        class_1320 attr2 = (class_1320)stat.attribute().comp_349();
                        HashMap effectMods = new HashMap();
                        effect.method_55650(amplifier, (attribute, modifier) -> effectMods.put((class_1320)attribute.comp_349(), modifier));
                        if (!effectMods.containsKey(attr2) || (potionMod = (class_1322)effectMods.get(attr2)).comp_2450() != mod.comp_2450() || !(Math.abs(potionMod.comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        displayName = class_2561.method_43471((String)effect.method_5567());
                        matchingStack = this.createColoredPotionItem(effect);
                        foundSource = true;
                        break;
                    }
                }
                if (modId.method_12836().equals("tiered")) {
                    String path = modId.method_12832();
                    String[] pathParts2 = path.split("_");
                    String tierRarity = pathParts2.length > 0 ? pathParts2[0] : "Tiered";
                    String tierName = tierRarity.substring(0, 1).toUpperCase() + tierRarity.substring(1).toLowerCase();
                    class_5250 tierLine = class_2561.method_43470((String)(tierName + " Tier Bonus: ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(class_124.field_1060));
                    tooltipLines.add((class_2561)tierLine);
                    iconStacks.add(new class_1799((class_1935)class_1802.field_8782));
                    continue;
                }
                class_5250 displayLine = displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color));
                tooltipLines.add((class_2561)displayLine);
                iconStacks.add(matchingStack);
            }
            if (hasPuffish) {
                tooltipLines.add((class_2561)class_2561.method_43470((String)"Skill Tree Bonus:").method_27692(class_124.field_1075));
                iconStacks.add(class_1799.field_8037);
                if (puffFlat != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("- %+,.2f", puffFlat)).method_27692(class_124.field_1060));
                    iconStacks.add(class_1799.field_8037);
                }
                if (puffBase != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Base", (int)(puffBase * 100.0))).method_27692(class_124.field_1060));
                    iconStacks.add(class_1799.field_8037);
                }
                if (puffTotal != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Total", (int)(puffTotal * 100.0))).method_27692(class_124.field_1060));
                    iconStacks.add(class_1799.field_8037);
                }
                tooltipLines.add((class_2561)class_2561.method_43473());
                iconStacks.add(class_1799.field_8037);
            }
        } else if (stat.isChanged()) {
            tooltipLines.add((class_2561)class_2561.method_43470((String)"Hold \u21e7 Shift to show calculation").method_27692(class_124.field_1080));
            iconStacks.add(class_1799.field_8037);
        }
        tooltipLines.add((class_2561)class_2561.method_43473());
        iconStacks.add(class_1799.field_8037);
        if (stat.isChanged()) {
            if (shiftDown) {
                double base = stat.base();
                double flatTotal = flat;
                double tieredMultTotal = 0.0;
                double nonTieredMultTotal = 0.0;
                instance = this.client.field_1724.method_5996(stat.attribute());
                if (instance != null && !instance.method_6195().isEmpty()) {
                    for (class_1322 mod : instance.method_6195()) {
                        if (mod.comp_2450() != class_1322.class_1323.field_6331) continue;
                        if (mod.comp_2447().method_12836().equals("tiered")) {
                            tieredMultTotal += mod.comp_2449();
                            continue;
                        }
                        nonTieredMultTotal += mod.comp_2449();
                    }
                }
                double basePlusAdditive = base + flatTotal;
                double afterTiered = tieredMultTotal != 0.0 ? basePlusAdditive * (1.0 + tieredMultTotal) : basePlusAdditive;
                double afterBaseMult = multBase != 0.0 ? afterTiered * (1.0 + multBase) : afterTiered;
                double finalValue = nonTieredMultTotal != 0.0 ? afterBaseMult * (1.0 + nonTieredMultTotal) : afterBaseMult;
                tooltipLines.add((class_2561)class_2561.method_43470((String)"Calculated:").method_27692(class_124.field_1063));
                iconStacks.add(class_1799.field_8037);
                if (flatTotal != 0.0) {
                    String flatBreakdown = flatComponents.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f + (%s) = %.2f", base, flatBreakdown, basePlusAdditive)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                } else {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("= %.2f", base)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                }
                if (tieredMultTotal != 0.0) {
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 %.2f = %.2f", basePlusAdditive, 1.0 + tieredMultTotal, afterTiered)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                }
                if (multBase != 0.0) {
                    String baseMultBreakdown = baseMultComponents.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", afterTiered, baseMultBreakdown, afterBaseMult)).method_27692(class_124.field_1080));
                    iconStacks.add(class_1799.field_8037);
                }
                if (nonTieredMultTotal != 0.0) {
                    ArrayList<Double> nonTieredTotalComponents = new ArrayList<Double>();
                    for (class_1322 mod : instance.method_6195()) {
                        if (mod.comp_2450() != class_1322.class_1323.field_6331 || mod.comp_2447().method_12836().equals("tiered")) continue;
                        nonTieredTotalComponents.add(mod.comp_2449());
                    }
                    String totalMultBreakdown = nonTieredTotalComponents.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                    if (!nonTieredTotalComponents.isEmpty()) {
                        tooltipLines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", afterBaseMult, totalMultBreakdown, finalValue)).method_27692(class_124.field_1080));
                    }
                }
                tooltipLines.add((class_2561)class_2561.method_43470((String)("= " + String.format("%.2f", finalValue))).method_27692(class_124.field_1060));
                iconStacks.add(class_1799.field_8037);
            } else {
                tooltipLines.add((class_2561)class_2561.method_43470((String)"Hold \u21e7 Shift to show calculation").method_27692(class_124.field_1080));
                iconStacks.add(class_1799.field_8037);
            }
        }
        this.queuedTooltip = tooltipLines;
        this.queuedTooltipIcons = iconStacks;
        this.tooltipX = mouseX;
        this.tooltipY = mouseY;
    }

    private class_1799 createColoredPotionItem(class_1291 effect) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8574);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)effect.method_5567()));
        class_2487 nbt = new class_2487();
        nbt.method_10569("CustomPotionColor", 0xFF0000);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        return stack;
    }

    private static String formatModifierId(class_2960 id) {
        String path = id.method_12832();
        if (path.contains("/")) {
            path = path.substring(0, path.indexOf(47));
        }
        String[] parts = path.split("_");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return sb.toString();
    }

    private ButtonCoords getBookButtonCoords(class_327 tr) {
        int startX;
        String prevText = "\u00ab\u00ab";
        String nextText = "\u00bb\u00bb";
        String checkLabel = "[ " + (this.showOnlyChanged ? "\u2713" : " ") + " ]";
        int spacing = 24;
        int prevW = tr.method_1727(prevText);
        int checkW = tr.method_1727(checkLabel);
        int nextW = tr.method_1727(nextText);
        int totalWidth = prevW + spacing + checkW + spacing + nextW;
        int prevX = startX = this.x + (this.width - totalWidth) / 2;
        int checkX = prevX + prevW + spacing;
        int nextX = checkX + checkW + spacing;
        return new ButtonCoords(prevX, checkX, nextX, prevW, checkW, nextW);
    }

    private void drawBookButtons(class_332 context, class_327 tr, int mouseX, int mouseY, int btnY) {
        int startX;
        String prevText = "\u00ab\u00ab";
        String nextText = "\u00bb\u00bb";
        String checkLabel = "[ " + (this.showOnlyChanged ? "\u2713" : " ") + " ]";
        int spacing = 24;
        int buttonHeight = 10;
        int prevWidth = tr.method_1727(prevText);
        int checkWidth = tr.method_1727(checkLabel);
        int nextWidth = tr.method_1727(nextText);
        int totalWidth = prevWidth + spacing + checkWidth + spacing + nextWidth;
        int prevX = startX = this.x + (this.width - totalWidth) / 2;
        int checkX = prevX + prevWidth + spacing;
        int nextX = checkX + checkWidth + spacing;
        context.method_51433(tr, prevText, prevX, btnY, this.mouseIn(mouseX, mouseY, prevX, btnY, prevWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
        context.method_51433(tr, checkLabel, checkX, btnY, this.mouseIn(mouseX, mouseY, checkX, btnY, checkWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
        context.method_51433(tr, nextText, nextX, btnY, this.mouseIn(mouseX, mouseY, nextX, btnY, nextWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
    }

    private void drawVanillaButtons(class_332 context, class_327 tr, int mouseX, int mouseY, int btnY) {
        String prevText = "\u00ab Prev";
        String nextText = "Next \u00bb";
        String checkLabel = "[ " + (this.showOnlyChanged ? "\u2713" : " ") + " ]";
        int spacing = 12;
        int buttonHeight = 10;
        int prevWidth = tr.method_1727(prevText);
        int checkWidth = tr.method_1727(checkLabel);
        int nextWidth = tr.method_1727(nextText);
        int centerX = this.x + this.width / 2;
        int prevX = centerX - checkWidth / 2 - spacing - prevWidth;
        int checkX = centerX - checkWidth / 2;
        int nextX = centerX + checkWidth / 2 + spacing;
        context.method_51433(tr, prevText, prevX, btnY, this.mouseIn(mouseX, mouseY, prevX, btnY, prevWidth, buttonHeight) ? 0xFFFFFF : 0xAAAAAA, false);
        context.method_51433(tr, checkLabel, checkX, btnY, this.mouseIn(mouseX, mouseY, checkX, btnY, checkWidth, buttonHeight) ? 0xFFFFFF : 0xAAAAAA, false);
        context.method_51433(tr, nextText, nextX, btnY, this.mouseIn(mouseX, mouseY, nextX, btnY, nextWidth, buttonHeight) ? 0xFFFFFF : 0xAAAAAA, false);
    }

    private boolean mouseIn(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        ButtonCoords coords;
        if (!this.expanded) {
            return false;
        }
        int btnY = this.y + this.height - (AttributesPanelConfig.INSTANCE.useBookBackground ? 20 : 12);
        String prevText = "\u00ab Prev";
        String nextText = "Next \u00bb";
        String checkLabel = "[ " + (this.showOnlyChanged ? "\u2713" : " ") + " ]";
        int prevX = this.x + 20;
        int nextW = this.client.field_1772.method_1727(nextText);
        int nextX = this.x + this.width - 20 - nextW;
        int checkX = this.x + this.width / 2 - this.client.field_1772.method_1727(checkLabel) / 2;
        if (AttributesPanelConfig.INSTANCE.useBookBackground) {
            coords = this.getBookButtonCoords(this.client.field_1772);
            if (this.mouseIn((int)mouseX, (int)mouseY, coords.prevX(), btnY, coords.prevW(), 10)) {
                if (this.currentPage > 0) {
                    --this.currentPage;
                }
                this.client.field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
                return true;
            }
            if (this.mouseIn((int)mouseX, (int)mouseY, coords.nextX(), btnY, coords.nextW(), 10)) {
                int totalPages = (int)Math.ceil((float)this.cachedStats.size() / 6.0f);
                if (this.currentPage < totalPages - 1) {
                    ++this.currentPage;
                }
                this.client.field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
                return true;
            }
            if (this.mouseIn((int)mouseX, (int)mouseY, coords.checkX(), btnY, coords.checkW(), 10)) {
                this.showOnlyChanged = !this.showOnlyChanged;
                this.currentPage = 0;
                this.cacheStats();
                this.client.field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
                return true;
            }
        }
        if (!AttributesPanelConfig.INSTANCE.useBookBackground) {
            coords = this.getBookButtonCoords(this.client.field_1772);
            if (this.mouseIn((int)mouseX, (int)mouseY, prevX, btnY, this.client.field_1772.method_1727(prevText), 10)) {
                if (this.currentPage > 0) {
                    --this.currentPage;
                }
                this.client.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 0.5f);
                return true;
            }
            if (this.mouseIn((int)mouseX, (int)mouseY, nextX, btnY, nextW, 10)) {
                int totalPages = (int)Math.ceil((float)this.cachedStats.size() / 6.0f);
                if (this.currentPage < totalPages - 1) {
                    ++this.currentPage;
                }
                this.client.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 0.5f);
                return true;
            }
            if (this.mouseIn((int)mouseX, (int)mouseY, checkX, btnY, this.client.field_1772.method_1727(checkLabel), 10)) {
                this.showOnlyChanged = !this.showOnlyChanged;
                this.currentPage = 0;
                this.cacheStats();
                this.client.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 0.5f);
                return true;
            }
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    private record ButtonCoords(int prevX, int checkX, int nextX, int prevW, int checkW, int nextW) {
    }
}

