/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.compat;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.pixeldreamstudios.iconleadingtooltip.util.IconLeadingUtil;

@Environment(value=EnvType.CLIENT)
public class IconLeadingCompat {
    private static final boolean ICON_LEADING_LOADED = FabricLoader.getInstance().isModLoaded("icon-leading-tooltip");

    public static boolean isLoaded() {
        return ICON_LEADING_LOADED;
    }

    public static IconSplit extractIcon(String text) {
        if (!ICON_LEADING_LOADED || text == null || text.isEmpty()) {
            return new IconSplit(text, null);
        }
        try {
            String noCodes = IconLeadingUtil.stripSectionCodes((String)text);
            int[] span = IconLeadingUtil.firstIconSpan((String)noCodes);
            if (span[0] >= 0) {
                String icon = noCodes.substring(span[0], span[1]);
                String rest = noCodes.substring(0, span[0]) + noCodes.substring(span[1]);
                String clean = IconLeadingUtil.stripSectionCodes((String)rest).trim();
                return new IconSplit(clean, icon);
            }
            return new IconSplit(noCodes, null);
        }
        catch (Exception e) {
            return new IconSplit(text, null);
        }
    }

    public static IconSplit extractIcon(class_2561 text) {
        if (text == null) {
            return new IconSplit("", null);
        }
        return IconLeadingCompat.extractIcon(text.getString());
    }

    public static IconSplit extractIconWithFallback(String displayName, String translationKey) {
        if (!ICON_LEADING_LOADED) {
            return new IconSplit(displayName, null);
        }
        IconSplit result = IconLeadingCompat.extractIcon(displayName);
        if (result.hasIcon()) {
            return result;
        }
        if (translationKey != null && !translationKey.isEmpty() && (result = IconLeadingCompat.extractIcon(translationKey)).hasIcon()) {
            return result;
        }
        return new IconSplit(displayName, null);
    }

    public static boolean isIconGlyph(int codepoint) {
        if (!ICON_LEADING_LOADED) {
            return false;
        }
        try {
            return IconLeadingUtil.isIconGlyph((int)codepoint);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class IconSplit {
        public final String cleanName;
        public final String leadingIcon;

        public IconSplit(String cleanName, String leadingIcon) {
            this.cleanName = cleanName;
            this.leadingIcon = leadingIcon;
        }

        public boolean hasIcon() {
            return this.leadingIcon != null && !this.leadingIcon.isEmpty();
        }
    }
}

