/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.Lighting;
import com.teamabnormals.clayworks.common.DecoratedPotTrimPattern;
import com.teamabnormals.clayworks.common.inventory.PotteryMenu;
import com.teamabnormals.clayworks.core.Clayworks;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PotteryScreen
extends AbstractContainerScreen<PotteryMenu> {
    private static final ResourceLocation POT_SLOT_SPRITE = Clayworks.location("container/pottery_table/pot_slot");
    private static final ResourceLocation DYE_SLOT_SPRITE = Clayworks.location("container/pottery_table/dye_slot");
    private static final ResourceLocation SCROLLER_SPRITE = Clayworks.location("container/pottery_table/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = Clayworks.location("container/pottery_table/scroller_disabled");
    private static final ResourceLocation PATTERN_SELECTED_SPRITE = Clayworks.location("container/pottery_table/pattern_selected");
    private static final ResourceLocation PATTERN_HIGHLIGHTED_SPRITE = Clayworks.location("container/pottery_table/pattern_highlighted");
    private static final ResourceLocation PATTERN_SPRITE = Clayworks.location("container/pottery_table/pattern");
    private static final ResourceLocation BG_LOCATION = Clayworks.location("textures/gui/container/pottery_table.png");
    private ItemStack decoratedPotStack = ItemStack.EMPTY;
    private ItemStack dyeStack = ItemStack.EMPTY;
    private ItemStack trimMaterialStack = ItemStack.EMPTY;
    private boolean displayPatterns;
    private float scrollOffs;
    private boolean scrolling;
    private int startRow;
    private final CyclingSlotBackground additionalIcon = new CyclingSlotBackground(2);

    public PotteryScreen(PotteryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        menu.registerUpdateListener(this::containerChanged);
        this.titleLabelY -= 2;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void containerTick() {
        super.containerTick();
        this.additionalIcon.tick(SmithingTemplateItem.createTrimmableMaterialIconList());
    }

    private int totalRowCount() {
        return Mth.positiveCeilDiv((int)((PotteryMenu)this.menu).getSelectablePatterns().size(), (int)4);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BG_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        Slot slot = ((PotteryMenu)this.menu).getDecoratedPotSlot();
        Slot slot1 = ((PotteryMenu)this.menu).getDyeSlot();
        Slot slot2 = ((PotteryMenu)this.menu).getTrimMaterialSlot();
        Slot slot3 = ((PotteryMenu)this.menu).getResultSlot();
        if (!slot.hasItem()) {
            guiGraphics.blitSprite(POT_SLOT_SPRITE, i + slot.x, j + slot.y, 16, 16);
        }
        if (!slot1.hasItem()) {
            guiGraphics.blitSprite(DYE_SLOT_SPRITE, i + slot1.x, j + slot1.y, 16, 16);
        }
        if (!slot2.hasItem()) {
            this.additionalIcon.render(this.menu, guiGraphics, partialTick, i, j);
        }
        int k = (int)(41.0f * this.scrollOffs);
        ResourceLocation resourcelocation = this.displayPatterns ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(resourcelocation, i + 119, j + 15 + k, 12, 15);
        Lighting.setupForFlatItems();
        if (this.displayPatterns) {
            int j2 = i + 52;
            int k2 = j + 14;
            List<Holder<DecoratedPotTrimPattern>> list = ((PotteryMenu)this.menu).getSelectablePatterns();
            block0: for (int l = 0; l < 3; ++l) {
                for (int i1 = 0; i1 < 4; ++i1) {
                    boolean flag;
                    int j1 = l + this.startRow;
                    int k1 = j1 * 4 + i1;
                    if (k1 >= list.size()) break block0;
                    int l1 = j2 + i1 * 16;
                    int i2 = k2 + l * 18;
                    boolean bl = flag = mouseX >= l1 && mouseY >= i2 && mouseX < l1 + 16 && mouseY < i2 + 18;
                    ResourceLocation resourcelocation1 = k1 == ((PotteryMenu)this.menu).getSelectedBannerPatternIndex() ? PATTERN_SELECTED_SPRITE : (flag ? PATTERN_HIGHLIGHTED_SPRITE : PATTERN_SPRITE);
                    guiGraphics.blitSprite(resourcelocation1, l1, i2 + 1, 16, 18);
                    this.renderPattern(guiGraphics, list.get(k1), l1, i2 + 2);
                }
            }
        }
        Lighting.setupFor3DItems();
    }

    private void renderPattern(GuiGraphics guiGraphics, Holder<DecoratedPotTrimPattern> pattern, int x, int y) {
        guiGraphics.renderItem(((PotteryMenu)this.menu).getResultStack(pattern), x, y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayPatterns) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < 4; ++l) {
                    double d0 = mouseX - (double)(i + l * 16);
                    double d1 = mouseY - (double)(j + k * 18);
                    int i1 = k + this.startRow;
                    int j1 = i1 * 4 + l;
                    if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((PotteryMenu)this.menu).clickMenuButton((Player)this.minecraft.player, j1)) continue;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_LOOM_SELECT_PATTERN, (float)1.0f));
                    this.minecraft.gameMode.handleInventoryButtonClick(((PotteryMenu)this.menu).containerId, j1);
                    return true;
                }
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int i = this.totalRowCount() - 3;
        if (this.scrolling && this.displayPatterns && i > 0) {
            int j = this.topPos + 14;
            int k = j + 54;
            this.scrollOffs = ((float)mouseY - (float)j - 7.5f) / ((float)(k - j) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startRow = Math.max((int)((double)(this.scrollOffs * (float)i) + 0.5), 0);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = this.totalRowCount() - 3;
        if (this.displayPatterns && i > 0) {
            float f = (float)scrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startRow = Math.max((int)(this.scrollOffs * (float)i + 0.5f), 0);
        }
        return true;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return mouseX < (double)guiLeft || mouseY < (double)guiTop || mouseX >= (double)(guiLeft + this.imageWidth) || mouseY >= (double)(guiTop + this.imageHeight);
    }

    private void containerChanged() {
        ItemStack pot = ((PotteryMenu)this.menu).getDecoratedPotSlot().getItem();
        ItemStack dye = ((PotteryMenu)this.menu).getDyeSlot().getItem();
        ItemStack trimMaterial = ((PotteryMenu)this.menu).getTrimMaterialSlot().getItem();
        if (!(ItemStack.matches((ItemStack)pot, (ItemStack)this.decoratedPotStack) && ItemStack.matches((ItemStack)dye, (ItemStack)this.dyeStack) && ItemStack.matches((ItemStack)trimMaterial, (ItemStack)this.trimMaterialStack))) {
            boolean bl = this.displayPatterns = !pot.isEmpty() && !((PotteryMenu)this.menu).getSelectablePatterns().isEmpty();
        }
        if (this.startRow >= this.totalRowCount()) {
            this.startRow = 0;
            this.scrollOffs = 0.0f;
        }
        this.decoratedPotStack = pot.copy();
        this.dyeStack = dye.copy();
        this.trimMaterialStack = trimMaterial.copy();
    }
}

