/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.clayworks.common.DecoratedPotTrimPattern;
import com.teamabnormals.clayworks.core.Clayworks;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.component.TooltipProvider;

public record DecoratedPotTrim(Holder<TrimMaterial> material, Holder<DecoratedPotTrimPattern> pattern, boolean showInTooltip) implements TooltipProvider
{
    public static final Codec<DecoratedPotTrim> CODEC = RecordCodecBuilder.create(p_337943_ -> p_337943_.group((App)RegistryFixedCodec.create((ResourceKey)Registries.TRIM_MATERIAL).fieldOf("material").forGetter(DecoratedPotTrim::material), (App)RegistryFixedCodec.create(ClayworksRegistries.DECORATED_POT_TRIM_PATTERN).fieldOf("pattern").forGetter(DecoratedPotTrim::pattern), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(DecoratedPotTrim::showInTooltip)).apply((Applicative)p_337943_, DecoratedPotTrim::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DecoratedPotTrim> STREAM_CODEC = StreamCodec.composite((StreamCodec)TrimMaterial.STREAM_CODEC, DecoratedPotTrim::material, DecoratedPotTrimPattern.STREAM_CODEC, DecoratedPotTrim::pattern, (StreamCodec)ByteBufCodecs.BOOL, DecoratedPotTrim::showInTooltip, DecoratedPotTrim::new);
    public static final String DESIGN_TITLE = Util.makeDescriptionId((String)"item", (ResourceLocation)Clayworks.location("decorated_pot.design"));
    public static final Component DESIGN_COMPONENT = Component.translatable((String)DESIGN_TITLE).withStyle(ChatFormatting.GRAY);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DecoratedPotTrim)) return false;
        DecoratedPotTrim trim = (DecoratedPotTrim)other;
        if (this.showInTooltip() != trim.showInTooltip()) return false;
        if (!this.pattern.equals(trim.pattern)) return false;
        if (!this.material.equals(trim.material)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int i = this.material.hashCode();
        i = 31 * i + this.pattern.hashCode();
        return 31 * i + (this.showInTooltip() ? 1 : 0);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        if (this.showInTooltip()) {
            tooltipAdder.accept(DESIGN_COMPONENT);
            tooltipAdder.accept((Component)CommonComponents.space().append(((DecoratedPotTrimPattern)this.pattern.value()).copyWithStyle(this.material)));
            tooltipAdder.accept((Component)CommonComponents.space().append(((TrimMaterial)this.material.value()).description()));
        }
    }

    public CompoundTag save(HolderLookup.Provider access, CompoundTag tag) {
        tag.put("trim", (Tag)CODEC.encodeStart((DynamicOps)access.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow());
        return tag;
    }

    public static Optional<DecoratedPotTrim> load(HolderLookup.Provider access, @Nullable CompoundTag tag) {
        return tag != null && tag.contains("trim") ? Optional.of(CODEC.parse((DynamicOps)access.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("trim")).result()).orElse(Optional.empty()) : Optional.empty();
    }
}

