/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.common;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.clayworks.core.Clayworks;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.armortrim.TrimMaterial;

public record DecoratedPotTrimPattern(ResourceLocation assetId, Component description) {
    public static final List<ResourceKey<DecoratedPotTrimPattern>> PATTERNS = Lists.newArrayList();
    public static final ResourceKey<DecoratedPotTrimPattern> BASE = DecoratedPotTrimPattern.createKey("base");
    public static final Codec<DecoratedPotTrimPattern> DIRECT_CODEC = RecordCodecBuilder.create(p_304350_ -> p_304350_.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(DecoratedPotTrimPattern::assetId), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(DecoratedPotTrimPattern::description)).apply((Applicative)p_304350_, DecoratedPotTrimPattern::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DecoratedPotTrimPattern> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, DecoratedPotTrimPattern::assetId, (StreamCodec)ComponentSerialization.STREAM_CODEC, DecoratedPotTrimPattern::description, DecoratedPotTrimPattern::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DecoratedPotTrimPattern>> STREAM_CODEC = ByteBufCodecs.holder(ClayworksRegistries.DECORATED_POT_TRIM_PATTERN, DIRECT_STREAM_CODEC);

    public static void bootstrap(BootstrapContext<DecoratedPotTrimPattern> context) {
        DecoratedPotTrimPattern.register(context, BASE);
        DecoratedPotTrimPattern.register(context, "border");
        DecoratedPotTrimPattern.register(context, "bunting");
        DecoratedPotTrimPattern.register(context, "closed");
        DecoratedPotTrimPattern.register(context, "curled");
        DecoratedPotTrimPattern.register(context, "dashes");
        DecoratedPotTrimPattern.register(context, "dots");
        DecoratedPotTrimPattern.register(context, "double");
        DecoratedPotTrimPattern.register(context, "fold");
        DecoratedPotTrimPattern.register(context, "frame");
        DecoratedPotTrimPattern.register(context, "inverted");
        DecoratedPotTrimPattern.register(context, "jaw");
        DecoratedPotTrimPattern.register(context, "jut");
        DecoratedPotTrimPattern.register(context, "lines");
        DecoratedPotTrimPattern.register(context, "loop");
        DecoratedPotTrimPattern.register(context, "octal");
        DecoratedPotTrimPattern.register(context, "opened");
        DecoratedPotTrimPattern.register(context, "quad");
        DecoratedPotTrimPattern.register(context, "ridged");
        DecoratedPotTrimPattern.register(context, "ripple");
        DecoratedPotTrimPattern.register(context, "steps");
        DecoratedPotTrimPattern.register(context, "straight");
        DecoratedPotTrimPattern.register(context, "striped");
        DecoratedPotTrimPattern.register(context, "studded");
        DecoratedPotTrimPattern.register(context, "thick");
        DecoratedPotTrimPattern.register(context, "twine");
        DecoratedPotTrimPattern.register(context, "wave");
        DecoratedPotTrimPattern.register(context, "zag");
        DecoratedPotTrimPattern.register(context, "zig");
    }

    public static void register(BootstrapContext<DecoratedPotTrimPattern> context, ResourceKey<DecoratedPotTrimPattern> key) {
        context.register(key, (Object)new DecoratedPotTrimPattern(key.location().withPrefix("entity/decorated_pot_trim_patterns/"), (Component)Component.translatable((String)Util.makeDescriptionId((String)"decorated_pot_trim_pattern", (ResourceLocation)key.location()))));
    }

    public static void register(BootstrapContext<DecoratedPotTrimPattern> context, String name) {
        DecoratedPotTrimPattern.register(context, DecoratedPotTrimPattern.createKey(name));
    }

    public static ResourceKey<DecoratedPotTrimPattern> createKey(String name) {
        ResourceKey pattern = ResourceKey.create(ClayworksRegistries.DECORATED_POT_TRIM_PATTERN, (ResourceLocation)Clayworks.location(name));
        PATTERNS.add((ResourceKey<DecoratedPotTrimPattern>)pattern);
        return pattern;
    }

    public Component copyWithStyle(Holder<TrimMaterial> trimMaterial) {
        return this.description.copy().withStyle(((TrimMaterial)trimMaterial.value()).description().getStyle());
    }
}

