/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.clayworks.common.block.entity.KilnBlockEntity;
import com.teamabnormals.clayworks.core.registry.ClayworksBlockEntityTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksParticleTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KilnBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<KilnBlock> CODEC = KilnBlock.simpleCodec(KilnBlock::new);

    public KilnBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ClayworksBlockEntityTypes.KILN.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return KilnBlock.createFurnaceTicker((Level)level, blockEntityType, (BlockEntityType)((BlockEntityType)ClayworksBlockEntityTypes.KILN.get()));
    }

    protected void openContainer(Level worldIn, BlockPos pos, Player player) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof KilnBlockEntity) {
            player.openMenu((MenuProvider)tileentity);
            player.awardStat(Stats.INTERACT_WITH_SMOKER);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                worldIn.playLocalSound(d0, d1, d2, (SoundEvent)ClayworksSoundEvents.KILN_SMOKE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            SimpleParticleType particleType = (SimpleParticleType)ClayworksParticleTypes.KILN_SMOKE.get();
            worldIn.addAlwaysVisibleParticle((ParticleOptions)particleType, true, d0 + rand.nextDouble() / 8.0 * (double)(rand.nextBoolean() ? 1 : -1), d1 + rand.nextDouble() + rand.nextDouble() * 0.5, d2 + rand.nextDouble() / 8.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }
}

