/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.common.inventory;

import com.teamabnormals.clayworks.common.DecoratedPotTrim;
import com.teamabnormals.clayworks.common.DecoratedPotTrimPattern;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksDataComponents;
import com.teamabnormals.clayworks.core.registry.ClayworksMenuTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;

public class PotteryMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    final DataSlot selectedBannerPatternIndex = DataSlot.standalone();
    private List<Holder<DecoratedPotTrimPattern>> selectablePatterns = List.of();
    Runnable slotUpdateListener = () -> {};
    private final RegistryAccess registryAccess;
    final Slot decoratedPotSlot;
    final Slot dyeSlot;
    private final Slot trimMaterialSlot;
    private final Slot resultSlot;
    long lastSoundTime;
    private final Container inputContainer = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            PotteryMenu.this.slotsChanged((Container)this);
            PotteryMenu.this.slotUpdateListener.run();
        }
    };
    private final Container outputContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            PotteryMenu.this.slotUpdateListener.run();
        }
    };

    public PotteryMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public PotteryMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super((MenuType)ClayworksMenuTypes.POTTERY.get(), containerId);
        this.access = access;
        this.decoratedPotSlot = this.addSlot(new Slot(this, this.inputContainer, 0, 9, 26){

            public boolean mayPlace(ItemStack stack) {
                return Block.byItem((Item)stack.getItem()) instanceof DecoratedPotBlock;
            }
        });
        this.dyeSlot = this.addSlot(new Slot(this, this.inputContainer, 1, 29, 26){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof DyeItem;
            }
        });
        this.trimMaterialSlot = this.addSlot(new Slot(this, this.inputContainer, 2, 19, 45){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ItemTags.TRIM_MATERIALS);
            }
        });
        this.resultSlot = this.addSlot(new Slot(this.outputContainer, 0, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                PotteryMenu.this.decoratedPotSlot.remove(1);
                PotteryMenu.this.dyeSlot.remove(1);
                PotteryMenu.this.trimMaterialSlot.remove(1);
                access.execute((p_39952_, p_39953_) -> {
                    long l = p_39952_.getGameTime();
                    if (PotteryMenu.this.lastSoundTime != l) {
                        p_39952_.playSound(null, p_39953_, SoundEvents.UI_LOOM_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        PotteryMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(this.selectedBannerPatternIndex);
        this.registryAccess = playerInventory.player.registryAccess();
    }

    public boolean stillValid(Player player) {
        return PotteryMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ClayworksBlocks.POTTERY_TABLE.get()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0 && id < this.selectablePatterns.size()) {
            this.selectedBannerPatternIndex.set(id);
            this.setupResultSlot(this.selectablePatterns.get(id));
            return true;
        }
        return false;
    }

    private List<Holder<DecoratedPotTrimPattern>> getSelectablePatterns(ItemStack stack) {
        return this.registryAccess.registryOrThrow(ClayworksRegistries.DECORATED_POT_TRIM_PATTERN).holders().collect(Collectors.toUnmodifiableList());
    }

    private boolean isValidPatternIndex(int index) {
        return index >= 0 && index < this.selectablePatterns.size();
    }

    public void slotsChanged(Container inventory) {
        boolean canDye;
        ItemStack potItem = this.decoratedPotSlot.getItem();
        ItemStack dyeItem = this.dyeSlot.getItem();
        ItemStack trimItem = this.trimMaterialSlot.getItem();
        DecoratedPotTrim trim = (DecoratedPotTrim)potItem.get(ClayworksDataComponents.POT_TRIM);
        int i = this.selectedBannerPatternIndex.get();
        boolean valid = this.isValidPatternIndex(i);
        boolean bl = canDye = dyeItem.isEmpty() || ((DyeItem)dyeItem.getItem()).getDyeColor() != ClayworksBlocks.getDyeColorFromPot(Block.byItem((Item)potItem.getItem()));
        if (!potItem.isEmpty() && trim == null && !trimItem.isEmpty() || trimItem.isEmpty() && canDye) {
            Holder<DecoratedPotTrimPattern> holder;
            List<Holder<DecoratedPotTrimPattern>> list = this.selectablePatterns;
            this.selectablePatterns = trimItem.isEmpty() && trim == null ? List.of() : this.getSelectablePatterns(potItem);
            if (this.selectablePatterns.size() == 1) {
                this.selectedBannerPatternIndex.set(0);
                holder = this.selectablePatterns.getFirst();
            } else if (!valid) {
                this.selectedBannerPatternIndex.set(-1);
                holder = null;
            } else {
                Holder<DecoratedPotTrimPattern> holder1 = list.get(i);
                int j = this.selectablePatterns.indexOf(holder1);
                if (j != -1) {
                    holder = holder1;
                    this.selectedBannerPatternIndex.set(j);
                } else {
                    holder = null;
                    this.selectedBannerPatternIndex.set(-1);
                }
            }
            this.setupResultSlot(holder);
            this.broadcastChanges();
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
            this.selectablePatterns = List.of();
            this.selectedBannerPatternIndex.set(-1);
        }
    }

    public List<Holder<DecoratedPotTrimPattern>> getSelectablePatterns() {
        return this.selectablePatterns;
    }

    public int getSelectedBannerPatternIndex() {
        return this.selectedBannerPatternIndex.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == this.resultSlot.index) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != this.dyeSlot.index && index != this.decoratedPotSlot.index && index != this.trimMaterialSlot.index ? (Block.byItem((Item)itemstack1.getItem()) instanceof DecoratedPotBlock ? !this.moveItemStackTo(itemstack1, this.decoratedPotSlot.index, this.decoratedPotSlot.index + 1, false) : (itemstack1.getItem() instanceof DyeItem ? !this.moveItemStackTo(itemstack1, this.dyeSlot.index, this.dyeSlot.index + 1, false) : (itemstack1.is(ItemTags.TRIM_MATERIALS) ? !this.moveItemStackTo(itemstack1, this.trimMaterialSlot.index, this.trimMaterialSlot.index + 1, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))))) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((p_39871_, p_39872_) -> this.clearContainer(player, this.inputContainer));
    }

    public ItemStack getResultStack(@Nullable Holder<DecoratedPotTrimPattern> pattern) {
        ItemStack potItem = this.decoratedPotSlot.getItem();
        ItemStack dyeItem = this.dyeSlot.getItem();
        ItemStack trimItem = this.trimMaterialSlot.getItem();
        ItemStack output = ItemStack.EMPTY;
        if (!potItem.isEmpty()) {
            output = potItem.copyWithCount(1);
            if (!dyeItem.isEmpty()) {
                output = output.transmuteCopy((ItemLike)ClayworksBlocks.getPotFromDyeColor(((DyeItem)dyeItem.getItem()).getDyeColor()));
            }
            DecoratedPotTrim trim = (DecoratedPotTrim)potItem.get(ClayworksDataComponents.POT_TRIM);
            if (pattern != null) {
                Holder material = null;
                if (trim == null && !trimItem.isEmpty()) {
                    material = (Holder)TrimMaterials.getFromIngredient((HolderLookup.Provider)this.registryAccess, (ItemStack)trimItem).get();
                } else if (trim != null) {
                    material = trim.material();
                }
                if (material != null) {
                    output.set((DataComponentType)ClayworksDataComponents.POT_TRIM.get(), (Object)new DecoratedPotTrim((Holder<TrimMaterial>)material, pattern, true));
                }
            } else if (!trimItem.isEmpty()) {
                return ItemStack.EMPTY;
            }
        }
        return output;
    }

    private void setupResultSlot(@Nullable Holder<DecoratedPotTrimPattern> pattern) {
        ItemStack output = this.getResultStack(pattern);
        if (!ItemStack.matches((ItemStack)output, (ItemStack)this.decoratedPotSlot.getItem().copyWithCount(1))) {
            this.resultSlot.set(output);
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
    }

    public Slot getDecoratedPotSlot() {
        return this.decoratedPotSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getTrimMaterialSlot() {
        return this.trimMaterialSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

