/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.common.item.crafting;

import com.teamabnormals.clayworks.common.DecoratedPotTrim;
import com.teamabnormals.clayworks.common.DecoratedPotTrimPattern;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksDataComponents;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.neoforged.neoforge.common.Tags;

public class DecoratedPotColoring
extends CustomRecipe {
    public DecoratedPotColoring(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack stack;
        int slot;
        int ptCount = 0;
        int dyeCount = 0;
        int trimCount = 0;
        ItemStack pot = ItemStack.EMPTY;
        for (slot = 0; slot < input.size(); ++slot) {
            stack = input.getItem(slot);
            if (stack.isEmpty() || !(Block.byItem((Item)stack.getItem()) instanceof DecoratedPotBlock)) continue;
            pot = stack.copy();
            ++ptCount;
        }
        if (ptCount != 1 || pot.isEmpty()) {
            return false;
        }
        for (slot = 0; slot < input.size(); ++slot) {
            stack = input.getItem(slot);
            if (stack.isEmpty()) continue;
            if (stack.is(Tags.Items.DYES) && ((Boolean)ClayworksConfig.COMMON.decoratedPotColors.get()).booleanValue()) {
                ++dyeCount;
                if (DyeColor.getColor((ItemStack)stack) == ClayworksBlocks.getDyeColorFromPot(Block.byItem((Item)pot.getItem()))) {
                    return false;
                }
            } else if (stack.is(ItemTags.TRIM_MATERIALS) && ((Boolean)ClayworksConfig.COMMON.decoratedPotTrims.get()).booleanValue()) {
                ++trimCount;
                if (pot.getComponents().get((DataComponentType)ClayworksDataComponents.POT_TRIM.get()) != null) {
                    return false;
                }
            } else if (!(Block.byItem((Item)stack.getItem()) instanceof DecoratedPotBlock)) {
                return false;
            }
            if (dyeCount <= 1 && trimCount <= 1) continue;
            return false;
        }
        return dyeCount == 1 || trimCount == 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack stack;
        int slot;
        ItemStack output = ItemStack.EMPTY;
        DyeColor color = DyeColor.WHITE;
        for (slot = 0; slot < input.size(); ++slot) {
            Item item;
            Block block;
            stack = input.getItem(slot);
            if (stack.isEmpty() || !((block = Block.byItem((Item)(item = stack.getItem()))) instanceof DecoratedPotBlock)) continue;
            DecoratedPotBlock block2 = (DecoratedPotBlock)block;
            output = stack.copyWithCount(1);
            color = ClayworksBlocks.getDyeColorFromPot((Block)block2);
            break;
        }
        for (slot = 0; slot < input.size(); ++slot) {
            stack = input.getItem(slot);
            if (stack.isEmpty()) continue;
            if (stack.is(Tags.Items.DYES)) {
                DyeColor tmp = DyeColor.getColor((ItemStack)stack);
                if (tmp == null) continue;
                color = tmp;
                continue;
            }
            if (!stack.is(ItemTags.TRIM_MATERIALS)) continue;
            Optional material = TrimMaterials.getFromIngredient((HolderLookup.Provider)provider, (ItemStack)stack);
            Optional pattern = provider.lookupOrThrow(ClayworksRegistries.DECORATED_POT_TRIM_PATTERN).get(DecoratedPotTrimPattern.BASE);
            if (!material.isPresent() || !pattern.isPresent()) continue;
            output.set((DataComponentType)ClayworksDataComponents.POT_TRIM.get(), (Object)new DecoratedPotTrim((Holder<TrimMaterial>)((Holder)material.get()), (Holder<DecoratedPotTrimPattern>)((Holder)pattern.get()), true));
        }
        return output.transmuteCopy((ItemLike)ClayworksBlocks.getPotFromDyeColor(color));
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ClayworksRecipes.ClayworksRecipeSerializers.DECORATED_POT_COLORING.get();
    }
}

