/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core;

import com.teamabnormals.blueprint.client.screen.splash.SplashSerializers;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.clayworks.client.splashes.WoodworksSplash;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.data.client.ClayworksBlockStateProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksLanguageProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksSplashProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksSpriteSourceProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksDataRemolderProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksDatapackBuiltinEntriesProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksLootTableProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksRecipeProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksBlockTagsProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksItemTagsProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksPaintingVariantTagsProvider;
import com.teamabnormals.clayworks.core.other.ClayworksClientCompat;
import com.teamabnormals.clayworks.core.other.ClayworksCompat;
import com.teamabnormals.clayworks.core.registry.ClayworksBlockEntityTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksConditions;
import com.teamabnormals.clayworks.core.registry.ClayworksDataComponents;
import com.teamabnormals.clayworks.core.registry.ClayworksMenuTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksParticleTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import com.teamabnormals.clayworks.core.registry.ClayworksSoundEvents;
import com.teamabnormals.clayworks.core.registry.helper.ClayworksBlockSubRegistryHelper;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="clayworks")
public class Clayworks {
    public static final String MOD_ID = "clayworks";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"clayworks", helper -> helper.putSubHelper(Registries.BLOCK, (ISubRegistryHelper)new ClayworksBlockSubRegistryHelper((RegistryHelper)helper)));

    public Clayworks(IEventBus bus, ModContainer container) {
        ClayworksBlocks.BLOCKS.register(bus);
        ClayworksBlocks.ITEMS.register(bus);
        ClayworksBlockEntityTypes.BLOCK_ENTITY_TYPES.register(bus);
        ClayworksSoundEvents.SOUND_EVENTS.register(bus);
        ClayworksConditions.CONDITION_SERIALIZERS.register(bus);
        ClayworksMenuTypes.MENU_TYPES.register(bus);
        ClayworksRecipes.ClayworksRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ClayworksRecipes.ClayworksRecipeTypes.RECIPE_TYPES.register(bus);
        ClayworksParticleTypes.PARTICLE_TYPES.register(bus);
        ClayworksDataComponents.DATA_COMPONENTS.register(bus);
        bus.addListener(ClayworksRegistries::registerRegistries);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            SplashSerializers.register((ResourceLocation)Clayworks.location("woodworks"), WoodworksSplash.CODEC);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ClayworksConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ClayworksCompat::register);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClayworksClientCompat::register);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        ClayworksDatapackBuiltinEntriesProvider datapackEntries = new ClayworksDatapackBuiltinEntriesProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        ClayworksBlockTagsProvider blockTags = new ClayworksBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new ClayworksItemTagsProvider(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new ClayworksLootTableProvider(output, provider));
        generator.addProvider(server, (DataProvider)new ClayworksRecipeProvider(output, provider));
        generator.addProvider(server, (DataProvider)new ClayworksPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new ClayworksDataRemolderProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new ClayworksSplashProvider(output));
        generator.addProvider(client, (DataProvider)new ClayworksBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new ClayworksLanguageProvider(output));
        generator.addProvider(client, (DataProvider)new ClayworksSpriteSourceProvider(output, provider, helper));
        generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper, provider));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

