/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.clayworks.common.block.KilnBlock;
import com.teamabnormals.clayworks.core.Clayworks;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksDataComponents;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ClayworksLootTableProvider
extends LootTableProvider {
    public ClayworksLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, BuiltInLootTables.all(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(ClayworksBlockLoot::new, LootContextParamSets.BLOCK)), provider);
    }

    protected void validate(WritableRegistry<LootTable> registry, ValidationContext context, ProblemReporter.Collector collector) {
    }

    public static class ClayworksBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.AIR).map(ItemLike::asItem).collect(Collectors.toSet());
        public static final ResourceLocation TRIM_DYNAMIC_DROP_ID = Clayworks.location("trim");

        protected ClayworksBlockLoot(HolderLookup.Provider provider) {
            super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            ((DeferredRegister.Blocks)ClayworksBlocks.BLOCKS.getDeferredRegister()).getEntries().forEach(registryObject -> {
                Block block = (Block)registryObject.get();
                if (block instanceof KilnBlock) {
                    this.add(block, x$0 -> this.createNameableBlockEntityTable((Block)x$0));
                } else if (block instanceof DecoratedPotBlock) {
                    this.add(block, this::createDecoratedPotTable);
                } else if (block instanceof SlabBlock) {
                    this.add(block, x$0 -> this.createSlabItemTable((Block)x$0));
                } else if (block instanceof DoorBlock || block instanceof TrapDoorBlock) {
                    this.dropWhenSilkTouch(block);
                } else {
                    this.dropSelf(block);
                }
            });
        }

        private LootTable.Builder createDecoratedPotTable(Block block) {
            return LootTable.lootTable().withPool(ClayworksBlockLoot.createDynamicTrimDropPool(block)).withPool(ClayworksBlockLoot.createDecoratedPotPool(block));
        }

        public static LootPool.Builder createDynamicTrimDropPool(Block block) {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(DynamicLoot.dynamicEntry((ResourceLocation)TRIM_DYNAMIC_DROP_ID).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DecoratedPotBlock.CRACKED, true))));
        }

        public static LootPool.Builder createDecoratedPotPool(Block block) {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)DynamicLoot.dynamicEntry((ResourceLocation)DecoratedPotBlock.SHERDS_DYNAMIC_DROP_ID).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DecoratedPotBlock.CRACKED, true)))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.POT_DECORATIONS).include((DataComponentType)ClayworksDataComponents.POT_TRIM.get()))));
        }

        public Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("clayworks")).collect(Collectors.toSet());
        }
    }
}

