/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.clayworks.common.item.crafting.BakingRecipe;
import com.teamabnormals.clayworks.common.item.crafting.DecoratedPotColoring;
import com.teamabnormals.clayworks.core.Clayworks;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.other.ClayworksBlockFamilies;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksConditions;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class ClayworksRecipeProvider
extends BlueprintRecipeProvider {
    public static final ConfigValueCondition KILN_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.kiln, "kiln");
    public static final ConfigValueCondition POTTERY_TABLE_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.potteryTable, "pottery_table");
    public static final ConfigValueCondition CHISELED_BRICKS_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.chiseledBricks, "chiseled_bricks");
    public static final ConfigValueCondition GLAZED_TERRACOTTA_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.glazedTerracotta, "glazed_terracotta");
    public static final ConfigValueCondition TERRACOTTA_VARIANTS_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.terracottaVariants, "terracotta_variants");
    public static final ConfigValueCondition TERRACOTTA_BRICKS_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.terracottaBricks, "terracotta_bricks");
    public static final ConfigValueCondition CONCRETE_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.concrete, "concrete");
    public static final BlueprintAndCondition KILN_COMPAT = new BlueprintAndCondition(new ICondition[]{new ModLoadedCondition("clayworks"), KILN_CONFIG});
    public static final ConfigValueCondition GLASS_DOORS = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.glassDoors, "glass_doors");

    public ClayworksRecipeProvider(PackOutput result, CompletableFuture<HolderLookup.Provider> provider) {
        super("clayworks", result, provider);
    }

    public void buildRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ClayworksBlocks.KILN.get())).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).define(Character.valueOf('X'), (ItemLike)Blocks.FURNACE).define(Character.valueOf('B'), (ItemLike)Blocks.MUD_BRICKS).pattern("###").pattern("#X#").pattern("BBB").unlockedBy("has_cobblestone", ClayworksRecipeProvider.has((TagKey)ItemTags.STONE_CRAFTING_MATERIALS)).save(output.withConditions(new ICondition[]{KILN_CONFIG}));
        ClayworksRecipeProvider.generateKilnRecipes(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ClayworksBlocks.POTTERY_TABLE.get())).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), (ItemLike)Items.BRICK).pattern("@@").pattern("##").pattern("##").unlockedBy("has_brick", ClayworksRecipeProvider.has((ItemLike)Items.BRICK)).save(output.withConditions(new ICondition[]{POTTERY_TABLE_CONFIG}));
        SpecialRecipeBuilder.special(DecoratedPotColoring::new).save(output, "clayworks:decorated_pot_coloring");
        ClayworksRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ClayworksBlocks.CHISELED_BRICKS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BRICK_SLAB})).unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)Blocks.BRICK_SLAB), ClayworksRecipeProvider.has((ItemLike)Blocks.BRICK_SLAB)).save(output.withConditions(new ICondition[]{CHISELED_BRICKS_CONFIG}));
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)CHISELED_BRICKS_CONFIG, (ItemLike)ClayworksBlocks.CHISELED_BRICKS.get(), (ItemLike)Blocks.BRICKS);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.TERRACOTTA}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ClayworksBlocks.GLAZED_TERRACOTTA.get()).asItem(), (float)0.1f, (int)200).unlockedBy("has_terracotta", ClayworksRecipeProvider.has((ItemLike)Blocks.TERRACOTTA)).save(output.withConditions(new ICondition[]{GLAZED_TERRACOTTA_CONFIG}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ClayworksBlocks.CONCRETE_POWDER.get()), (int)8).requires((ItemLike)Blocks.SAND, 4).requires((ItemLike)Blocks.GRAVEL, 4).group("concrete_powder").unlockedBy("has_sand", ClayworksRecipeProvider.has((ItemLike)Blocks.SAND)).unlockedBy("has_gravel", ClayworksRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(output.withConditions(new ICondition[]{CONCRETE_CONFIG}));
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.BLACK_CONCRETE, (ItemLike)Blocks.BLACK_CONCRETE_POWDER, (ItemLike)Items.BLACK_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.BLUE_CONCRETE, (ItemLike)Blocks.BLUE_CONCRETE_POWDER, (ItemLike)Items.BLUE_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.BROWN_CONCRETE, (ItemLike)Blocks.BROWN_CONCRETE_POWDER, (ItemLike)Items.BROWN_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.CYAN_CONCRETE, (ItemLike)Blocks.CYAN_CONCRETE_POWDER, (ItemLike)Items.CYAN_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.GRAY_CONCRETE, (ItemLike)Blocks.GRAY_CONCRETE_POWDER, (ItemLike)Items.GRAY_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.GREEN_CONCRETE, (ItemLike)Blocks.GREEN_CONCRETE_POWDER, (ItemLike)Items.GREEN_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.LIGHT_BLUE_CONCRETE, (ItemLike)Blocks.LIGHT_BLUE_CONCRETE_POWDER, (ItemLike)Items.LIGHT_BLUE_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.LIGHT_GRAY_CONCRETE, (ItemLike)Blocks.LIGHT_GRAY_CONCRETE_POWDER, (ItemLike)Items.LIGHT_GRAY_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.LIME_CONCRETE, (ItemLike)Blocks.LIME_CONCRETE_POWDER, (ItemLike)Items.LIME_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.MAGENTA_CONCRETE, (ItemLike)Blocks.MAGENTA_CONCRETE_POWDER, (ItemLike)Items.MAGENTA_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.ORANGE_CONCRETE, (ItemLike)Blocks.ORANGE_CONCRETE_POWDER, (ItemLike)Items.ORANGE_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.PINK_CONCRETE, (ItemLike)Blocks.PINK_CONCRETE_POWDER, (ItemLike)Items.PINK_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.PURPLE_CONCRETE, (ItemLike)Blocks.PURPLE_CONCRETE_POWDER, (ItemLike)Items.PURPLE_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.RED_CONCRETE, (ItemLike)Blocks.RED_CONCRETE_POWDER, (ItemLike)Items.RED_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.WHITE_CONCRETE, (ItemLike)Blocks.WHITE_CONCRETE_POWDER, (ItemLike)Items.WHITE_DYE);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(output, (ItemLike)Blocks.YELLOW_CONCRETE, (ItemLike)Blocks.YELLOW_CONCRETE_POWDER, (ItemLike)Items.YELLOW_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.TERRACOTTA, ClayworksBlockFamilies.TERRACOTTA, ClayworksBlockFamilies.TERRACOTTA_BRICKS, null);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.WHITE_TERRACOTTA, ClayworksBlockFamilies.WHITE_TERRACOTTA, ClayworksBlockFamilies.WHITE_TERRACOTTA_BRICKS, Items.WHITE_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.ORANGE_TERRACOTTA, ClayworksBlockFamilies.ORANGE_TERRACOTTA, ClayworksBlockFamilies.ORANGE_TERRACOTTA_BRICKS, Items.ORANGE_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.MAGENTA_TERRACOTTA, ClayworksBlockFamilies.MAGENTA_TERRACOTTA, ClayworksBlockFamilies.MAGENTA_TERRACOTTA_BRICKS, Items.MAGENTA_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.LIGHT_BLUE_TERRACOTTA, ClayworksBlockFamilies.LIGHT_BLUE_TERRACOTTA, ClayworksBlockFamilies.LIGHT_BLUE_TERRACOTTA_BRICKS, Items.LIGHT_BLUE_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.YELLOW_TERRACOTTA, ClayworksBlockFamilies.YELLOW_TERRACOTTA, ClayworksBlockFamilies.YELLOW_TERRACOTTA_BRICKS, Items.YELLOW_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.LIME_TERRACOTTA, ClayworksBlockFamilies.LIME_TERRACOTTA, ClayworksBlockFamilies.LIME_TERRACOTTA_BRICKS, Items.LIME_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.PINK_TERRACOTTA, ClayworksBlockFamilies.PINK_TERRACOTTA, ClayworksBlockFamilies.PINK_TERRACOTTA_BRICKS, Items.PINK_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.GRAY_TERRACOTTA, ClayworksBlockFamilies.GRAY_TERRACOTTA, ClayworksBlockFamilies.GRAY_TERRACOTTA_BRICKS, Items.GRAY_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.LIGHT_GRAY_TERRACOTTA, ClayworksBlockFamilies.LIGHT_GRAY_TERRACOTTA, ClayworksBlockFamilies.LIGHT_GRAY_TERRACOTTA_BRICKS, Items.LIGHT_GRAY_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.CYAN_TERRACOTTA, ClayworksBlockFamilies.CYAN_TERRACOTTA, ClayworksBlockFamilies.CYAN_TERRACOTTA_BRICKS, Items.CYAN_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.PURPLE_TERRACOTTA, ClayworksBlockFamilies.PURPLE_TERRACOTTA, ClayworksBlockFamilies.PURPLE_TERRACOTTA_BRICKS, Items.PURPLE_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.BLUE_TERRACOTTA, ClayworksBlockFamilies.BLUE_TERRACOTTA, ClayworksBlockFamilies.BLUE_TERRACOTTA_BRICKS, Items.BLUE_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.BROWN_TERRACOTTA, ClayworksBlockFamilies.BROWN_TERRACOTTA, ClayworksBlockFamilies.BROWN_TERRACOTTA_BRICKS, Items.BROWN_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.GREEN_TERRACOTTA, ClayworksBlockFamilies.GREEN_TERRACOTTA, ClayworksBlockFamilies.GREEN_TERRACOTTA_BRICKS, Items.GREEN_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.RED_TERRACOTTA, ClayworksBlockFamilies.RED_TERRACOTTA, ClayworksBlockFamilies.RED_TERRACOTTA_BRICKS, Items.RED_DYE);
        ClayworksRecipeProvider.terracottaBricksRecipes(output, Blocks.BLACK_TERRACOTTA, ClayworksBlockFamilies.BLACK_TERRACOTTA, ClayworksBlockFamilies.BLACK_TERRACOTTA_BRICKS, Items.BLACK_DYE);
        ClayworksRecipeProvider.glassDoorRecipes(output, ClayworksBlockFamilies.GLASS);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.WHITE_STAINED_GLASS, (ItemLike)Items.WHITE_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.ORANGE_STAINED_GLASS, (ItemLike)Items.ORANGE_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.MAGENTA_STAINED_GLASS, (ItemLike)Items.MAGENTA_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.LIGHT_BLUE_STAINED_GLASS, (ItemLike)Items.LIGHT_BLUE_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.YELLOW_STAINED_GLASS, (ItemLike)Items.YELLOW_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.LIME_STAINED_GLASS, (ItemLike)Items.LIME_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.PINK_STAINED_GLASS, (ItemLike)Items.PINK_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.GRAY_STAINED_GLASS, (ItemLike)Items.GRAY_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.LIGHT_GRAY_STAINED_GLASS, (ItemLike)Items.LIGHT_GRAY_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.CYAN_STAINED_GLASS, (ItemLike)Items.CYAN_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.PURPLE_STAINED_GLASS, (ItemLike)Items.PURPLE_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.BLUE_STAINED_GLASS, (ItemLike)Items.BLUE_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.BROWN_STAINED_GLASS, (ItemLike)Items.BROWN_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.GREEN_STAINED_GLASS, (ItemLike)Items.GREEN_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.RED_STAINED_GLASS, (ItemLike)Items.RED_DYE);
        this.stainedGlassDoorRecipes(output, ClayworksBlockFamilies.BLACK_STAINED_GLASS, (ItemLike)Items.BLACK_DYE);
    }

    public static void generateKilnRecipes(RecipeOutput output) {
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (TagKey<Item>)ItemTags.SMELTS_TO_GLASS, "has_smelts_to_glass", (ItemLike)Blocks.GLASS, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.MISC, (TagKey<Item>)ItemTags.LOGS_THAT_BURN, "has_log", (ItemLike)Items.CHARCOAL, 0.15f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WET_SPONGE, (ItemLike)Blocks.SPONGE, 0.15f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.MISC, (ItemLike)Blocks.SEA_PICKLE, (ItemLike)Items.LIME_DYE, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.MISC, (ItemLike)Blocks.CACTUS, (ItemLike)Items.GREEN_DYE, 1.0f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.MISC, (ItemLike)Items.CHORUS_FRUIT, (ItemLike)Items.POPPED_CHORUS_FRUIT, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.MISC, (ItemLike)Items.CLAY_BALL, (ItemLike)Items.BRICK, 0.3f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CLAY, (ItemLike)Blocks.TERRACOTTA, 0.35f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.MISC, (ItemLike)Blocks.NETHERRACK, (ItemLike)Items.NETHER_BRICK, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE, (ItemLike)Blocks.STONE, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLED_DEEPSLATE, (ItemLike)Blocks.DEEPSLATE, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.STONE, (ItemLike)Blocks.SMOOTH_STONE, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.SANDSTONE, (ItemLike)Blocks.SMOOTH_SANDSTONE, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.RED_SANDSTONE, (ItemLike)Blocks.SMOOTH_RED_SANDSTONE, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.QUARTZ_BLOCK, (ItemLike)Blocks.SMOOTH_QUARTZ, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BASALT, (ItemLike)Blocks.SMOOTH_BASALT, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.STONE_BRICKS, (ItemLike)Blocks.CRACKED_STONE_BRICKS, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.POLISHED_BLACKSTONE_BRICKS, (ItemLike)Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.NETHER_BRICKS, (ItemLike)Blocks.CRACKED_NETHER_BRICKS, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.DEEPSLATE_BRICKS, (ItemLike)Blocks.CRACKED_DEEPSLATE_BRICKS, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.DEEPSLATE_TILES, (ItemLike)Blocks.CRACKED_DEEPSLATE_TILES, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, (ICondition)new BlueprintAndCondition(new ICondition[]{KILN_CONFIG, GLAZED_TERRACOTTA_CONFIG}), RecipeCategory.DECORATIONS, (ItemLike)Blocks.TERRACOTTA, (ItemLike)ClayworksBlocks.GLAZED_TERRACOTTA.get(), 0.1f, 100, "clayworks");
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.BLACK_TERRACOTTA, (ItemLike)Blocks.BLACK_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.BLUE_TERRACOTTA, (ItemLike)Blocks.BLUE_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.BROWN_TERRACOTTA, (ItemLike)Blocks.BROWN_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.CYAN_TERRACOTTA, (ItemLike)Blocks.CYAN_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.GRAY_TERRACOTTA, (ItemLike)Blocks.GRAY_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.GREEN_TERRACOTTA, (ItemLike)Blocks.GREEN_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.LIGHT_BLUE_TERRACOTTA, (ItemLike)Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.LIGHT_GRAY_TERRACOTTA, (ItemLike)Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.LIME_TERRACOTTA, (ItemLike)Blocks.LIME_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.MAGENTA_TERRACOTTA, (ItemLike)Blocks.MAGENTA_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.ORANGE_TERRACOTTA, (ItemLike)Blocks.ORANGE_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.PINK_TERRACOTTA, (ItemLike)Blocks.PINK_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.PURPLE_TERRACOTTA, (ItemLike)Blocks.PURPLE_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.RED_TERRACOTTA, (ItemLike)Blocks.RED_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.WHITE_TERRACOTTA, (ItemLike)Blocks.WHITE_GLAZED_TERRACOTTA, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)Blocks.YELLOW_TERRACOTTA, (ItemLike)Blocks.YELLOW_GLAZED_TERRACOTTA, 0.1f, 100);
    }

    private static void terracottaBricksRecipes(RecipeOutput output, Block terracotta, BlockFamily family, BlockFamily bricksFamily, @Nullable Item dye) {
        ClayworksRecipeProvider.generateConditionalRecipes(output, family, (ICondition)TERRACOTTA_VARIANTS_CONFIG);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_VARIANTS_CONFIG, (ItemLike)family.get(BlockFamily.Variant.SLAB), (ItemLike)family.getBaseBlock(), 2);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_VARIANTS_CONFIG, (ItemLike)family.get(BlockFamily.Variant.STAIRS), (ItemLike)family.getBaseBlock());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.DECORATIONS, (ICondition)TERRACOTTA_VARIANTS_CONFIG, (ItemLike)family.get(BlockFamily.Variant.WALL), (ItemLike)family.getBaseBlock());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricksFamily.getBaseBlock(), (int)4).define(Character.valueOf('#'), (ItemLike)terracotta).pattern("##").pattern("##").unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)terracotta), ClayworksRecipeProvider.has((ItemLike)terracotta)).save(output.withConditions(new ICondition[]{TERRACOTTA_BRICKS_CONFIG}));
        ClayworksRecipeProvider.generateConditionalRecipes(output, bricksFamily, (ICondition)TERRACOTTA_BRICKS_CONFIG);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.SLAB), (ItemLike)bricksFamily.getBaseBlock(), 2);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.STAIRS), (ItemLike)bricksFamily.getBaseBlock());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.DECORATIONS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.WALL), (ItemLike)bricksFamily.getBaseBlock());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.CHISELED), (ItemLike)bricksFamily.getBaseBlock());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.getBaseBlock(), (ItemLike)terracotta);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.SLAB), (ItemLike)terracotta, 2);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.STAIRS), (ItemLike)terracotta);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.DECORATIONS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.WALL), (ItemLike)terracotta);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.get(BlockFamily.Variant.CHISELED), (ItemLike)terracotta);
        if (dye != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricksFamily.getBaseBlock(), (int)8).define(Character.valueOf('#'), (ItemLike)ClayworksBlocks.TERRACOTTA_BRICKS.get()).define(Character.valueOf('X'), (ItemLike)dye).pattern("###").pattern("#X#").pattern("###").group("stained_terracotta_bricks").unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)Blocks.TERRACOTTA), ClayworksRecipeProvider.has((ItemLike)Blocks.TERRACOTTA)).save(output.withConditions(new ICondition[]{TERRACOTTA_BRICKS_CONFIG}), Clayworks.location(ClayworksRecipeProvider.getConversionRecipeName((ItemLike)bricksFamily.getBaseBlock(), (ItemLike)dye)));
        }
    }

    public static SimpleCookingRecipeBuilder baking(Ingredient ingredient, RecipeCategory category, ItemLike result, float experience, int cookingTime) {
        return SimpleCookingRecipeBuilder.generic((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, (RecipeSerializer)((RecipeSerializer)ClayworksRecipes.ClayworksRecipeSerializers.BAKING_RECIPE.get()), BakingRecipe::new);
    }

    public static void bakingRecipe(RecipeOutput output, RecipeCategory category, TagKey<Item> ingredient, String hasIngredient, ItemLike result, float experience, int cookingTime) {
        ClayworksRecipeProvider.bakingRecipe(output, category, ingredient, hasIngredient, result, experience, cookingTime, "clayworks");
    }

    public static void bakingRecipe(RecipeOutput output, RecipeCategory category, ItemLike ingredient, ItemLike result, float experience, int cookingTime) {
        ClayworksRecipeProvider.bakingRecipe(output, category, ingredient, result, experience, cookingTime, "clayworks");
    }

    public static void bakingRecipe(RecipeOutput output, RecipeCategory category, TagKey<Item> ingredient, String hasIngredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.bakingRecipe(output, (ICondition)(modid.equals("clayworks") ? KILN_CONFIG : KILN_COMPAT), category, ingredient, hasIngredient, result, experience, cookingTime, modid);
    }

    public static void bakingRecipe(RecipeOutput output, RecipeCategory category, ItemLike ingredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.bakingRecipe(output, (ICondition)(modid.equals("clayworks") ? KILN_CONFIG : KILN_COMPAT), category, ingredient, result, experience, cookingTime, modid);
    }

    public static void bakingRecipe(RecipeOutput output, ICondition condition, RecipeCategory category, TagKey<Item> ingredient, String hasIngredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.baking(Ingredient.of(ingredient), category, result, experience, cookingTime).unlockedBy(hasIngredient, ClayworksRecipeProvider.has(ingredient)).save(output.withConditions(new ICondition[]{condition}), ResourceLocation.fromNamespaceAndPath((String)modid, (String)(ClayworksRecipeProvider.getItemName((ItemLike)result) + "_from_baking")));
    }

    public static void bakingRecipe(RecipeOutput output, ICondition condition, RecipeCategory category, ItemLike ingredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.baking(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), category, result, experience, cookingTime).unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)ingredient), ClayworksRecipeProvider.has((ItemLike)ingredient)).save(output.withConditions(new ICondition[]{condition}), ResourceLocation.fromNamespaceAndPath((String)modid, (String)(ClayworksRecipeProvider.getItemName((ItemLike)result) + "_from_baking")));
    }

    protected static void generateConditionalRecipes(RecipeOutput output, BlockFamily family, ICondition condition) {
        family.getVariants().forEach((variant, result) -> {
            BiFunction function = (BiFunction)SHAPE_BUILDERS.get(variant);
            Block block = ClayworksRecipeProvider.getBaseBlock((BlockFamily)family, (BlockFamily.Variant)variant);
            if (function != null) {
                RecipeBuilder recipebuilder = (RecipeBuilder)function.apply(result, block);
                family.getRecipeGroupPrefix().ifPresent(p_176601_ -> recipebuilder.group(p_176601_ + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.name())));
                recipebuilder.unlockedBy(family.getRecipeUnlockedBy().orElseGet(() -> ClayworksRecipeProvider.lambda$generateConditionalRecipes$1((ItemLike)block)), ClayworksRecipeProvider.has((ItemLike)block));
                recipebuilder.save(output.withConditions(new ICondition[]{condition}));
            }
            if (variant == BlockFamily.Variant.CRACKED) {
                ClayworksRecipeProvider.smeltingResultFromBase((RecipeOutput)output, (ItemLike)result, (ItemLike)block);
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)0.1f, (int)200).unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)block), ClayworksRecipeProvider.has((ItemLike)block)).save(output.withConditions(new ICondition[]{condition}).withConditions(new ICondition[]{condition}));
            }
        });
    }

    protected void stainedGlassDoorFromDye(RecipeOutput output, ItemLike input, ItemLike door, ItemLike dye, String group) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)door).requires(input).requires(dye).group(group).unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)input), ClayworksRecipeProvider.has((ItemLike)input)).save(output.withConditions(new ICondition[]{GLASS_DOORS}), this.getModConversionRecipeName(door, dye));
    }

    public static void glassDoorRecipes(RecipeOutput output, BlockFamily family) {
        Block glass = family.getBaseBlock();
        ClayworksRecipeProvider.doorBuilder((ItemLike)family.get(BlockFamily.Variant.DOOR), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{glass})).unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)glass), ClayworksRecipeProvider.has((ItemLike)glass)).save(output.withConditions(new ICondition[]{GLASS_DOORS}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)family.get(BlockFamily.Variant.TRAPDOOR)).define(Character.valueOf('#'), (ItemLike)glass).pattern("##").pattern("##").unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)glass), ClayworksRecipeProvider.has((ItemLike)glass)).save(output.withConditions(new ICondition[]{GLASS_DOORS}));
    }

    public void stainedGlassDoorRecipes(RecipeOutput output, BlockFamily family, ItemLike dye) {
        ClayworksRecipeProvider.glassDoorRecipes(output, family);
        this.stainedGlassDoorFromDye(output, (ItemLike)ClayworksBlocks.GLASS_DOOR, (ItemLike)family.get(BlockFamily.Variant.DOOR), dye, "stained_glass_door");
        this.stainedGlassDoorFromDye(output, (ItemLike)ClayworksBlocks.GLASS_TRAPDOOR, (ItemLike)family.get(BlockFamily.Variant.TRAPDOOR), dye, "stained_glass_trapdoor");
    }

    protected static void coloredConcreteFromConcreteAndDye(RecipeOutput output, ItemLike concrete, ItemLike concretePowder, ItemLike dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)concrete, (int)8).define(Character.valueOf('#'), (ItemLike)ClayworksBlocks.CONCRETE.get()).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("concrete").unlockedBy("has_concrete", ClayworksRecipeProvider.has((ItemLike)((ItemLike)ClayworksBlocks.CONCRETE.get()))).save(output.withConditions(new ICondition[]{CONCRETE_CONFIG}), Clayworks.location(BuiltInRegistries.ITEM.getKey((Object)concrete.asItem()).getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)concretePowder, (int)8).define(Character.valueOf('#'), (ItemLike)ClayworksBlocks.CONCRETE_POWDER.get()).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("concrete_powder").unlockedBy("has_concrete_powder", ClayworksRecipeProvider.has((ItemLike)((ItemLike)ClayworksBlocks.CONCRETE_POWDER.get()))).save(output.withConditions(new ICondition[]{CONCRETE_CONFIG}), Clayworks.location(BuiltInRegistries.ITEM.getKey((Object)concretePowder.asItem()).getPath()));
    }

    public static void conditionalStonecuttingRecipe(RecipeOutput output, RecipeCategory category, ICondition condition, ItemLike result, ItemLike input, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)result, (int)count).unlockedBy(ClayworksRecipeProvider.getHasName((ItemLike)input), ClayworksRecipeProvider.has((ItemLike)input)).save(output.withConditions(new ICondition[]{condition}), Clayworks.location(ClayworksRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)input) + "_stonecutting"));
    }

    public static void conditionalStonecuttingRecipe(RecipeOutput output, RecipeCategory category, ICondition condition, ItemLike result, ItemLike input) {
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(output, category, condition, result, input, 1);
    }

    public static ConfigValueCondition config(ModConfigSpec.ConfigValue<?> value, String key, boolean inverted) {
        return new ConfigValueCondition((MapCodec)ClayworksConditions.CONFIG.get(), value, key, (Map)Maps.newHashMap(), inverted);
    }

    public static ConfigValueCondition config(ModConfigSpec.ConfigValue<?> value, String key) {
        return new ConfigValueCondition((MapCodec)ClayworksConditions.CONFIG.get(), value, key, (Map)Maps.newHashMap(), false);
    }

    private static /* synthetic */ String lambda$generateConditionalRecipes$1(ItemLike block) {
        return ClayworksRecipeProvider.getHasName((ItemLike)block);
    }
}

