/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server.tags;

import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ClayworksBlockTagsProvider
extends BlockTagsProvider {
    public ClayworksBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper fileHelper) {
        super(output, lookupProvider, "clayworks", fileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object)((Block)ClayworksBlocks.CONCRETE_POWDER.get()));
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)((Block)ClayworksBlocks.POTTERY_TABLE.get()));
        this.tag(Tags.Blocks.CONCRETES).add((Object)((Block)ClayworksBlocks.CONCRETE.get()));
        this.tag(BlockTags.CONCRETE_POWDER).add((Object)((Block)ClayworksBlocks.CONCRETE_POWDER.get()));
        this.collect((TagKey<Block>)BlockTags.STAIRS, block -> block instanceof StairBlock, new Block[0]);
        this.collect((TagKey<Block>)BlockTags.SLABS, block -> block instanceof SlabBlock, new Block[0]);
        this.collect((TagKey<Block>)BlockTags.WALLS, block -> block instanceof WallBlock, new Block[0]);
        this.collect((TagKey<Block>)BlockTags.DOORS, block -> block instanceof DoorBlock, new Block[0]);
        this.collect((TagKey<Block>)BlockTags.MOB_INTERACTABLE_DOORS, block -> block instanceof DoorBlock, new Block[0]);
        this.collect((TagKey<Block>)BlockTags.TRAPDOORS, block -> block instanceof TrapDoorBlock, new Block[0]);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender mineable = this.tag(BlockTags.MINEABLE_WITH_PICKAXE);
        ((DeferredRegister.Blocks)ClayworksBlocks.BLOCKS.getDeferredRegister()).getEntries().forEach(holder -> {
            Block block = (Block)holder.get();
            if (!(block instanceof DecoratedPotBlock || block instanceof ConcretePowderBlock || block instanceof DoorBlock || block instanceof TrapDoorBlock || block == ClayworksBlocks.POTTERY_TABLE.get())) {
                mineable.add((Object)block);
            }
        });
        List<String> colors = Arrays.stream(DyeColor.values()).map(DyeColor::getName).toList();
        ((DeferredRegister.Blocks)ClayworksBlocks.BLOCKS.getDeferredRegister()).getEntries().forEach(holder -> {
            for (String color : colors) {
                if (!holder.getRegisteredName().contains(color) || !color.contains("light_") && holder.getRegisteredName().contains("light_")) continue;
                this.tag(BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color)))).add((Object)((Block)holder.get()));
                break;
            }
        });
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> collect(TagKey<Block> tag, Predicate<? super Block> predicate, Block ... exclude) {
        return this.tag(tag).add((Object[])((DeferredRegister.Blocks)ClayworksBlocks.BLOCKS.getDeferredRegister()).getEntries().stream().map(DeferredHolder::get).filter(predicate).filter(block -> !Arrays.stream(exclude).toList().contains(block)).toList().toArray(new Block[0]));
    }
}

