/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server.tags;

import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ClayworksItemTagsProvider
extends ItemTagsProvider {
    public ClayworksItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, CompletableFuture<TagsProvider.TagLookup<Block>> lookup, ExistingFileHelper fileHelper) {
        super(output, provider, lookup, "clayworks", fileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
        this.copy(BlockTags.WALLS, ItemTags.WALLS);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.copy(BlockTags.DOORS, ItemTags.DOORS);
        this.copy(BlockTags.TRAPDOORS, ItemTags.TRAPDOORS);
        this.copy(Tags.Blocks.CONCRETES, Tags.Items.CONCRETES);
        this.copy(BlockTags.CONCRETE_POWDER, Tags.Items.CONCRETE_POWDERS);
        List<String> colors = Arrays.stream(DyeColor.values()).map(DyeColor::getName).toList();
        ((DeferredRegister.Items)ClayworksBlocks.ITEMS.getDeferredRegister()).getEntries().forEach(holder -> {
            for (String color : colors) {
                if (!holder.getRegisteredName().contains(color) || !color.contains("light_") && holder.getRegisteredName().contains("light_")) continue;
                this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color)))).add((Object)((Item)holder.get()));
                break;
            }
        });
    }
}

