/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.mixin;

import com.teamabnormals.clayworks.common.DecoratedPotTrim;
import com.teamabnormals.clayworks.common.block.TrimmedPot;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.data.server.ClayworksLootTableProvider;
import com.teamabnormals.clayworks.core.registry.ClayworksDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DecoratedPotBlock.class})
public class DecoratedPotBlockMixin {
    @Inject(method={"getDrops"}, at={@At(value="HEAD")})
    private void getDrops(BlockState state, LootParams.Builder builder, CallbackInfoReturnable<List<ItemStack>> cir) {
        BlockEntity entity;
        if (((Boolean)ClayworksConfig.COMMON.decoratedPotTrims.get()).booleanValue() && (entity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof TrimmedPot) {
            TrimmedPot trimmedPot = (TrimmedPot)entity;
            if (entity.getLevel() != null) {
                Optional<Item> item = trimmedPot.getTrimItem(entity.getLevel());
                item.ifPresent(value -> builder.withDynamicDrop(ClayworksLootTableProvider.ClayworksBlockLoot.TRIM_DYNAMIC_DROP_ID, stackConsumer -> stackConsumer.accept(new ItemStack((ItemLike)value))));
            }
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BaseEntityBlock;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", shift=At.Shift.AFTER)})
    private void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> component, TooltipFlag flag, CallbackInfo ci) {
        DecoratedPotTrim trim;
        if (((Boolean)ClayworksConfig.COMMON.decoratedPotTrims.get()).booleanValue() && (trim = (DecoratedPotTrim)stack.get(ClayworksDataComponents.POT_TRIM)) != null && trim.showInTooltip()) {
            trim.addToTooltip(context, component::add, flag);
        }
    }
}

