/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.other;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ClayworksCompat {
    public static final CauldronInteraction DECORATED_POT = (state, level, pos, player, hand, stack) -> {
        Block block = Block.byItem((Item)stack.getItem());
        if (!(block instanceof DecoratedPotBlock)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            ItemStack returnStack = stack.transmuteCopy((ItemLike)Blocks.DECORATED_POT);
            player.setItemInHand(hand, returnStack);
            LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    };

    public static void register() {
        ClayworksCompat.addDecoratedPotBlockEntityTypes();
        ClayworksCompat.registerCauldronInteractions();
    }

    public static void addDecoratedPotBlockEntityTypes() {
        HashSet blocks = Sets.newHashSet();
        blocks.addAll(BlockEntityType.DECORATED_POT.validBlocks);
        blocks.addAll(((DeferredRegister.Blocks)ClayworksBlocks.BLOCKS.getDeferredRegister()).getEntries().stream().filter(registryObject -> registryObject.get() instanceof DecoratedPotBlock).map(DeferredHolder::get).toList());
        BlockEntityType.DECORATED_POT.validBlocks = ImmutableSet.copyOf((Collection)blocks);
    }

    public static void registerCauldronInteractions() {
        ((DeferredRegister.Blocks)ClayworksBlocks.BLOCKS.getDeferredRegister()).getEntries().stream().filter(block -> block.get() instanceof DecoratedPotBlock).forEach(block -> CauldronInteraction.WATER.map().put(((Block)block.get()).asItem(), DECORATED_POT));
    }
}

