/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.other;

import com.teamabnormals.clayworks.common.DecoratedPotTrim;
import com.teamabnormals.clayworks.common.DecoratedPotTrimPattern;
import com.teamabnormals.clayworks.common.block.TrimmedPot;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="clayworks")
public class ClayworksEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (state.getBlock() instanceof DecoratedPotBlock && player.isSecondaryUseActive()) {
            TrimmedPot trimmedPot;
            Optional<Item> item;
            BlockEntity blockEntity;
            if (stack.is(ItemTags.TRIM_MATERIALS) && ((Boolean)ClayworksConfig.COMMON.decoratedPotTrims.get()).booleanValue()) {
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof TrimmedPot) {
                    TrimmedPot trimmedPot2 = (TrimmedPot)blockEntity2;
                    RegistryAccess registryAccess = level.registryAccess();
                    Optional<Item> item2 = trimmedPot2.getTrimItem(level);
                    Optional material = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)stack);
                    Optional pattern = level.registryAccess().registryOrThrow(ClayworksRegistries.DECORATED_POT_TRIM_PATTERN).getHolder(DecoratedPotTrimPattern.BASE);
                    if (item2.isEmpty() && material.isPresent() && pattern.isPresent()) {
                        trimmedPot2.setTrim(new DecoratedPotTrim((Holder<TrimMaterial>)((Holder)material.get()), (Holder<DecoratedPotTrimPattern>)((Holder)pattern.get()), true));
                        level.playSound(null, pos, SoundEvents.COPPER_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!player.isCreative()) {
                            stack.shrink(1);
                        }
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                    }
                }
            } else if (stack.is(ItemTags.PICKAXES) && ((Boolean)ClayworksConfig.COMMON.decoratedPotTrims.get()).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof TrimmedPot && (item = (trimmedPot = (TrimmedPot)blockEntity).getTrimItem(level)).isPresent()) {
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.COPPER_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)item.get()));
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                trimmedPot.setTrim(null);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                event.setCanceled(true);
            }
        }
    }
}

