/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.ability.command;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.command.AbilitySuggestions;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.ability.type.DummyAbility;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public final class AbilityCommand {
    public static final SimpleCommandExceptionType UNKNOWN_CATEGORY = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.neptune.ability.unknown_category"));
    public static final SimpleCommandExceptionType UNKNOWN_ABILITY = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.neptune.ability.unknown_ability"));

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"ability").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"enable").then(Commands.argument((String)"category", (ArgumentType)ResourceLocationArgument.id()).suggests(AbilitySuggestions.ABILITY_CATEGORY).executes(ctx -> AbilityCommand.modifyCategory((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.literal((String)"disable").then(Commands.argument((String)"category", (ArgumentType)ResourceLocationArgument.id()).suggests(AbilitySuggestions.ABILITY_CATEGORY).executes(ctx -> AbilityCommand.modifyCategory((CommandContext<CommandSourceStack>)ctx, false))))).then(Commands.literal((String)"grant").then(Commands.argument((String)"category", (ArgumentType)ResourceLocationArgument.id()).suggests(AbilitySuggestions.ABILITY_CATEGORY).then(Commands.argument((String)"ability", (ArgumentType)ResourceLocationArgument.id()).suggests(AbilitySuggestions.ABILITY_TYPE).executes(ctx -> AbilityCommand.grantAbility((CommandContext<CommandSourceStack>)ctx, true)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"category", (ArgumentType)ResourceLocationArgument.id()).suggests(AbilitySuggestions.ABILITY_TYPE).executes(ctx -> AbilityCommand.grantAbility((CommandContext<CommandSourceStack>)ctx, false))))));
    }

    private static int modifyCategory(CommandContext<CommandSourceStack> context, boolean enable) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"targets");
        Optional<AbilityCategory> optional = AbilityCategory.byId(ResourceLocationArgument.getId(context, (String)"category"));
        if (optional.isEmpty()) {
            throw UNKNOWN_CATEGORY.create();
        }
        for (ServerPlayer player : players) {
            AbilityData.get((LivingEntity)player).setEnabled((LivingEntity)player, enable, optional.get());
        }
        return players.size();
    }

    private static int grantAbility(CommandContext<CommandSourceStack> context, boolean grant) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"targets");
        Optional<AbilityCategory> optional = AbilityCategory.byId(ResourceLocationArgument.getId(context, (String)"category"));
        if (optional.isEmpty()) {
            throw UNKNOWN_CATEGORY.create();
        }
        AbilityCategory category = optional.get();
        Ability<?> ability = category.getAbilityById(ResourceLocationArgument.getId(context, (String)"ability"));
        if (ability == DummyAbility.EMPTY) {
            throw UNKNOWN_ABILITY.create();
        }
        for (ServerPlayer player : players) {
            AbilityData.get((LivingEntity)player).get(category).setActiveAbility((LivingEntity)player, ability);
        }
        return players.size();
    }

    private static int removeAbility(CommandContext<CommandSourceStack> context, boolean grant) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"targets");
        Optional<AbilityCategory> optional = AbilityCategory.byId(ResourceLocationArgument.getId(context, (String)"category"));
        if (optional.isEmpty()) {
            throw UNKNOWN_CATEGORY.create();
        }
        AbilityCategory category = optional.get();
        for (ServerPlayer player : players) {
            AbilityData.get((LivingEntity)player).get(category).removeAbility((LivingEntity)player);
        }
        return players.size();
    }
}

