/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.ability.type;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.AbilityDataHolder;
import com.iafenvoy.neptune.ability.type.DelayAbility;
import com.iafenvoy.neptune.ability.type.DummyAbility;
import com.iafenvoy.neptune.ability.type.InstantAbility;
import com.iafenvoy.neptune.ability.type.IntervalAbility;
import com.iafenvoy.neptune.ability.type.PersistAbility;
import com.iafenvoy.neptune.network.payload.AbilityStateChangePayload;
import com.iafenvoy.neptune.object.SoundUtil;
import com.iafenvoy.neptune.registry.NeptuneRegistries;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract sealed class Ability<T extends Ability<T>>
permits DelayAbility, DummyAbility, InstantAbility, IntervalAbility, PersistAbility {
    private final AbilityCategory category;
    private Consumer<Ability<?>> init = self -> {};
    private ToIntFunction<AbilityDataHolder> primaryCooldownSupplier = data -> 0;
    private ToIntFunction<AbilityDataHolder> secondaryCooldownSupplier = data -> 0;
    private ToDoubleFunction<AbilityDataHolder> exhaustion = data -> 0.0;
    protected Consumer<AbilityDataHolder> apply = holder -> {};
    @Nullable
    protected Supplier<SoundEvent> applySound;
    private boolean experimental = false;

    public Ability(AbilityCategory category) {
        this.category = category;
        if (category != null) {
            category.registerAbility(this);
        }
    }

    public ResourceLocation getId() {
        return NeptuneRegistries.ABILITY.getKey((Object)this);
    }

    public AbilityCategory getCategory() {
        return this.category;
    }

    public ResourceLocation getIconTexture() {
        if (this.isEmpty()) {
            return ResourceLocation.tryBuild((String)"minecraft", (String)"textures/item/barrier.png");
        }
        return ResourceLocation.tryBuild((String)this.getId().getNamespace(), (String)("textures/ability/" + this.getId().getPath() + ".png"));
    }

    public T onInit(Consumer<Ability<?>> init) {
        this.init = init;
        return this.get();
    }

    public void init() {
        this.init.accept(this);
    }

    public T onApply(Consumer<AbilityDataHolder> apply) {
        this.apply = apply;
        return this.get();
    }

    public T setApplySound(Supplier<SoundEvent> applySound) {
        this.applySound = applySound;
        return this.get();
    }

    public int getPrimaryCooldown(AbilityData.SingleAbilityData data, LivingEntity living) {
        return this.getPrimaryCooldown(new AbilityDataHolder(data, living));
    }

    public int getPrimaryCooldown(AbilityDataHolder data) {
        return this.primaryCooldownSupplier.applyAsInt(data);
    }

    public T setPrimaryCooldown(int ticks) {
        return this.setPrimaryCooldown(data -> ticks);
    }

    public T setPrimaryCooldown(ToIntFunction<AbilityDataHolder> supplier) {
        this.primaryCooldownSupplier = supplier;
        return this.get();
    }

    public int getSecondaryCooldown(AbilityData.SingleAbilityData data, LivingEntity living) {
        return this.getSecondaryCooldown(new AbilityDataHolder(data, living));
    }

    public int getSecondaryCooldown(AbilityDataHolder data) {
        return this.secondaryCooldownSupplier.applyAsInt(data);
    }

    public T setSecondaryCooldown(int ticks) {
        return this.setSecondaryCooldown(data -> ticks);
    }

    public T setSecondaryCooldown(ToIntFunction<AbilityDataHolder> supplier) {
        this.secondaryCooldownSupplier = supplier;
        return this.get();
    }

    public double getExhaustion(AbilityData.SingleAbilityData data, LivingEntity living) {
        return this.getExhaustion(new AbilityDataHolder(data, living));
    }

    public double getExhaustion(AbilityDataHolder data) {
        return this.exhaustion.applyAsDouble(data);
    }

    public T setExhaustion(float exhaustion) {
        return this.setExhaustion(data -> exhaustion);
    }

    public T setExhaustion(ToDoubleFunction<AbilityDataHolder> exhaustion) {
        this.exhaustion = exhaustion;
        return this.get();
    }

    public boolean isPersist() {
        return this.getType() == AbilityType.PERSIST;
    }

    public boolean apply(AbilityData.SingleAbilityData data, LivingEntity living) {
        if (!data.allowEnable()) {
            return false;
        }
        boolean success = this.applyInternal(new AbilityDataHolder(data, living));
        if (success) {
            this.sendApplyMessage(living, true);
        }
        return success;
    }

    public void unapply(AbilityData.SingleAbilityData data, LivingEntity living) {
        this.sendApplyMessage(living, false);
    }

    public void sendApplyMessage(LivingEntity living, boolean enable) {
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new AbilityStateChangePayload(living.getUUID(), this.getId(), enable), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isEmpty() {
        return this == DummyAbility.EMPTY || this.getId() == null || this.getId().getPath().isEmpty();
    }

    public String getTranslateKey() {
        return this.getId().toLanguageKey("ability.neptune");
    }

    protected abstract boolean applyInternal(AbilityDataHolder var1);

    protected abstract AbilityType getType();

    protected abstract T get();

    protected static void playSound(AbilityDataHolder holder, @Nullable Supplier<SoundEvent> sound) {
        if (sound != null) {
            SoundUtil.playSound(holder.getWorld(), holder.getEntity().getX(), holder.getEntity().getY(), holder.getEntity().getZ(), sound.get().getLocation(), 0.5f, 1.0f);
        }
    }

    public T experimental() {
        this.experimental = true;
        return this.get();
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    protected static enum AbilityType {
        INSTANT,
        INTERVAL,
        PERSIST,
        DELAY,
        DUMMY;

    }
}

