/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.ability.type;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.AbilityDataHolder;
import com.iafenvoy.neptune.ability.type.Ability;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class PersistAbility
extends Ability<PersistAbility> {
    private Consumer<AbilityDataHolder> unapply = data -> {};
    private Consumer<AbilityDataHolder> tick = data -> {};
    @Nullable
    private Supplier<SoundEvent> unapplySound;

    public PersistAbility(AbilityCategory category) {
        super(category);
    }

    public PersistAbility setUnapplySound(Supplier<SoundEvent> unapplySound) {
        this.unapplySound = unapplySound;
        return this;
    }

    public PersistAbility onUnapply(Consumer<AbilityDataHolder> unapply) {
        this.unapply = unapply;
        return this;
    }

    public PersistAbility onTick(Consumer<AbilityDataHolder> tick) {
        this.tick = tick;
        return this;
    }

    @Override
    public void unapply(AbilityData.SingleAbilityData data, LivingEntity living) {
        AbilityDataHolder holder = new AbilityDataHolder(data, living);
        PersistAbility.playSound(holder, this.unapplySound);
        this.unapply.accept(holder);
        holder.cooldown();
        super.unapply(data, living);
    }

    public boolean tick(AbilityData.SingleAbilityData data, LivingEntity living) {
        AbilityDataHolder holder = new AbilityDataHolder(data, living);
        this.tick.accept(holder);
        if (!holder.isCancelled() && living instanceof Player) {
            Player player = (Player)living;
            player.causeFoodExhaustion((float)(this.getExhaustion(data, living) / 20.0));
        }
        return holder.isCancelled();
    }

    @Override
    protected boolean applyInternal(AbilityDataHolder holder) {
        PersistAbility.playSound(holder, this.applySound);
        this.apply.accept(holder);
        return true;
    }

    @Override
    protected Ability.AbilityType getType() {
        return Ability.AbilityType.PERSIST;
    }

    @Override
    protected PersistAbility get() {
        return this;
    }
}

