/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.compat;

import com.iafenvoy.neptune.recipe.WeaponDeskRecipe;
import com.iafenvoy.neptune.registry.NeptuneBlocks;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@EmiEntrypoint
public class WeaponDeskRecipePlugin
implements EmiPlugin {
    private static final EmiTexture TEXTURE = new EmiTexture(ResourceLocation.tryBuild((String)"neptune", (String)"textures/gui/gui_boss_spawn_recipe.png"), 0, 0, 140, 44);
    private static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)NeptuneBlocks.WEAPON_DESK.get()));
    private static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(WeaponDeskRecipe.ID, (EmiRenderable)WORKSTATION, (EmiRenderable)TEXTURE);

    public void register(EmiRegistry registry) {
        registry.addCategory(CATEGORY);
        registry.addWorkstation(CATEGORY, (EmiIngredient)WORKSTATION);
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)WeaponDeskRecipe.Type.INSTANCE)) {
            registry.addRecipe((EmiRecipe)new EmiWeaponDeskRecipe((RecipeHolder<WeaponDeskRecipe>)recipe));
        }
    }

    private record EmiWeaponDeskRecipe(RecipeHolder<WeaponDeskRecipe> holder) implements EmiRecipe
    {
        public EmiRecipeCategory getCategory() {
            return CATEGORY;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.holder.id();
        }

        public List<EmiIngredient> getInputs() {
            return List.of(EmiIngredient.of((Ingredient)((WeaponDeskRecipe)this.holder.value()).material().ingredient(), (long)((WeaponDeskRecipe)this.holder.value()).material().count()), EmiIngredient.of((Ingredient)((WeaponDeskRecipe)this.holder.value()).stick().ingredient(), (long)((WeaponDeskRecipe)this.holder.value()).stick().count()));
        }

        public List<EmiStack> getOutputs() {
            return List.of(EmiStack.of((ItemStack)((WeaponDeskRecipe)this.holder.value()).result().copy()));
        }

        public int getDisplayWidth() {
            return 96;
        }

        public int getDisplayHeight() {
            return 18;
        }

        public void addWidgets(WidgetHolder widgets) {
            List<EmiIngredient> ingredients = this.getInputs();
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 46, 1);
            widgets.addSlot(ingredients.get(0), 0, 0);
            widgets.addSlot(ingredients.get(1), 20, 0);
            widgets.addSlot((EmiIngredient)this.getOutputs().getFirst(), 78, 0).recipeContext((EmiRecipe)this);
        }
    }
}

