/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.mixin;

import com.iafenvoy.neptune.compat.CuriosHelper;
import com.iafenvoy.neptune.render.SkullRenderRegistry;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player {
    public AbstractClientPlayerMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"getSkin"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCustomSkin(CallbackInfoReturnable<PlayerSkin> cir) {
        Optional<SkullRenderRegistry.SkinInfo> optional = this.neptune$findTexture(this.getItemBySlot(EquipmentSlot.HEAD));
        if (optional.isPresent()) {
            cir.setReturnValue((Object)optional.get().copyOrCreate((PlayerSkin)cir.getReturnValue()));
        } else {
            optional = this.neptune$findTexture(CuriosHelper.getEquipped((LivingEntity)this).get((Object)CuriosHelper.Place.HAT));
            optional.ifPresent(x -> cir.setReturnValue((Object)x.copyOrCreate((PlayerSkin)cir.getReturnValue())));
        }
    }

    @Unique
    private Optional<SkullRenderRegistry.SkinInfo> neptune$findTexture(ItemStack head) {
        PlayerHeadItem skullItem;
        Item item = head.getItem();
        if (item instanceof SkullRenderRegistry.SkullTextureProvider) {
            SkullRenderRegistry.SkullTextureProvider provider = (SkullRenderRegistry.SkullTextureProvider)item;
            return provider.getTexture(head);
        }
        Item item2 = head.getItem();
        if (item2 instanceof PlayerHeadItem && (item2 = (skullItem = (PlayerHeadItem)item2).getBlock()) instanceof AbstractSkullBlock) {
            ResolvableProfile profile;
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item2;
            SkullRenderRegistry.SkinInfo texture = SkullRenderRegistry.getTextureFromType(skullBlock.getType());
            if (texture != null) {
                return Optional.of(texture);
            }
            if (skullBlock.getType() == SkullBlock.Types.PLAYER && (profile = (ResolvableProfile)head.get(DataComponents.PROFILE)) != null) {
                SkinManager manager = Minecraft.getInstance().getSkinManager();
                return Optional.of(new SkullRenderRegistry.SkinInfo(manager.getInsecureSkin(profile.gameProfile())));
            }
        }
        return Optional.empty();
    }
}

