/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.object;

import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerUtil {
    @SafeVarargs
    public static Function<HolderGetter<BannerPattern>, ItemStack> lazy(String translateKey, Item baseItem, Pair<ResourceKey<BannerPattern>, DyeColor> ... patterns) {
        return getter -> BannerUtil.create(translateKey, baseItem, (HolderGetter<BannerPattern>)getter, patterns);
    }

    @SafeVarargs
    public static ItemStack create(String translateKey, Item baseItem, HolderGetter<BannerPattern> getter, Pair<ResourceKey<BannerPattern>, DyeColor> ... patterns) {
        BannerPatternLayers.Builder builder = new BannerPatternLayers.Builder();
        for (Pair<ResourceKey<BannerPattern>, DyeColor> pattern : patterns) {
            builder.add((Holder)getter.getOrThrow((ResourceKey)pattern.getFirst()), (DyeColor)pattern.getSecond());
        }
        ItemStack stack = new ItemStack((ItemLike)baseItem);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)translateKey).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false))));
        stack.set(DataComponents.BANNER_PATTERNS, (Object)builder.build());
        return stack;
    }
}

