/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.object;

import com.iafenvoy.neptune.object.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootUtil {
    public static void loot(Level world, double x, double y, double z, ResourceLocation lootTable) {
        LootUtil.loot(world, x, y, z, lootTable, LootContextParamSets.EMPTY);
    }

    public static void loot(Level world, double x, double y, double z, ResourceLocation lootTable, LootContextParamSet contextType) {
        LootUtil.loot(world, BlockPos.containing((double)x, (double)y, (double)z), lootTable, contextType);
    }

    public static void loot(Level world, BlockPos pos, ResourceLocation lootTable) {
        LootUtil.loot(world, pos, lootTable, LootContextParamSets.EMPTY);
    }

    public static void loot(Level world, BlockPos pos, ResourceLocation lootTable, LootContextParamSet contextType) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            LootTable l = (LootTable)world.registryAccess().registryOrThrow(Registries.LOOT_TABLE).get(lootTable);
            if (l != null) {
                for (ItemStack itemstackiterator : l.getRandomItems(new LootParams.Builder(serverWorld).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)world.getBlockState(pos)).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)world.getBlockEntity(pos)).create(contextType))) {
                    EntityUtil.item(serverWorld, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstackiterator, 0);
                }
            }
        }
    }
}

