/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.object.item;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RestrictedItem
extends Item {
    private final RestrictPredicate predicate;

    public RestrictedItem(Item.Properties settings, RestrictPredicate predicate) {
        super(settings);
        this.predicate = predicate;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!stack.is((Item)this)) {
            return;
        }
        if (this.predicate.canExist(stack, world, entity, slot, selected)) {
            return;
        }
        if (this.isDamageable(stack)) {
            stack.setDamageValue(this.getMaxDamage(stack) + 1);
        }
        stack.setCount(0);
    }

    @FunctionalInterface
    public static interface RestrictPredicate {
        public boolean canExist(ItemStack var1, Level var2, Entity var3, int var4, boolean var5);
    }
}

