/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.render;

import com.iafenvoy.neptune.render.Stage;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntityRendererBase<T extends Mob>
extends HumanoidMobRenderer<T, HumanoidModel<T>> {
    private final Stage.StagedEntityTextureProvider textureId;

    public EntityRendererBase(EntityRendererProvider.Context context, Stage.StagedEntityTextureProvider textureId, final @Nullable ResourceLocation eyeTextureId) {
        super(context, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.textureId = textureId;
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        if (eyeTextureId != null) {
            this.addLayer((RenderLayer)new EyesLayer<T, HumanoidModel<T>>(this, (RenderLayerParent)this){

                @NotNull
                public RenderType renderType() {
                    return RenderType.eyes((ResourceLocation)eyeTextureId);
                }
            });
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        if (entity instanceof Stage.StagedEntity) {
            Stage.StagedEntity stagedEntity = (Stage.StagedEntity)entity;
            return this.textureId.getTexture(stagedEntity.getStage());
        }
        return this.textureId.getTexture();
    }
}

