/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.trail.storage;

import com.iafenvoy.neptune.network.payload.TrailActionPayload;
import com.iafenvoy.neptune.trail.TrailRegistry;
import com.iafenvoy.neptune.trail.storage.TrailStorage;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public enum ServerTrailStorage implements TrailStorage
{
    INSTANCE;

    private static final Map<Entity, Set<ResourceLocation>> PROVIDERS;

    @Override
    public void addTrail(Entity entity, ResourceLocation id) {
        if (!PROVIDERS.containsKey(entity)) {
            PROVIDERS.put(entity, new HashSet());
        }
        PROVIDERS.get(entity).add(id);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new TrailActionPayload(ServerTrailStorage.encode(Map.of(entity, Set.of(id))), TrailActionPayload.ActionType.ADD), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void removeTrail(Entity entity, ResourceLocation id) {
        if (!PROVIDERS.containsKey(entity)) {
            PROVIDERS.put(entity, new HashSet());
        }
        PROVIDERS.get(entity).remove(id);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new TrailActionPayload(ServerTrailStorage.encode(Map.of(entity, Set.of(id))), TrailActionPayload.ActionType.REMOVE), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new TrailActionPayload(ServerTrailStorage.encode(PROVIDERS), TrailActionPayload.ActionType.SYNC), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void tick(ServerTickEvent.Post event) {
        LinkedHashMap<Entity, Set<ResourceLocation>> removed = new LinkedHashMap<Entity, Set<ResourceLocation>>();
        for (Map.Entry<Entity, Set<ResourceLocation>> entry : PROVIDERS.entrySet()) {
            if (entry.getKey().isRemoved()) {
                removed.put(entry.getKey(), entry.getValue());
                continue;
            }
            Set shouldRemove = entry.getValue().stream().filter(x -> TrailRegistry.shouldRemove((Entity)entry.getKey(), x)).collect(Collectors.toSet());
            if (shouldRemove.isEmpty()) continue;
            removed.put(entry.getKey(), shouldRemove);
        }
        if (!removed.isEmpty()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new TrailActionPayload(ServerTrailStorage.encode(removed), TrailActionPayload.ActionType.REMOVE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public int getEntityLight(Entity entity, float tickDelta) {
        return 0xF000F0;
    }

    private static Map<Integer, List<ResourceLocation>> encode(Map<Entity, Set<ResourceLocation>> data) {
        LinkedHashMap<Integer, List<ResourceLocation>> map = new LinkedHashMap<Integer, List<ResourceLocation>>();
        for (Map.Entry<Entity, Set<ResourceLocation>> entry : data.entrySet()) {
            map.put(entry.getKey().getId(), List.copyOf((Collection)entry.getValue()));
        }
        return map;
    }

    static {
        PROVIDERS = new LinkedHashMap<Entity, Set<ResourceLocation>>();
    }
}

