/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.ability;

import com.iafenvoy.neptune.ability.AbilityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;

public class AbilityDataHolder {
    public static final float DAMAGE_MUL = 1.5f;
    private final AbilityData.SingleAbilityData data;
    private final LivingEntity living;
    private boolean cancelled = false;

    public AbilityDataHolder(AbilityData.SingleAbilityData data, LivingEntity living) {
        this.data = data;
        this.living = living;
    }

    public AbilityData.SingleAbilityData getData() {
        return this.data;
    }

    public LivingEntity getEntity() {
        return this.living;
    }

    public Level getWorld() {
        return this.living.getCommandSenderWorld();
    }

    public boolean usingWeapon() {
        return this.getEntity().getMainHandItem().getItem() instanceof SwordItem;
    }

    public void processProjectile(AbstractArrow projectile) {
        projectile.setOwner((Entity)this.living);
        projectile.pickup = AbstractArrow.Pickup.DISALLOWED;
        projectile.moveTo(this.living.getX(), this.living.getY() + 1.0, this.living.getZ(), 0.0f, 0.0f);
        if (this.usingWeapon()) {
            projectile.setCritArrow(true);
        }
    }

    public float processDamage(float damage) {
        return damage * (this.usingWeapon() ? 1.5f : 1.0f);
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cooldown() {
        this.data.cooldown(this.living);
    }
}

