/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.ability.type;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityDataHolder;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.util.Timeout;
import java.util.function.ToIntFunction;

public final class IntervalAbility
extends Ability<IntervalAbility> {
    private ToIntFunction<AbilityDataHolder> times = data -> 0;
    private ToIntFunction<AbilityDataHolder> interval = data -> 0;

    public IntervalAbility(AbilityCategory category) {
        super(category);
    }

    public IntervalAbility setInterval(int interval) {
        return this.setInterval(data -> interval);
    }

    public IntervalAbility setInterval(ToIntFunction<AbilityDataHolder> interval) {
        this.interval = interval;
        return this;
    }

    public IntervalAbility setTimes(int times) {
        return this.setTimes(data -> times);
    }

    public IntervalAbility setTimes(ToIntFunction<AbilityDataHolder> times) {
        this.times = times;
        return this;
    }

    @Override
    protected boolean applyInternal(AbilityDataHolder holder) {
        IntervalAbility.playSound(holder, this.applySound);
        this.apply.accept(holder);
        if (holder.isCancelled()) {
            return false;
        }
        holder.cooldown();
        Timeout.create(this.interval.applyAsInt(holder), this.times.applyAsInt(holder), () -> this.apply.accept(holder));
        return true;
    }

    @Override
    protected Ability.AbilityType getType() {
        return Ability.AbilityType.INTERVAL;
    }

    @Override
    public int getPrimaryCooldown(AbilityDataHolder data) {
        return super.getPrimaryCooldown(data) + this.interval.applyAsInt(data) * this.times.applyAsInt(data);
    }

    @Override
    protected IntervalAbility get() {
        return this;
    }
}

