/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.recipe;

import com.iafenvoy.neptune.Neptune;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record WeaponDeskRecipe(IngredientGroup material, IngredientGroup stick, ItemStack result) implements Recipe<RecipeInput>
{
    public static final ResourceLocation ID = Neptune.id("weapon_desk");

    public boolean matches(RecipeInput inventory, @NotNull Level world) {
        if (inventory.size() < 2) {
            return false;
        }
        ItemStack materialStack = inventory.getItem(0);
        ItemStack stickStack = inventory.getItem(1);
        return this.material.ingredient.test(materialStack) && materialStack.getCount() >= this.material.count && this.stick.ingredient.test(stickStack) && stickStack.getCount() >= this.material.count;
    }

    @NotNull
    public ItemStack assemble(RecipeInput inventory, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryManager) {
        if (inventory.size() < 2) {
            return ItemStack.EMPTY;
        }
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryManager) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public record IngredientGroup(Ingredient ingredient, int count) {
        public static final Codec<IngredientGroup> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.MAP_CODEC_NONEMPTY.forGetter(IngredientGroup::ingredient), (App)Codec.INT.fieldOf("count").forGetter(IngredientGroup::count)).apply((Applicative)i, IngredientGroup::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, IngredientGroup> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IngredientGroup::ingredient, (StreamCodec)ByteBufCodecs.INT, IngredientGroup::count, IngredientGroup::new);
    }

    public static enum Serializer implements RecipeSerializer<WeaponDeskRecipe>
    {
        INSTANCE;

        public static final MapCodec<WeaponDeskRecipe> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, WeaponDeskRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<WeaponDeskRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WeaponDeskRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        static {
            CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)IngredientGroup.CODEC.fieldOf("material").forGetter(WeaponDeskRecipe::material), (App)IngredientGroup.CODEC.fieldOf("stick").forGetter(WeaponDeskRecipe::stick), (App)ItemStack.CODEC.fieldOf("result").forGetter(WeaponDeskRecipe::result)).apply((Applicative)i, WeaponDeskRecipe::new));
            STREAM_CODEC = StreamCodec.composite(IngredientGroup.STREAM_CODEC, WeaponDeskRecipe::material, IngredientGroup.STREAM_CODEC, WeaponDeskRecipe::stick, (StreamCodec)ItemStack.STREAM_CODEC, WeaponDeskRecipe::result, WeaponDeskRecipe::new);
        }
    }

    public static enum Type implements RecipeType<WeaponDeskRecipe>
    {
        INSTANCE;


        public String toString() {
            return ID.toString();
        }
    }
}

