/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.registry;

import com.iafenvoy.neptune.ability.AbilityData;
import net.minecraft.core.Registry;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public final class NeptuneAttachments {
    public static final DeferredRegister<AttachmentType<?>> REGISTRY = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"neptune");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<AbilityData>> ABILITY = REGISTRY.register("ability", () -> AttachmentType.builder(AbilityData::new).serialize(AbilityData.CODEC).sync(ByteBufCodecs.fromCodecWithRegistries(AbilityData.CODEC)).copyOnDeath().build());

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AbilityData data = (AbilityData)living.getData(ABILITY);
            data.tick(living);
            if (data.isDirty()) {
                living.syncData(ABILITY);
            }
        }
    }
}

