/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.render;

import com.iafenvoy.neptune.render.EntityTextureProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CommonPlayerLikeEntityRenderer<T extends Mob>
extends HumanoidMobRenderer<T, PlayerModel<T>> {
    public CommonPlayerLikeEntityRenderer(EntityRendererProvider.Context ctx) {
        this(ctx, false);
    }

    public CommonPlayerLikeEntityRenderer(EntityRendererProvider.Context ctx, boolean slim) {
        super(ctx, (HumanoidModel)new PlayerModel(ctx.bakeLayer(ModelLayers.PLAYER), slim), 0.5f);
    }

    protected void scale(T entity, @NotNull PoseStack matrices, float amount) {
        float f = entity.getScale();
        if (f != 1.0f) {
            matrices.scale(f, f, f);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return ((EntityTextureProvider)entity).getTextureId();
    }
}

