/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.render;

import com.iafenvoy.neptune.render.EntityRendererBase;
import java.util.HashMap;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public enum Stage {
    Zero(0),
    First(1),
    Second(2),
    Third(3),
    Forth(4),
    Fifth(5),
    Sixth(6);

    private final int index;

    private Stage(int index) {
        this.index = index;
    }

    public static Stage getByIndex(int index) {
        for (Stage s : Stage.values()) {
            if (s.index != index) continue;
            return s;
        }
        return Zero;
    }

    public static StagedEntityTextureProvider ofProvider(String modId, String ... textures) {
        return new StagedEntityTextureProvider(modId, textures);
    }

    public int getIndex() {
        return this.index;
    }

    public static class StagedEntityTextureProvider {
        private final String modId;
        private final HashMap<Stage, String> textureIds = new HashMap();
        private String eyeTextureId = null;

        public StagedEntityTextureProvider(String modId, String ... textures) {
            this.modId = modId;
            Stage[] stages = Stage.values();
            for (int i = 0; i < stages.length - 1 && i < textures.length; ++i) {
                this.textureIds.put(stages[i + 1], textures[i]);
            }
        }

        public StagedEntityTextureProvider setEyeTextureId(String eyeTextureId) {
            this.eyeTextureId = eyeTextureId;
            return this;
        }

        public ResourceLocation getTexture() {
            return this.getTexture(First);
        }

        public ResourceLocation getTexture(Stage stage) {
            return StagedEntityTextureProvider.buildTexture(this.modId, this.getTextureId(stage));
        }

        private String getTextureId(Stage stage) {
            if (this.textureIds.containsKey((Object)stage)) {
                return this.textureIds.get((Object)stage);
            }
            if (this.textureIds.isEmpty()) {
                return "";
            }
            return this.textureIds.get((Object)First);
        }

        public <T extends Mob> EntityRendererBase<T> createRenderer(EntityRendererProvider.Context context) {
            if (this.eyeTextureId == null) {
                return new EntityRendererBase(context, this, null);
            }
            return new EntityRendererBase(context, this, ResourceLocation.tryBuild((String)this.modId, (String)this.eyeTextureId));
        }

        private static ResourceLocation buildTexture(String modId, String id) {
            return ResourceLocation.tryBuild((String)modId, (String)("textures/entities/" + id + ".png"));
        }
    }

    public static interface StagedEntity {
        public Stage getStage();
    }
}

