/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.render.accessory;

import com.iafenvoy.neptune.compat.CuriosHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BeltToolRenderer
extends ItemInHandLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ItemInHandRenderer heldItemRenderer;

    public BeltToolRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context, ItemInHandRenderer heldItemRenderer) {
        super(context, heldItemRenderer);
        this.heldItemRenderer = heldItemRenderer;
    }

    public void render(@NotNull PoseStack matrices, @NotNull MultiBufferSource provider, int i, @NotNull AbstractClientPlayer entity, float f, float g, float h, float j, float k, float l) {
        Map<CuriosHelper.Place, ItemStack> stacks = CuriosHelper.getEquipped((LivingEntity)entity);
        if (stacks.containsKey((Object)CuriosHelper.Place.BELT_LEFT)) {
            this.renderItem(stacks.get((Object)CuriosHelper.Place.BELT_LEFT), matrices, provider, i, entity, true);
        }
        if (stacks.containsKey((Object)CuriosHelper.Place.BELT_RIGHT)) {
            this.renderItem(stacks.get((Object)CuriosHelper.Place.BELT_RIGHT), matrices, provider, i, entity, false);
        }
    }

    private void renderItem(ItemStack stack, PoseStack matrices, MultiBufferSource provider, int i, AbstractClientPlayer entity, boolean left) {
        matrices.pushPose();
        ModelPart modelPart = ((PlayerModel)this.getParentModel()).body;
        modelPart.translateAndRotate(matrices);
        double switchBeltSide = 0.29;
        matrices.translate(switchBeltSide * (double)(left ? 1 : -1), 0.5, 0.05);
        matrices.mulPose(Axis.YP.rotationDegrees(-90.0f));
        matrices.scale(1.5f, 1.5f, 1.5f);
        CuriosHelper.BeltHolder holder = CuriosHelper.getBelt(stack.getItem());
        if (holder != null) {
            holder.transformer().accept(matrices, left);
        }
        this.heldItemRenderer.renderItem((LivingEntity)entity, stack, ItemDisplayContext.GROUND, left, matrices, provider, i);
        matrices.popPose();
    }
}

