/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.render.feature;

import com.iafenvoy.neptune.render.EntityWithMarkerTextureProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MarkerFeatureRenderer<T extends Mob>
extends RenderLayer<T, PlayerModel<T>> {
    private final boolean glint;

    public MarkerFeatureRenderer(RenderLayerParent<T, PlayerModel<T>> context, boolean glint) {
        super(context);
        this.glint = glint;
    }

    public void render(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        Optional<ResourceLocation> marker = ((EntityWithMarkerTextureProvider)entity).getMarkerTextureId();
        HumanoidModel model = (HumanoidModel)this.getParentModel();
        marker.ifPresent(id -> model.renderToBuffer(matrices, vertexConsumers.getBuffer(this.glint ? RenderType.entityTranslucentEmissive((ResourceLocation)id) : RenderType.entityCutout((ResourceLocation)id)), light, OverlayTexture.NO_OVERLAY, -1));
    }
}

