/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.screen;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.AbilityKeybindings;
import com.iafenvoy.neptune.registry.NeptuneRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbilityHudRenderer {
    private static final ResourceLocation HOTBAR_SELECTION_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_selection");
    private static final ResourceLocation HOTBAR_OFFHAND_LEFT_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_offhand_left");
    private static final ResourceLocation HOTBAR_OFFHAND_RIGHT_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_offhand_right");
    private static final Font TEXT_RENDERER = Minecraft.getInstance().font;

    public static void render(Minecraft client, GuiGraphics context) {
        if (client.player == null || client.player.isSpectator()) {
            return;
        }
        AbilityData data = AbilityData.get((LivingEntity)client.player);
        int width = context.guiWidth();
        int height = context.guiHeight();
        int x = width / 2 + 120;
        int y = height - 24;
        int i = 0;
        for (AbilityCategory category : NeptuneRegistries.ABILITY_CATEGORY) {
            if (!category.shouldDisplay() || !data.isEnabled(category)) continue;
            AbilityHudRenderer.renderOne(x + i * 21, y, context, data.get(category));
            ++i;
        }
    }

    private static void renderOne(int x, int y, GuiGraphics context, AbilityData.SingleAbilityData data) {
        context.pose().pushPose();
        AbilityKeybindings.KeyBindingHolder binding = AbilityKeybindings.get(data.getType());
        context.blitSprite(HOTBAR_OFFHAND_LEFT_SPRITE, x, y, 29, 24);
        String text = switch (data.getState()) {
            default -> throw new MatchException(null, null);
            case AbilityData.State.ALLOW -> "\u00a7aR";
            case AbilityData.State.RECOVER -> String.format("\u00a7e%.1fs", 1.0 * (double)data.getSecondaryCooldown() / 20.0);
            case AbilityData.State.DENY -> String.format("\u00a7c%.1fs", 1.0 * (double)data.getPrimaryCooldown() / 20.0);
        };
        context.drawString(TEXT_RENDERER, text, x + 2, y - 10, -1);
        context.pose().translate(0.0f, 0.0f, 1.0f);
        if (binding.isPressed() || data.isEnabled()) {
            context.blitSprite(HOTBAR_SELECTION_SPRITE, x - 1, y, 24, 23);
        }
        context.pose().translate(0.0f, 0.0f, 2.0f);
        context.blit(data.getActiveAbility().getIconTexture(), x + 3, y + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        context.pose().popPose();
    }
}

