/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.screen.handler;

import com.google.common.collect.Lists;
import com.iafenvoy.neptune.recipe.WeaponDeskRecipe;
import com.iafenvoy.neptune.registry.NeptuneBlocks;
import com.iafenvoy.neptune.registry.NeptuneScreenHandlers;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class WeaponDeskScreenHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private final DataSlot selectedRecipe = DataSlot.standalone();
    private final Level world;
    private List<RecipeHolder<WeaponDeskRecipe>> availableRecipes = Lists.newArrayList();
    long lastTakeTime;
    private final Slot materialSlot;
    private final Slot stickSlot;
    private final Slot outputSlot;
    Runnable contentsChangedListener = () -> {};
    private final Container input = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            WeaponDeskScreenHandler.this.slotsChanged((Container)this);
            WeaponDeskScreenHandler.this.contentsChangedListener.run();
        }
    };
    private final ResultContainer output = new ResultContainer();

    public WeaponDeskScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public WeaponDeskScreenHandler(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super((MenuType)NeptuneScreenHandlers.WEAPON_DESK.get(), syncId);
        int i;
        this.context = context;
        this.world = playerInventory.player.level();
        this.materialSlot = this.addSlot(new Slot(this.input, 0, 12, 23));
        this.stickSlot = this.addSlot(new Slot(this.input, 1, 12, 43));
        this.outputSlot = this.addSlot(new Slot((Container)this.output, 2, 143, 33){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                Recipe recipe;
                stack.onCraftedBy(player.level(), player, stack.getCount());
                RecipeHolder recipe2 = WeaponDeskScreenHandler.this.output.getRecipeUsed();
                if (recipe2 == null || !((recipe = recipe2.value()) instanceof WeaponDeskRecipe)) {
                    return;
                }
                WeaponDeskRecipe weaponDeskRecipe = (WeaponDeskRecipe)recipe;
                ItemStack itemStack = WeaponDeskScreenHandler.this.materialSlot.remove(weaponDeskRecipe.material().count());
                WeaponDeskScreenHandler.this.stickSlot.remove(weaponDeskRecipe.stick().count());
                if (!itemStack.isEmpty()) {
                    WeaponDeskScreenHandler.this.populateResult();
                }
                context.execute((world, pos) -> {
                    long l = world.getGameTime();
                    if (WeaponDeskScreenHandler.this.lastTakeTime != l) {
                        world.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WeaponDeskScreenHandler.this.lastTakeTime = l;
                    }
                });
                super.onTake(player, stack);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        this.addDataSlot(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<RecipeHolder<WeaponDeskRecipe>> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public boolean canCraft() {
        return this.materialSlot.hasItem() && this.stickSlot.hasItem() && !this.availableRecipes.isEmpty();
    }

    public boolean stillValid(@NotNull Player player) {
        return WeaponDeskScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)NeptuneBlocks.WEAPON_DESK.get()));
    }

    public boolean clickMenuButton(@NotNull Player player, int id) {
        if (this.isInBounds(id)) {
            this.selectedRecipe.set(id);
            this.populateResult();
        }
        return true;
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void slotsChanged(@NotNull Container inventory) {
        this.updateInput((RecipeInput)new RecipeWrapper((IItemHandler)new InvWrapper(inventory)));
    }

    private void updateInput(RecipeInput input) {
        this.availableRecipes.clear();
        this.selectedRecipe.set(-1);
        this.outputSlot.set(ItemStack.EMPTY);
        if (this.materialSlot.hasItem() && this.stickSlot.hasItem()) {
            this.availableRecipes = this.world.getRecipeManager().getRecipesFor((RecipeType)WeaponDeskRecipe.Type.INSTANCE, input, this.world);
        }
    }

    private void populateResult() {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.selectedRecipe.get())) {
            RecipeHolder<WeaponDeskRecipe> stonecuttingRecipe = this.availableRecipes.get(this.selectedRecipe.get());
            ItemStack itemStack = ((WeaponDeskRecipe)stonecuttingRecipe.value()).assemble((RecipeInput)new RecipeWrapper((IItemHandler)new InvWrapper(this.input)), (HolderLookup.Provider)this.world.registryAccess());
            if (itemStack.isItemEnabled(this.world.enabledFeatures())) {
                this.output.setRecipeUsed(stonecuttingRecipe);
                this.outputSlot.set(itemStack);
            } else {
                this.outputSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.outputSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @NotNull
    public MenuType<?> getType() {
        return (MenuType)NeptuneScreenHandlers.WEAPON_DESK.get();
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, Slot slot) {
        return slot.container != this.output && super.canTakeItemForPickAll(stack, slot);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            Item item = itemStack2.getItem();
            itemStack = itemStack2.copy();
            if (slot == 1) {
                item.onCraftedBy(itemStack2, player.level(), player);
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot2.onQuickCraft(itemStack2, itemStack);
            } else if (slot == 0 ? !this.moveItemStackTo(itemStack2, 2, 38, false) : (this.world.getRecipeManager().getRecipeFor(RecipeType.STONECUTTING, (RecipeInput)new SingleRecipeInput(itemStack2), this.world).isPresent() ? !this.moveItemStackTo(itemStack2, 0, 1, false) : (slot >= 2 && slot < 29 ? !this.moveItemStackTo(itemStack2, 29, 38, false) : slot >= 29 && slot < 38 && !this.moveItemStackTo(itemStack2, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            }
            slot2.setChanged();
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot2.onTake(player, itemStack2);
            this.broadcastChanges();
        }
        return itemStack;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.output.removeItemNoUpdate(1);
        this.context.execute((world, pos) -> this.clearContainer(player, this.input));
    }
}

