/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.neptune.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RaycastHelper {
    @Nullable
    public static EntityHitResult raycastNearest(LivingEntity entity, double maxDistance) {
        Vec3 p1 = entity.getEyePosition();
        Vec3 p2 = p1.add(entity.getViewVector(1.0f).scale(maxDistance));
        Vec3 r = new Vec3(maxDistance, maxDistance, maxDistance);
        return ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)p1, (Vec3)p2, (AABB)new AABB(entity.position().add(r), entity.position().subtract(r)), e -> e instanceof LivingEntity, (double)(maxDistance * maxDistance));
    }

    public static List<EntityHitResult> raycastAll(Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate, double d) {
        Level world = entity.level();
        ArrayList<EntityHitResult> results = new ArrayList<EntityHitResult>();
        for (Entity entity3 : world.getEntities(entity, box, predicate)) {
            Vec3 vec3d2;
            double f;
            AABB box2 = entity3.getBoundingBox().inflate((double)entity3.getPickRadius());
            Optional optional = box2.clip(min, max);
            if (box2.contains(min)) {
                results.add(new EntityHitResult(entity3, optional.orElse(min)));
                continue;
            }
            if (!optional.isPresent() || !((f = min.distanceToSqr(vec3d2 = (Vec3)optional.get())) < d) && d != 0.0) continue;
            results.add(new EntityHitResult(entity3, vec3d2));
        }
        return results;
    }
}

