/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import com.gardenevery.tag.Key;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

final class Tag<T extends Key> {
    private final Object2ReferenceOpenHashMap<String, ObjectOpenHashSet<T>> tagToKeys = new Object2ReferenceOpenHashMap();
    private final Object2ReferenceOpenHashMap<T, ObjectOpenHashSet<String>> keyToTags = new Object2ReferenceOpenHashMap();

    Tag() {
    }

    public Set<T> getKey(@Nonnull String tagName) {
        ObjectOpenHashSet keys = (ObjectOpenHashSet)this.tagToKeys.get((Object)tagName);
        return keys != null ? Collections.unmodifiableSet(keys) : Collections.emptySet();
    }

    public Set<String> getTag(@Nonnull T key) {
        ObjectOpenHashSet tags = (ObjectOpenHashSet)this.keyToTags.get(key);
        return tags != null ? Collections.unmodifiableSet(tags) : Collections.emptySet();
    }

    public boolean hasTag(@Nonnull T key, @Nonnull String tagName) {
        ObjectOpenHashSet tags = (ObjectOpenHashSet)this.keyToTags.get(key);
        return tags != null && tags.contains((Object)tagName);
    }

    public boolean hasAnyTag(@Nonnull T key, @Nonnull Set<String> tagNames) {
        ObjectOpenHashSet tags = (ObjectOpenHashSet)this.keyToTags.get(key);
        if (tags == null) {
            return false;
        }
        for (String tagName : tagNames) {
            if (!tags.contains((Object)tagName)) continue;
            return true;
        }
        return false;
    }

    public void createTag(@Nonnull String tagName, @Nonnull T key) {
        ((ObjectOpenHashSet)this.tagToKeys.computeIfAbsent((Object)tagName, k -> new ObjectOpenHashSet())).add(key);
        ((ObjectOpenHashSet)this.keyToTags.computeIfAbsent(key, k -> new ObjectOpenHashSet())).add((Object)tagName);
    }

    public void createTag(@Nonnull Set<String> tagNames, @Nonnull T key) {
        ObjectOpenHashSet tagsForKey = (ObjectOpenHashSet)this.keyToTags.computeIfAbsent(key, k -> new ObjectOpenHashSet());
        tagsForKey.addAll(tagNames);
        for (String tag : tagNames) {
            ((ObjectOpenHashSet)this.tagToKeys.computeIfAbsent((Object)tag, k -> new ObjectOpenHashSet())).add(key);
        }
    }

    public void createTag(@Nonnull String tagName, @Nonnull Set<T> keys) {
        Set tagKeys = (Set)this.tagToKeys.computeIfAbsent((Object)tagName, k -> new ObjectOpenHashSet());
        tagKeys.addAll(keys);
        for (Key key : keys) {
            ((ObjectOpenHashSet)this.keyToTags.computeIfAbsent((Object)key, k -> new ObjectOpenHashSet())).add((Object)tagName);
        }
    }

    public void createTag(@Nonnull Set<String> tagNames, @Nonnull Set<T> keys) {
        for (String tagName : tagNames) {
            Set tagKeys = (Set)this.tagToKeys.computeIfAbsent((Object)tagName, k -> new ObjectOpenHashSet());
            tagKeys.addAll(keys);
        }
        for (Key key : keys) {
            Set tagsForKey = (Set)this.keyToTags.computeIfAbsent((Object)key, k -> new ObjectOpenHashSet());
            tagsForKey.addAll(tagNames);
        }
    }

    public void removeTag(@Nonnull String tagName) {
        ObjectOpenHashSet keys = (ObjectOpenHashSet)this.tagToKeys.remove((Object)tagName);
        if (keys == null) {
            return;
        }
        for (Key key : keys) {
            ObjectOpenHashSet tagsForKey = (ObjectOpenHashSet)this.keyToTags.get((Object)key);
            if (tagsForKey == null) continue;
            tagsForKey.remove((Object)tagName);
            if (!tagsForKey.isEmpty()) continue;
            this.keyToTags.remove((Object)key);
        }
    }

    public void removeTag(@Nonnull Set<String> tagNames) {
        Object2ReferenceOpenHashMap removals = new Object2ReferenceOpenHashMap();
        for (String tag : tagNames) {
            ObjectOpenHashSet keys = (ObjectOpenHashSet)this.tagToKeys.remove((Object)tag);
            if (keys == null) continue;
            for (Key key : keys) {
                ObjectOpenHashSet set = (ObjectOpenHashSet)removals.computeIfAbsent((Object)key, k -> new ObjectOpenHashSet());
                set.add((Object)tag);
            }
        }
        for (Object2ReferenceMap.Entry entry : removals.object2ReferenceEntrySet()) {
            Key key = (Key)entry.getKey();
            ObjectOpenHashSet tagsToRemove = (ObjectOpenHashSet)entry.getValue();
            ObjectOpenHashSet tagsForKey = (ObjectOpenHashSet)this.keyToTags.get((Object)key);
            if (tagsForKey == null) continue;
            tagsForKey.removeAll((Collection)tagsToRemove);
            if (!tagsForKey.isEmpty()) continue;
            this.keyToTags.remove((Object)key);
        }
    }

    public void removeTagKey(@Nonnull String tagName, @Nonnull T key) {
        ObjectOpenHashSet tagsForKey;
        ObjectOpenHashSet keysForTag = (ObjectOpenHashSet)this.tagToKeys.get((Object)tagName);
        if (keysForTag != null) {
            keysForTag.remove(key);
            if (keysForTag.isEmpty()) {
                this.tagToKeys.remove((Object)tagName);
            }
        }
        if ((tagsForKey = (ObjectOpenHashSet)this.keyToTags.get(key)) != null) {
            tagsForKey.remove((Object)tagName);
            if (tagsForKey.isEmpty()) {
                this.keyToTags.remove(key);
            }
        }
    }

    public void removeTagKey(@Nonnull Set<String> tagNames, @Nonnull T key) {
        ObjectOpenHashSet tagsForKey = (ObjectOpenHashSet)this.keyToTags.get(key);
        if (tagsForKey != null) {
            tagsForKey.removeAll(tagNames);
            if (tagsForKey.isEmpty()) {
                this.keyToTags.remove(key);
            }
        }
        for (String tagName : tagNames) {
            ObjectOpenHashSet keysForTag = (ObjectOpenHashSet)this.tagToKeys.get((Object)tagName);
            if (keysForTag == null) continue;
            keysForTag.remove(key);
            if (!keysForTag.isEmpty()) continue;
            this.tagToKeys.remove((Object)tagName);
        }
    }

    public void removeTagKey(@Nonnull String tagName, @Nonnull Set<T> keys) {
        ObjectOpenHashSet keysForTag = (ObjectOpenHashSet)this.tagToKeys.get((Object)tagName);
        if (keysForTag == null) {
            return;
        }
        keysForTag.removeAll(keys);
        if (keysForTag.isEmpty()) {
            this.tagToKeys.remove((Object)tagName);
        }
        for (Key key : keys) {
            ObjectOpenHashSet tagsForKey = (ObjectOpenHashSet)this.keyToTags.get((Object)key);
            if (tagsForKey == null) continue;
            tagsForKey.remove((Object)tagName);
            if (!tagsForKey.isEmpty()) continue;
            this.keyToTags.remove((Object)key);
        }
    }

    public void removeTagKey(@Nonnull Set<String> tagNames, @Nonnull Set<T> keys) {
        for (Key key : keys) {
            ObjectOpenHashSet tagsForKey = (ObjectOpenHashSet)this.keyToTags.get((Object)key);
            if (tagsForKey == null) continue;
            tagsForKey.removeAll(tagNames);
            if (!tagsForKey.isEmpty()) continue;
            this.keyToTags.remove((Object)key);
        }
        for (String tagName : tagNames) {
            ObjectOpenHashSet keysForTag = (ObjectOpenHashSet)this.tagToKeys.get((Object)tagName);
            if (keysForTag == null) continue;
            keysForTag.removeAll(keys);
            if (!keysForTag.isEmpty()) continue;
            this.tagToKeys.remove((Object)tagName);
        }
    }

    public boolean doesTagExist(@Nonnull String tagName) {
        return this.tagToKeys.containsKey((Object)tagName);
    }

    public boolean containsKey(@Nonnull T key) {
        return this.keyToTags.containsKey(key);
    }

    public int getTagCount() {
        return this.tagToKeys.size();
    }

    public int getKeyCount() {
        return this.keyToTags.size();
    }

    public int getAssociations() {
        int count = 0;
        for (Map.Entry entry : this.tagToKeys.entrySet()) {
            count += ((ObjectOpenHashSet)entry.getValue()).size();
        }
        return count;
    }
}

