/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import com.gardenevery.tag.TagHelper;
import com.gardenevery.tag.TagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TagCommand
extends CommandBase {
    public final CommandManager commandManager = new CommandManager();
    public static final Level LEVEL0 = Level.ALL;
    public static final Level LEVEL1 = Level.PLAYER;
    public static final Level LEVEL2 = Level.MODERATOR;
    public static final Level LEVEL3 = Level.OPERATOR;
    public static final Level LEVEL4 = Level.ADMIN;

    public TagCommand() {
        this.registerCommands();
    }

    private void registerCommands() {
        this.commandManager.registerCommand(new CommandHandler("hand", LEVEL0, (server, sender) -> this.showHeldItemTags((ICommandSender)sender), "com.gardenevery.tag.help.hand"));
        this.commandManager.registerCommand(new CommandHandler("info", LEVEL2, (server, sender) -> this.showTagStatistics((ICommandSender)sender), "com.gardenevery.tag.help.info"));
    }

    @Nonnull
    public String getName() {
        return "tag";
    }

    @Nonnull
    public String getUsage(@Nonnull ICommandSender sender) {
        return "tag [hand|info]";
    }

    public void execute(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        this.commandManager.executeCommand(server, sender, args);
    }

    @Nonnull
    public List<String> getTabCompletions(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, BlockPos targetPos) {
        return this.commandManager.getTabCompletions(args);
    }

    private void showHelp(@Nonnull ICommandSender sender) {
        sender.sendMessage((ITextComponent)new TextComponentTranslation("com.gardenevery.tag.help.title", new Object[0]));
        this.commandManager.getSubCommandNames().stream().map(this.commandManager::getHandler).filter(Optional::isPresent).map(Optional::get).filter(handler -> handler.permission().hasPermission(sender, "tag")).forEach(handler -> sender.sendMessage((ITextComponent)new TextComponentTranslation(handler.descriptionKey(), new Object[0])));
    }

    private void showHeldItemTags(@Nonnull ICommandSender sender) {
        ICommandSender iCommandSender = sender;
        if (!(iCommandSender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)iCommandSender;
        boolean hasItems = Stream.of(EnumHand.values()).map(arg_0 -> ((EntityPlayer)player).getHeldItem(arg_0)).anyMatch(stack -> !stack.isEmpty());
        if (!hasItems) {
            player.sendMessage((ITextComponent)new TextComponentTranslation("com.gardenevery.tag.noitem", new Object[0]));
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack2 = player.getHeldItem(hand);
            if (stack2.isEmpty()) continue;
            this.processItemStack(player, hand, stack2);
        }
    }

    private void processItemStack(@Nonnull EntityPlayer player, EnumHand hand, @Nonnull ItemStack stack) {
        String handName = this.getHandDisplayName(hand);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            this.handleFluidContainer(player, handName, fluidHandler);
        } else {
            this.handleRegularItem(player, handName, stack);
        }
    }

    private String getHandDisplayName(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND ? new TextComponentTranslation("com.gardenevery.tag.mainhand", new Object[0]).getUnformattedText() : new TextComponentTranslation("com.gardenevery.tag.offhand", new Object[0]).getUnformattedText();
    }

    private void handleFluidContainer(@Nonnull EntityPlayer player, String handName, IFluidHandlerItem fluidHandler) {
        FluidStack fluid = fluidHandler.drain(Integer.MAX_VALUE, false);
        if (fluid != null && fluid.amount > 0) {
            Set<String> fluidTags = TagHelper.tags(fluid);
            String translationKey = !fluidTags.isEmpty() ? "com.gardenevery.tag.fluidtags" : "com.gardenevery.tag.nofluidtags";
            this.sendFormattedMessage(player, handName, translationKey, String.join((CharSequence)", ", fluidTags));
        } else {
            this.sendFormattedMessage(player, handName, "com.gardenevery.tag.emptycontainer", "");
        }
    }

    private void handleRegularItem(@Nonnull EntityPlayer player, String handName, @Nonnull ItemStack stack) {
        Set<String> itemTags = TagHelper.tags(stack);
        String translationKey = !itemTags.isEmpty() ? "com.gardenevery.tag.itemtags" : "com.gardenevery.tag.noitemtags";
        this.sendFormattedMessage(player, handName, translationKey, String.join((CharSequence)", ", itemTags));
    }

    private void sendFormattedMessage(@Nonnull EntityPlayer player, String handName, String translationKey, String tags) {
        String translatedPart = new TextComponentTranslation(translationKey, new Object[]{tags}).getUnformattedText();
        String message = String.format("%s %s", handName, translatedPart).trim();
        player.sendMessage((ITextComponent)new TextComponentString(message));
    }

    private void showTagStatistics(@Nonnull ICommandSender sender) {
        sender.sendMessage((ITextComponent)new TextComponentTranslation("com.gardenevery.tag.statistics.title", new Object[0]));
        this.displayStatisticsForType(sender, "com.gardenevery.tag.statistics.items", TagType.ITEM);
        this.displayStatisticsForType(sender, "com.gardenevery.tag.statistics.fluids", TagType.FLUID);
        this.displayStatisticsForType(sender, "com.gardenevery.tag.statistics.blocks", TagType.BLOCK);
        this.displayTotalStatistics(sender);
    }

    private void displayStatisticsForType(@Nonnull ICommandSender sender, String translationKey, TagType type) {
        TagStatistics stats = this.createTagStatistics(type);
        this.sendStatisticMessage(sender, translationKey, stats);
    }

    private void displayTotalStatistics(@Nonnull ICommandSender sender) {
        TagStatistics totalStats = new TagStatistics(TagHelper.tagCount(), TagHelper.associations(), TagHelper.keyCount());
        this.sendStatisticMessage(sender, "com.gardenevery.tag.statistics.total", totalStats);
    }

    private TagStatistics createTagStatistics(TagType type) {
        return new TagStatistics(TagHelper.tagCount(type), TagHelper.totalAssociations(type), TagHelper.uniqueKeyCount(type));
    }

    private void sendStatisticMessage(@Nonnull ICommandSender sender, String key, TagStatistics stats) {
        sender.sendMessage((ITextComponent)new TextComponentTranslation(key, new Object[]{stats.tagCount(), stats.elementCount(), stats.uniqueElementCount()}));
    }

    public boolean checkPermission(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        return true;
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public class CommandManager {
        private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
        private final List<String> subCommandNames = new ArrayList<String>();

        public void registerCommand(CommandHandler handler) {
            this.commands.put(handler.name().toLowerCase(), handler);
            this.subCommandNames.add(handler.name());
        }

        public Optional<CommandHandler> getHandler(String command) {
            return Optional.ofNullable(this.commands.get(command.toLowerCase()));
        }

        public List<String> getSubCommandNames() {
            return Collections.unmodifiableList(this.subCommandNames);
        }

        public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length == 0) {
                TagCommand.this.showHelp(sender);
                return;
            }
            String subCommand = args[0].toLowerCase();
            Optional<CommandHandler> handlerOptional = this.getHandler(subCommand);
            if (handlerOptional.isPresent()) {
                this.executeHandler(server, sender, handlerOptional.get());
            } else {
                TagCommand.this.showHelp(sender);
            }
        }

        private void executeHandler(MinecraftServer server, ICommandSender sender, CommandHandler handler) {
            if (!handler.permission().hasPermission(sender, "tag")) {
                sender.sendMessage((ITextComponent)new TextComponentTranslation("com.gardenevery.tag.nopermission", new Object[0]));
                return;
            }
            handler.executor().accept(server, sender);
        }

        public List<String> getTabCompletions(String[] args) {
            return args.length == 1 ? CommandBase.getListOfStringsMatchingLastWord((String[])args, this.getSubCommandNames()) : Collections.emptyList();
        }
    }

    public static final class CommandHandler {
        private final String name;
        private final Level permission;
        private final BiConsumer<MinecraftServer, ICommandSender> executor;
        private final String descriptionKey;

        public CommandHandler(String name, Level permission, BiConsumer<MinecraftServer, ICommandSender> executor, String descriptionKey) {
            this.name = name;
            this.permission = permission;
            this.executor = executor;
            this.descriptionKey = descriptionKey;
        }

        public String toString() {
            return "CommandHandler[" + "name=" + this.name + "," + "permission=" + (Object)((Object)this.permission) + "," + "executor=" + this.executor + "," + "descriptionKey=" + this.descriptionKey + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
            result = 31 * result + (this.executor != null ? this.executor.hashCode() : 0);
            result = 31 * result + (this.descriptionKey != null ? this.descriptionKey.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((CommandHandler)arg0).name, this.name)) {
                return false;
            }
            if (!Objects.equals((Object)((CommandHandler)arg0).permission, (Object)this.permission)) {
                return false;
            }
            if (!Objects.equals(((CommandHandler)arg0).executor, this.executor)) {
                return false;
            }
            return Objects.equals(((CommandHandler)arg0).descriptionKey, this.descriptionKey);
            {
            }
        }

        public String name() {
            return this.name;
        }

        public Level permission() {
            return this.permission;
        }

        public BiConsumer<MinecraftServer, ICommandSender> executor() {
            return this.executor;
        }

        public String descriptionKey() {
            return this.descriptionKey;
        }
    }

    public static enum Level {
        ALL(0),
        PLAYER(1),
        MODERATOR(2),
        OPERATOR(3),
        ADMIN(4);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public boolean hasPermission(ICommandSender sender, String commandName) {
            return sender.canUseCommand(this.level, commandName);
        }
    }

    private static final class TranslationKeys {
        static final String HELP_TITLE = "com.gardenevery.tag.help.title";
        static final String HELP_HAND = "com.gardenevery.tag.help.hand";
        static final String HELP_INFO = "com.gardenevery.tag.help.info";
        static final String NO_ITEM = "com.gardenevery.tag.noitem";
        static final String MAIN_HAND = "com.gardenevery.tag.mainhand";
        static final String OFF_HAND = "com.gardenevery.tag.offhand";
        static final String FLUID_TAGS = "com.gardenevery.tag.fluidtags";
        static final String NO_FLUID_TAGS = "com.gardenevery.tag.nofluidtags";
        static final String EMPTY_CONTAINER = "com.gardenevery.tag.emptycontainer";
        static final String ITEM_TAGS = "com.gardenevery.tag.itemtags";
        static final String NO_ITEM_TAGS = "com.gardenevery.tag.noitemtags";
        static final String NO_PERMISSION = "com.gardenevery.tag.nopermission";
        static final String STATISTICS_TITLE = "com.gardenevery.tag.statistics.title";
        static final String STATISTICS_ITEMS = "com.gardenevery.tag.statistics.items";
        static final String STATISTICS_FLUIDS = "com.gardenevery.tag.statistics.fluids";
        static final String STATISTICS_BLOCKS = "com.gardenevery.tag.statistics.blocks";
        static final String STATISTICS_TOTAL = "com.gardenevery.tag.statistics.total";

        private TranslationKeys() {
        }
    }

    private static final class TagStatistics {
        private final int tagCount;
        private final int elementCount;
        private final int uniqueElementCount;

        private TagStatistics(int tagCount, int elementCount, int uniqueElementCount) {
            this.tagCount = tagCount;
            this.elementCount = elementCount;
            this.uniqueElementCount = uniqueElementCount;
        }

        public String toString() {
            return "TagStatistics[" + "tagCount=" + this.tagCount + "," + "elementCount=" + this.elementCount + "," + "uniqueElementCount=" + this.uniqueElementCount + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.tagCount;
            result = 31 * result + this.elementCount;
            result = 31 * result + this.uniqueElementCount;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((TagStatistics)arg0).tagCount != this.tagCount) {
                return false;
            }
            if (((TagStatistics)arg0).elementCount != this.elementCount) {
                return false;
            }
            return ((TagStatistics)arg0).uniqueElementCount == this.uniqueElementCount;
            {
            }
        }

        public int tagCount() {
            return this.tagCount;
        }

        public int elementCount() {
            return this.elementCount;
        }

        public int uniqueElementCount() {
            return this.uniqueElementCount;
        }
    }
}

