/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import com.gardenevery.tag.TagHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class TagTooltip {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (TagTooltip.isShiftKeyDown()) {
            TagTooltip.generateTagTooltip(event);
        } else {
            event.getToolTip().add(TextFormatting.GRAY + I18n.format((String)"tooltip.hold_shift_for_tags", (Object[])new Object[0]));
        }
    }

    private static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    private static void generateTagTooltip(ItemTooltipEvent event) {
        Set<String> tags = TagHelper.tags(event.getItemStack());
        if (tags.isEmpty()) {
            return;
        }
        List tooltip = event.getToolTip();
        tooltip.add("Tags:");
        tags.stream().sorted().map(tag -> " " + tag).forEach(tooltip::add);
    }
}

