/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import com.gardenevery.tag.Key;
import com.gardenevery.tag.TagManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class AbstractTagBuilder {
    private static final Logger LOGGER = LogManager.getLogger((String)"TagBuilder");
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9:_/]+");
    protected final String tagName;
    protected final boolean isValid;
    private static boolean registrationClosed = false;

    protected AbstractTagBuilder(String tagName) {
        this.isValid = !registrationClosed && AbstractTagBuilder.validateTagName(tagName);
        String string = this.tagName = this.isValid ? tagName : null;
        if (registrationClosed && AbstractTagBuilder.validateTagName(tagName)) {
            AbstractTagBuilder.logRegistrationClosed();
        }
    }

    static void closeRegistration() {
        registrationClosed = true;
    }

    static boolean validateTagName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (!NAME_PATTERN.matcher(name).matches()) {
            LOGGER.warn("Tag name '{}' is invalid.", (Object)name);
            return false;
        }
        return true;
    }

    static Set<String> validateTagName(@Nullable String[] names) {
        if (names == null || names.length < 2) {
            LOGGER.warn("At least 2 tag names are required.");
            return Collections.emptySet();
        }
        HashSet<String> validNames = new HashSet<String>();
        for (String name : names) {
            if (!AbstractTagBuilder.validateTagName(name)) continue;
            validNames.add(name);
        }
        if (validNames.isEmpty()) {
            return Collections.emptySet();
        }
        return validNames;
    }

    private static void logRegistrationClosed() {
        LOGGER.warn("Tag registration is closed after FMLLoadCompleteEvent.");
    }

    public static class InvalidMultiBlockTag
    implements MultiBlockAddable,
    MultiBlockRemoveKey,
    MultiCompleted {
        @Override
        public MultiBlockAddable add(@Nullable Block block) {
            return this;
        }

        @Override
        public MultiBlockRemoveKey removeKey(@Nullable Block block) {
            return this;
        }
    }

    public static class InvalidMultiFluidTag
    implements MultiFluidAddable,
    MultiFluidRemoveKey,
    MultiCompleted {
        @Override
        public MultiFluidAddable add(@Nullable FluidStack stack) {
            return this;
        }

        @Override
        public MultiFluidRemoveKey removeKey(@Nullable FluidStack stack) {
            return this;
        }

        @Override
        public MultiFluidRemoveKey removeKey(Fluid fluid) {
            return this;
        }

        @Override
        public MultiFluidAddable add(Fluid fluid) {
            return this;
        }
    }

    public static class InvalidMultiItemTag
    implements MultiItemAddable,
    MultiItemRemoveKey,
    MultiCompleted {
        @Override
        public MultiItemAddable add(@Nullable ItemStack stack) {
            return this;
        }

        @Override
        public MultiItemRemoveKey removeKey(@Nullable ItemStack stack) {
            return this;
        }

        @Override
        public MultiItemRemoveKey removeKey(Item item) {
            return this;
        }

        @Override
        public MultiItemRemoveKey removeKey(Item item, int metadata) {
            return this;
        }

        @Override
        public MultiItemAddable add(Item item) {
            return this;
        }

        @Override
        public MultiItemAddable add(Item item, int metadata) {
            return this;
        }
    }

    public static class MultiBlockTagAdder
    implements MultiBlockAddable,
    MultiCompleted {
        private final Set<String> tagNames;

        MultiBlockTagAdder(Set<String> tagNames) {
            this.tagNames = tagNames;
        }

        @Override
        public MultiBlockAddable add(@Nullable Block block) {
            Key.BlockKey key = Key.BlockKey.toKey(block);
            if (key != null) {
                TagManager.BLOCK.createTag(this.tagNames, key);
            }
            return this;
        }
    }

    public static class MultiBlockTagRemover
    implements MultiBlockRemoveKey,
    MultiCompleted {
        private final Set<String> tagNames;

        MultiBlockTagRemover(Set<String> tagNames) {
            this.tagNames = tagNames;
        }

        @Override
        public MultiBlockRemoveKey removeKey(@Nullable Block block) {
            Key.BlockKey key = Key.BlockKey.toKey(block);
            if (key != null) {
                TagManager.BLOCK.removeTagKey(this.tagNames, key);
            }
            return this;
        }
    }

    public static class MultiBlockTagBuilder
    extends MultiTagBuilder {
        public MultiBlockTagBuilder(String ... tagNames) {
            super(tagNames);
        }

        @Override
        public MultiBlockInitialState initialState() {
            return new InitialState();
        }

        public class InitialState
        implements MultiBlockInitialState {
            @Override
            public MultiBlockAddable add(@Nullable Block block) {
                if (!MultiBlockTagBuilder.this.isValid) {
                    return new InvalidMultiBlockTag();
                }
                Key.BlockKey key = Key.BlockKey.toKey(block);
                if (key != null) {
                    TagManager.BLOCK.createTag((Set<String>)MultiBlockTagBuilder.this.tagNames, key);
                }
                return new MultiBlockTagAdder(MultiBlockTagBuilder.this.tagNames);
            }

            @Override
            public MultiBlockRemoveKey removeKey(@Nullable Block block) {
                if (!MultiBlockTagBuilder.this.isValid) {
                    return new InvalidMultiBlockTag();
                }
                Key.BlockKey key = Key.BlockKey.toKey(block);
                if (key != null) {
                    TagManager.BLOCK.removeTagKey((Set<String>)MultiBlockTagBuilder.this.tagNames, key);
                }
                return new MultiBlockTagRemover(MultiBlockTagBuilder.this.tagNames);
            }

            @Override
            public void removeTag() {
                if (!MultiBlockTagBuilder.this.isValid) {
                    return;
                }
                TagManager.BLOCK.removeTag(MultiBlockTagBuilder.this.tagNames);
            }
        }
    }

    public static class MultiFluidTagAdder
    implements MultiFluidAddable,
    MultiCompleted {
        private final Set<String> tagNames;

        MultiFluidTagAdder(Set<String> tagNames) {
            this.tagNames = tagNames;
        }

        @Override
        public MultiFluidAddable add(@Nullable FluidStack stack) {
            Key.FluidKey key = Key.FluidKey.toKey(stack);
            if (key != null) {
                TagManager.FLUID.createTag(this.tagNames, key);
            }
            return this;
        }

        @Override
        public MultiFluidAddable add(Fluid fluid) {
            return this.add(new FluidStack(fluid, 1000));
        }
    }

    public static class MultiFluidTagRemover
    implements MultiFluidRemoveKey,
    MultiCompleted {
        private final Set<String> tagNames;

        MultiFluidTagRemover(Set<String> tagNames) {
            this.tagNames = tagNames;
        }

        @Override
        public MultiFluidRemoveKey removeKey(@Nullable FluidStack stack) {
            Key.FluidKey key = Key.FluidKey.toKey(stack);
            if (key != null) {
                TagManager.FLUID.removeTagKey(this.tagNames, key);
            }
            return this;
        }

        @Override
        public MultiFluidRemoveKey removeKey(Fluid fluid) {
            return this.removeKey(new FluidStack(fluid, 1000));
        }
    }

    public static class MultiFluidTagBuilder
    extends MultiTagBuilder {
        public MultiFluidTagBuilder(String ... tagNames) {
            super(tagNames);
        }

        @Override
        public MultiFluidInitialState initialState() {
            return new InitialState();
        }

        public class InitialState
        implements MultiFluidInitialState {
            @Override
            public MultiFluidAddable add(@Nullable FluidStack stack) {
                if (!MultiFluidTagBuilder.this.isValid) {
                    return new InvalidMultiFluidTag();
                }
                Key.FluidKey key = Key.FluidKey.toKey(stack);
                if (key != null) {
                    TagManager.FLUID.createTag((Set<String>)MultiFluidTagBuilder.this.tagNames, key);
                }
                return new MultiFluidTagAdder(MultiFluidTagBuilder.this.tagNames);
            }

            @Override
            public MultiFluidRemoveKey removeKey(@Nullable FluidStack stack) {
                if (!MultiFluidTagBuilder.this.isValid) {
                    return new InvalidMultiFluidTag();
                }
                Key.FluidKey key = Key.FluidKey.toKey(stack);
                if (key != null) {
                    TagManager.FLUID.removeTagKey((Set<String>)MultiFluidTagBuilder.this.tagNames, key);
                }
                return new MultiFluidTagRemover(MultiFluidTagBuilder.this.tagNames);
            }

            @Override
            public MultiFluidRemoveKey removeKey(Fluid fluid) {
                return this.removeKey(new FluidStack(fluid, 1000));
            }

            @Override
            public void removeTag() {
                if (!MultiFluidTagBuilder.this.isValid) {
                    return;
                }
                TagManager.FLUID.removeTag(MultiFluidTagBuilder.this.tagNames);
            }

            @Override
            public MultiFluidAddable add(Fluid fluid) {
                return this.add(new FluidStack(fluid, 1000));
            }
        }
    }

    public static class MultiItemTagAdder
    implements MultiItemAddable,
    MultiCompleted {
        private final Set<String> tagNames;

        MultiItemTagAdder(Set<String> tagNames) {
            this.tagNames = tagNames;
        }

        @Override
        public MultiItemAddable add(@Nullable ItemStack stack) {
            Key.ItemKey key = Key.ItemKey.toKey(stack);
            if (key != null) {
                TagManager.ITEM.createTag(this.tagNames, key);
            }
            return this;
        }

        @Override
        public MultiItemAddable add(Item item) {
            return this.add(new ItemStack(item));
        }

        @Override
        public MultiItemAddable add(Item item, int metadata) {
            return this.add(new ItemStack(item, 1, metadata));
        }
    }

    public static class MultiItemTagRemover
    implements MultiItemRemoveKey,
    MultiCompleted {
        private final Set<String> tagNames;

        MultiItemTagRemover(Set<String> tagNames) {
            this.tagNames = tagNames;
        }

        @Override
        public MultiItemRemoveKey removeKey(@Nullable ItemStack stack) {
            Key.ItemKey key = Key.ItemKey.toKey(stack);
            if (key != null) {
                TagManager.ITEM.removeTagKey(this.tagNames, key);
            }
            return this;
        }

        @Override
        public MultiItemRemoveKey removeKey(Item item) {
            return this.removeKey(new ItemStack(item));
        }

        @Override
        public MultiItemRemoveKey removeKey(Item item, int metadata) {
            return this.removeKey(new ItemStack(item, 1, metadata));
        }
    }

    public static class MultiItemTagBuilder
    extends MultiTagBuilder {
        public MultiItemTagBuilder(String ... tagNames) {
            super(tagNames);
        }

        @Override
        public MultiItemInitialState initialState() {
            return new InitialState();
        }

        public class InitialState
        implements MultiItemInitialState {
            @Override
            public MultiItemAddable add(@Nullable ItemStack stack) {
                if (!MultiItemTagBuilder.this.isValid) {
                    return new InvalidMultiItemTag();
                }
                Key.ItemKey key = Key.ItemKey.toKey(stack);
                if (key != null) {
                    TagManager.ITEM.createTag((Set<String>)MultiItemTagBuilder.this.tagNames, key);
                }
                return new MultiItemTagAdder(MultiItemTagBuilder.this.tagNames);
            }

            @Override
            public MultiItemRemoveKey removeKey(@Nullable ItemStack stack) {
                if (!MultiItemTagBuilder.this.isValid) {
                    return new InvalidMultiItemTag();
                }
                Key.ItemKey key = Key.ItemKey.toKey(stack);
                if (key != null) {
                    TagManager.ITEM.removeTagKey((Set<String>)MultiItemTagBuilder.this.tagNames, key);
                }
                return new MultiItemTagRemover(MultiItemTagBuilder.this.tagNames);
            }

            @Override
            public MultiItemRemoveKey removeKey(Item item) {
                return this.removeKey(new ItemStack(item));
            }

            @Override
            public MultiItemRemoveKey removeKey(Item item, int metadata) {
                return this.removeKey(new ItemStack(item, 1, metadata));
            }

            @Override
            public void removeTag() {
                if (!MultiItemTagBuilder.this.isValid) {
                    return;
                }
                TagManager.ITEM.removeTag(MultiItemTagBuilder.this.tagNames);
            }

            @Override
            public MultiItemAddable add(Item item) {
                return this.add(new ItemStack(item));
            }

            @Override
            public MultiItemAddable add(Item item, int metadata) {
                return this.add(new ItemStack(item, 1, metadata));
            }
        }
    }

    public static abstract class MultiTagBuilder {
        protected final Set<String> tagNames;
        protected final boolean isValid;

        protected MultiTagBuilder(String[] tagNames) {
            Set<String> validNames = AbstractTagBuilder.validateTagName(tagNames);
            this.isValid = !registrationClosed && !validNames.isEmpty();
            Set<String> set = this.tagNames = this.isValid ? validNames : Collections.emptySet();
            if (registrationClosed && !validNames.isEmpty()) {
                AbstractTagBuilder.logRegistrationClosed();
            }
        }

        public abstract Object initialState();
    }

    public static class InvalidBlockTag
    implements BlockAddable,
    BlockRemoveKey,
    Completed {
        @Override
        public BlockAddable add(@Nullable Block block) {
            return this;
        }

        @Override
        public BlockRemoveKey removeKey(@Nullable Block block) {
            return this;
        }
    }

    public static class BlockTagAdder
    implements BlockAddable,
    Completed {
        private final String tagName;

        BlockTagAdder(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public BlockAddable add(@Nullable Block block) {
            Key.BlockKey key = Key.BlockKey.toKey(block);
            if (key != null) {
                TagManager.BLOCK.createTag(this.tagName, key);
            }
            return this;
        }
    }

    public static class BlockTagRemover
    implements BlockRemoveKey,
    Completed {
        private final String tagName;

        BlockTagRemover(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public BlockRemoveKey removeKey(@Nullable Block block) {
            Key.BlockKey key = Key.BlockKey.toKey(block);
            if (key != null) {
                TagManager.BLOCK.removeTagKey(this.tagName, key);
            }
            return this;
        }
    }

    public static class BlockTagBuilder
    extends AbstractTagBuilder {
        public BlockTagBuilder(String tagName) {
            super(tagName);
        }

        public BlockInitialState initialState() {
            return new InitialState();
        }

        public class InitialState
        implements BlockInitialState {
            @Override
            public BlockAddable add(@Nullable Block block) {
                if (!BlockTagBuilder.this.isValid) {
                    return new InvalidBlockTag();
                }
                Key.BlockKey key = Key.BlockKey.toKey(block);
                if (key != null) {
                    TagManager.BLOCK.createTag(BlockTagBuilder.this.tagName, key);
                }
                return new BlockTagAdder(BlockTagBuilder.this.tagName);
            }

            @Override
            public BlockRemoveKey removeKey(@Nullable Block block) {
                if (!BlockTagBuilder.this.isValid) {
                    return new InvalidBlockTag();
                }
                Key.BlockKey key = Key.BlockKey.toKey(block);
                if (key != null) {
                    TagManager.BLOCK.removeTagKey(BlockTagBuilder.this.tagName, key);
                }
                return new BlockTagRemover(BlockTagBuilder.this.tagName);
            }

            @Override
            public void removeTag() {
                if (!BlockTagBuilder.this.isValid) {
                    return;
                }
                TagManager.BLOCK.removeTag(BlockTagBuilder.this.tagName);
            }
        }
    }

    public static class InvalidFluidTag
    implements FluidAddable,
    FluidRemoveKey,
    Completed {
        @Override
        public FluidAddable add(@Nullable FluidStack stack) {
            return this;
        }

        @Override
        public FluidRemoveKey removeKey(@Nullable FluidStack stack) {
            return this;
        }

        @Override
        public FluidRemoveKey removeKey(Fluid fluid) {
            return this;
        }

        @Override
        public FluidAddable add(Fluid fluid) {
            return this;
        }
    }

    public static class FluidTagAdder
    implements FluidAddable,
    Completed {
        private final String tagName;

        FluidTagAdder(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public FluidAddable add(@Nullable FluidStack stack) {
            Key.FluidKey key = Key.FluidKey.toKey(stack);
            if (key != null) {
                TagManager.FLUID.createTag(this.tagName, key);
            }
            return this;
        }

        @Override
        public FluidAddable add(Fluid fluid) {
            return this.add(new FluidStack(fluid, 1000));
        }
    }

    public static class FluidTagRemover
    implements FluidRemoveKey,
    Completed {
        private final String tagName;

        FluidTagRemover(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public FluidRemoveKey removeKey(@Nullable FluidStack stack) {
            Key.FluidKey key = Key.FluidKey.toKey(stack);
            if (key != null) {
                TagManager.FLUID.removeTagKey(this.tagName, key);
            }
            return this;
        }

        @Override
        public FluidRemoveKey removeKey(Fluid fluid) {
            return this.removeKey(new FluidStack(fluid, 1000));
        }
    }

    public static class FluidTagBuilder
    extends AbstractTagBuilder {
        public FluidTagBuilder(String tagName) {
            super(tagName);
        }

        public FluidInitialState initialState() {
            return new InitialState();
        }

        public class InitialState
        implements FluidInitialState {
            @Override
            public FluidAddable add(@Nullable FluidStack stack) {
                if (!FluidTagBuilder.this.isValid) {
                    return new InvalidFluidTag();
                }
                Key.FluidKey key = Key.FluidKey.toKey(stack);
                if (key != null) {
                    TagManager.FLUID.createTag(FluidTagBuilder.this.tagName, key);
                }
                return new FluidTagAdder(FluidTagBuilder.this.tagName);
            }

            @Override
            public FluidRemoveKey removeKey(@Nullable FluidStack stack) {
                if (!FluidTagBuilder.this.isValid) {
                    return new InvalidFluidTag();
                }
                Key.FluidKey key = Key.FluidKey.toKey(stack);
                if (key != null) {
                    TagManager.FLUID.removeTagKey(FluidTagBuilder.this.tagName, key);
                }
                return new FluidTagRemover(FluidTagBuilder.this.tagName);
            }

            @Override
            public FluidRemoveKey removeKey(Fluid fluid) {
                return this.removeKey(new FluidStack(fluid, 1000));
            }

            @Override
            public void removeTag() {
                if (!FluidTagBuilder.this.isValid) {
                    return;
                }
                TagManager.FLUID.removeTag(FluidTagBuilder.this.tagName);
            }

            @Override
            public FluidAddable add(Fluid fluid) {
                return this.add(new FluidStack(fluid, 1000));
            }
        }
    }

    public static class InvalidItemTag
    implements ItemAddable,
    ItemRemoveKey,
    Completed {
        @Override
        public ItemAddable add(@Nullable ItemStack stack) {
            return this;
        }

        @Override
        public ItemRemoveKey removeKey(@Nullable ItemStack stack) {
            return this;
        }

        @Override
        public ItemRemoveKey removeKey(Item item) {
            return this;
        }

        @Override
        public ItemRemoveKey removeKey(Item item, int metadata) {
            return this;
        }

        @Override
        public ItemAddable add(Item item) {
            return this;
        }

        @Override
        public ItemAddable add(Item item, int metadata) {
            return this;
        }
    }

    public static class ItemTagAdder
    implements ItemAddable,
    Completed {
        private final String tagName;

        ItemTagAdder(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public ItemAddable add(@Nullable ItemStack stack) {
            Key.ItemKey key = Key.ItemKey.toKey(stack);
            if (key != null) {
                TagManager.ITEM.createTag(this.tagName, key);
            }
            return this;
        }

        @Override
        public ItemAddable add(Item item) {
            return this.add(new ItemStack(item));
        }

        @Override
        public ItemAddable add(Item item, int metadata) {
            return this.add(new ItemStack(item, 1, metadata));
        }
    }

    public static class ItemTagRemover
    implements ItemRemoveKey,
    Completed {
        private final String tagName;

        ItemTagRemover(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public ItemRemoveKey removeKey(@Nullable ItemStack stack) {
            Key.ItemKey key = Key.ItemKey.toKey(stack);
            if (key != null) {
                TagManager.ITEM.removeTagKey(this.tagName, key);
            }
            return this;
        }

        @Override
        public ItemRemoveKey removeKey(Item item) {
            return this.removeKey(new ItemStack(item));
        }

        @Override
        public ItemRemoveKey removeKey(Item item, int metadata) {
            return this.removeKey(new ItemStack(item, 1, metadata));
        }
    }

    public static class ItemTagBuilder
    extends AbstractTagBuilder {
        public ItemTagBuilder(String tagName) {
            super(tagName);
        }

        public ItemInitialState initialState() {
            return new InitialState();
        }

        public class InitialState
        implements ItemInitialState {
            @Override
            public ItemAddable add(@Nullable ItemStack stack) {
                if (!ItemTagBuilder.this.isValid) {
                    return new InvalidItemTag();
                }
                Key.ItemKey key = Key.ItemKey.toKey(stack);
                if (key != null) {
                    TagManager.ITEM.createTag(ItemTagBuilder.this.tagName, key);
                }
                return new ItemTagAdder(ItemTagBuilder.this.tagName);
            }

            @Override
            public ItemRemoveKey removeKey(@Nullable ItemStack stack) {
                if (!ItemTagBuilder.this.isValid) {
                    return new InvalidItemTag();
                }
                Key.ItemKey key = Key.ItemKey.toKey(stack);
                if (key != null) {
                    TagManager.ITEM.removeTagKey(ItemTagBuilder.this.tagName, key);
                }
                return new ItemTagRemover(ItemTagBuilder.this.tagName);
            }

            @Override
            public ItemRemoveKey removeKey(Item item) {
                return this.removeKey(new ItemStack(item));
            }

            @Override
            public ItemRemoveKey removeKey(Item item, int metadata) {
                return this.removeKey(new ItemStack(item, 1, metadata));
            }

            @Override
            public void removeTag() {
                if (!ItemTagBuilder.this.isValid) {
                    return;
                }
                TagManager.ITEM.removeTag(ItemTagBuilder.this.tagName);
            }

            @Override
            public ItemAddable add(Item item) {
                return this.add(new ItemStack(item));
            }

            @Override
            public ItemAddable add(Item item, int metadata) {
                return this.add(new ItemStack(item, 1, metadata));
            }
        }
    }

    public static interface MultiCompleted {
    }

    public static interface Completed {
    }

    public static interface MultiBlockInitialState {
        public MultiBlockAddable add(@Nullable Block var1);

        public void removeTag();

        public MultiBlockRemoveKey removeKey(@Nullable Block var1);
    }

    public static interface MultiFluidInitialState {
        public MultiFluidAddable add(Fluid var1);

        public MultiFluidAddable add(@Nullable FluidStack var1);

        public void removeTag();

        public MultiFluidRemoveKey removeKey(Fluid var1);

        public MultiFluidRemoveKey removeKey(@Nullable FluidStack var1);
    }

    public static interface MultiItemInitialState {
        public MultiItemAddable add(Item var1);

        public MultiItemAddable add(Item var1, int var2);

        public MultiItemAddable add(@Nullable ItemStack var1);

        public void removeTag();

        public MultiItemRemoveKey removeKey(Item var1);

        public MultiItemRemoveKey removeKey(Item var1, int var2);

        public MultiItemRemoveKey removeKey(@Nullable ItemStack var1);
    }

    public static interface BlockInitialState {
        public BlockAddable add(@Nullable Block var1);

        public void removeTag();

        public BlockRemoveKey removeKey(@Nullable Block var1);
    }

    public static interface FluidInitialState {
        public FluidAddable add(Fluid var1);

        public FluidAddable add(@Nullable FluidStack var1);

        public void removeTag();

        public FluidRemoveKey removeKey(Fluid var1);

        public FluidRemoveKey removeKey(@Nullable FluidStack var1);
    }

    public static interface ItemInitialState {
        public ItemAddable add(Item var1);

        public ItemAddable add(Item var1, int var2);

        public ItemAddable add(@Nullable ItemStack var1);

        public void removeTag();

        public ItemRemoveKey removeKey(Item var1);

        public ItemRemoveKey removeKey(Item var1, int var2);

        public ItemRemoveKey removeKey(@Nullable ItemStack var1);
    }

    public static interface MultiBlockRemoveKey {
        public MultiBlockRemoveKey removeKey(@Nullable Block var1);
    }

    public static interface MultiFluidRemoveKey {
        public MultiFluidRemoveKey removeKey(Fluid var1);

        public MultiFluidRemoveKey removeKey(@Nullable FluidStack var1);
    }

    public static interface MultiItemRemoveKey {
        public MultiItemRemoveKey removeKey(Item var1);

        public MultiItemRemoveKey removeKey(Item var1, int var2);

        public MultiItemRemoveKey removeKey(@Nullable ItemStack var1);
    }

    public static interface BlockRemoveKey {
        public BlockRemoveKey removeKey(@Nullable Block var1);
    }

    public static interface FluidRemoveKey {
        public FluidRemoveKey removeKey(Fluid var1);

        public FluidRemoveKey removeKey(@Nullable FluidStack var1);
    }

    public static interface ItemRemoveKey {
        public ItemRemoveKey removeKey(Item var1);

        public ItemRemoveKey removeKey(Item var1, int var2);

        public ItemRemoveKey removeKey(@Nullable ItemStack var1);
    }

    public static interface MultiBlockAddable {
        public MultiBlockAddable add(@Nullable Block var1);
    }

    public static interface MultiFluidAddable {
        public MultiFluidAddable add(Fluid var1);

        public MultiFluidAddable add(@Nullable FluidStack var1);
    }

    public static interface MultiItemAddable {
        public MultiItemAddable add(Item var1);

        public MultiItemAddable add(Item var1, int var2);

        public MultiItemAddable add(@Nullable ItemStack var1);
    }

    public static interface BlockAddable {
        public BlockAddable add(@Nullable Block var1);
    }

    public static interface FluidAddable {
        public FluidAddable add(Fluid var1);

        public FluidAddable add(@Nullable FluidStack var1);
    }

    public static interface ItemAddable {
        public ItemAddable add(Item var1);

        public ItemAddable add(Item var1, int var2);

        public ItemAddable add(@Nullable ItemStack var1);
    }
}

