/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

interface Key {

    public static final class BlockKey
    implements Key {
        @Nonnull
        private final Block block;

        public BlockKey(@Nonnull Block block) {
            this.block = block;
        }

        @Nullable
        public static BlockKey toKey(@Nullable Block block) {
            if (block == null) {
                return null;
            }
            return new BlockKey(block);
        }

        @Nonnull
        public Block toElement() {
            return this.block;
        }

        public String toString() {
            return "BlockKey[" + "block=" + this.block + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((BlockKey)arg0).block, this.block);
            {
            }
        }

        @Nonnull
        public Block block() {
            return this.block;
        }
    }

    public static final class FluidKey
    implements Key {
        @Nonnull
        private final Fluid fluid;

        public FluidKey(@Nonnull Fluid fluid) {
            this.fluid = fluid;
        }

        @Nullable
        public static FluidKey toKey(@Nullable FluidStack stack) {
            if (stack == null || stack.getFluid() == null) {
                return null;
            }
            return new FluidKey(stack.getFluid());
        }

        @Nonnull
        public FluidStack toElement() {
            return new FluidStack(this.fluid, 1000);
        }

        public String toString() {
            return "FluidKey[" + "fluid=" + this.fluid + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.fluid != null ? this.fluid.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((FluidKey)arg0).fluid, this.fluid);
            {
            }
        }

        @Nonnull
        public Fluid fluid() {
            return this.fluid;
        }
    }

    public static final class ItemKey
    implements Key {
        @Nonnull
        private final Item item;
        private final int metadata;

        public ItemKey(@Nonnull Item item, int metadata) {
            this.item = item;
            this.metadata = metadata;
        }

        @Nullable
        public static ItemKey toKey(@Nullable ItemStack stack) {
            if (stack == null || stack.func_190926_b()) {
                return null;
            }
            int metadata = stack.func_77981_g() ? stack.func_77960_j() : 0;
            return new ItemKey(stack.func_77973_b(), metadata);
        }

        @Nonnull
        public ItemStack toElement() {
            return new ItemStack(this.item, 1, this.metadata);
        }

        public String toString() {
            return "ItemKey[" + "item=" + this.item + "," + "metadata=" + this.metadata + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.item != null ? this.item.hashCode() : 0);
            result = 31 * result + this.metadata;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((ItemKey)arg0).item, this.item)) {
                return false;
            }
            return ((ItemKey)arg0).metadata == this.metadata;
            {
            }
        }

        @Nonnull
        public Item item() {
            return this.item;
        }

        public int metadata() {
            return this.metadata;
        }
    }
}

