/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import com.gardenevery.tag.TagBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class OreSync {
    private static final Logger LOGGER = LogManager.getLogger((String)"OreSync");

    private OreSync() {
    }

    public static void oreDictionarySync() {
        String[] oreNames = OreDictionary.getOreNames();
        int totalEntries = 0;
        int failedEntries = 0;
        LOGGER.info("=== Starting Ore Dictionary Sync ===");
        LOGGER.info("Found {} ore dictionary categories", (Object)oreNames.length);
        for (String oreName : oreNames) {
            if (oreName == null || oreName.isEmpty()) continue;
            NonNullList ores = OreDictionary.getOres((String)oreName);
            for (ItemStack oreStack : ores) {
                if (oreStack.func_190926_b()) {
                    ++failedEntries;
                    continue;
                }
                try {
                    if (oreStack.func_77960_j() == Short.MAX_VALUE && oreStack.func_77973_b().func_77614_k()) {
                        int synced = OreSync.syncWildcardEntry(oreStack.func_77973_b(), oreName);
                        totalEntries += synced;
                        continue;
                    }
                    TagBuilder.item(oreName).add(oreStack.func_77946_l());
                    ++totalEntries;
                }
                catch (Exception e) {
                    ++failedEntries;
                    LOGGER.debug("Sync failed: {} - {}", (Object)oreName, (Object)oreStack.func_82833_r(), (Object)e);
                }
            }
        }
        LOGGER.info("=== Sync completed: {} successful, {} failed ===", (Object)totalEntries, (Object)failedEntries);
    }

    private static int syncWildcardEntry(Item item, String tagName) {
        int synced = 0;
        for (int meta = 0; meta < 16; ++meta) {
            try {
                ItemStack specificStack = new ItemStack(item, 1, meta);
                if (specificStack.func_190926_b() || specificStack.func_77973_b() != item) continue;
                TagBuilder.item(tagName).add(specificStack);
                ++synced;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (synced == 0) {
            ItemStack wildcardStack = new ItemStack(item, 1, Short.MAX_VALUE);
            TagBuilder.item(tagName).add(wildcardStack);
            synced = 1;
        }
        return synced;
    }
}

